/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.List;
import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.modern.ModernEclipseSource;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.modern.ModernEclipseSourceNewComposite;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.modern.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.core.nls.AbstractNlsTest;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.junit.Before;
import org.junit.Test;

public class SourceEclipseModernTest
extends AbstractNlsTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        m_testProject.addPlugin("org.eclipse.osgi");
    }

    @Test
    public void test_notModernEclipse_1() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('title');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceEclipseModernTest.assertEquals((long)0L, (long)support.getSources().length);
    }

    @Test
    public void test_notModernEclipse_2() throws Exception {
        SourceEclipseModernTest.setFileContentSrc("test/Strings.java", SourceEclipseModernTest.getSourceDQ("package test;", "public class Strings {", "  public static String MSG = 'Hello!';", "}"));
        SourceEclipseModernTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(Strings.MSG);", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceEclipseModernTest.assertEquals((long)0L, (long)support.getSources().length);
    }

    @Test
    public void test_parse() throws Exception {
        this.createAccessorAndProperties();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.frame_title);", "    setName(Messages.frame_name);", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceEclipseModernTest.assertEquals((long)1L, (long)sources.length);
        ModernEclipseSource source = (ModernEclipseSource)sources[0];
        SourceEclipseModernTest.assertEquals((Object)"Eclipse modern messages class", (Object)ReflectionUtils.invokeMethod((Object)source, (String)"getBundleComment()", (Object[])new Object[0]));
        frame.refresh();
        try {
            JFrame jFrame = (JFrame)frame.getObject();
            SourceEclipseModernTest.assertEquals((Object)"My JFrame", (Object)jFrame.getTitle());
            SourceEclipseModernTest.assertEquals((Object)"My name", (Object)jFrame.getName());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_constructorWithoutAccessor() throws Exception {
        SourceEclipseModernTest.setFileContentSrc("test/messages.properties", SourceEclipseModernTest.getSourceDQ("frame_title=My JFrame", "frame_name=My name"));
        SourceEclipseModernTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        ModernEclipseSource source = new ModernEclipseSource((JavaInfo)frame, null, "test.messages");
        IEditableSource editableSource = source.getEditable();
        SourceEclipseModernTest.assertEquals((Object)"My JFrame", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame_title"));
        SourceEclipseModernTest.assertEquals((Object)"My name", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame_name"));
    }

    @Test
    public void test_possibleSources() throws Exception {
        this.createAccessorAndProperties();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceEclipseModernTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        SourceEclipseModernTest.assertEquals((Object)"test.messages (Modern Eclipse messages class test.Messages)", (Object)editableSource.getLongTitle());
    }

    @Test
    public void test_apply_addKey() throws Exception {
        NlsTestUtils.create_EclipseModern_AccessorAndProperties();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        String frameSource = this.m_lastEditor.getSource();
        ModernEclipseSource source = new ModernEclipseSource((JavaInfo)frame, "test.Messages", "test.messages");
        source.apply_addKey("newKey");
        SourceEclipseModernTest.assertEditor(frameSource, this.m_lastEditor);
        String accessor = SourceEclipseModernTest.getFileContentSrc("test/Messages.java");
        Assertions.assertThat((String)accessor).contains(new CharSequence[]{"public static String newKey;"});
    }

    @Test
    public void test_externalize() throws Exception {
        SourceEclipseModernTest.setFileContentSrc("test/messages.properties", "");
        SourceEclipseModernTest.setFileContentSrc("test/Messages.java", SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"));
        SourceEclipseModernTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "    setName('My name');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceEclipseModernTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        StringPropertyInfo propertyInfo = new StringPropertyInfo((GenericProperty)frame.getPropertyByTitle("title"));
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        propertyInfo = new StringPropertyInfo((GenericProperty)frame.getPropertyByTitle("name"));
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.Test_this_title);", "    setName(Messages.Test_this_name);", "  }", "}");
        String messages = SourceEclipseModernTest.getFileContentSrc("test/Messages.java");
        SourceEclipseModernTest.assertEquals((Object)SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  public static String Test_this_title;", "  public static String Test_this_name;", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"), (Object)messages);
        String newProperties = SourceEclipseModernTest.getFileContentSrc("test/messages.properties");
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("#Eclipse modern messages class"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("Test_this_title=My JFrame"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("Test_this_name=My name"));
    }

    @Test
    public void test_externalize_qualifiedTypeName() throws Exception {
        SourceEclipseModernTest.setFileContentSrc("test/messages.properties", "");
        SourceEclipseModernTest.setFileContentSrc("test/Messages.java", SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"));
        SourceEclipseModernTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "    setName('My name');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceEclipseModernTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("nls.useQualifiedTypeNameForKey", true);
            StringPropertyInfo propertyInfo = new StringPropertyInfo((GenericProperty)frame.getPropertyByTitle("title"));
            editableSupport.externalizeProperty(propertyInfo, editableSource, true);
            propertyInfo = new StringPropertyInfo((GenericProperty)frame.getPropertyByTitle("name"));
            editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        }
        finally {
            preferences.restore();
        }
        support.applyEditable(editableSupport);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.test_Test_this_title);", "    setName(Messages.test_Test_this_name);", "  }", "}");
        String messages = SourceEclipseModernTest.getFileContentSrc("test/Messages.java");
        SourceEclipseModernTest.assertEquals((Object)SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  public static String test_Test_this_title;", "  public static String test_Test_this_name;", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"), (Object)messages);
        String newProperties = SourceEclipseModernTest.getFileContentSrc("test/messages.properties");
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("#Eclipse modern messages class"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("test_Test_this_title=My JFrame"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("test_Test_this_name=My name"));
    }

    @Test
    public void test_renameKey() throws Exception {
        this.createAccessorAndProperties();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.frame_title);", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        editableSource.renameKey("frame_title", "frame_title2");
        support.applyEditable(editableSupport);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.frame_title2);", "  }", "}");
        String messages = SourceEclipseModernTest.getFileContentSrc("test/Messages.java");
        SourceEclipseModernTest.assertEquals((Object)SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  public static String frame_title2;", "  public static String frame_name;", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"), (Object)messages);
        String newProperties = SourceEclipseModernTest.getFileContentSrc("test/messages.properties");
        SourceEclipseModernTest.assertFalse((boolean)newProperties.contains("frame_title=My JFrame"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("frame_title2=My JFrame"));
    }

    @Test
    public void test_internalize() throws Exception {
        this.createAccessorAndProperties();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.frame_title);", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        editableSource.internalizeKey("frame_title");
        support.applyEditable(editableSupport);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        String messages = SourceEclipseModernTest.getFileContentSrc("test/Messages.java");
        SourceEclipseModernTest.assertEquals((Object)SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  public static String frame_name;", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"), (Object)messages);
        String newProperties = SourceEclipseModernTest.getFileContentSrc("test/messages.properties");
        SourceEclipseModernTest.assertFalse((boolean)newProperties.contains("frame_title=My JFrame"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("frame_name=My name"));
    }

    @Test
    public void test_create() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = NlsTestUtils.createEmptyEditable("test.messages");
        editableSource.setKeyGeneratorStrategy(ModernEclipseSource.MODERN_KEY_GENERATOR);
        SourceParameters parameters = new SourceParameters();
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        parameters.m_accessorSourceFolder = javaProject.findPackageFragmentRoot((IPath)new Path("/TestProject/src"));
        parameters.m_accessorPackage = javaProject.findPackageFragment((IPath)new Path("/TestProject/src/test"));
        parameters.m_accessorPackageName = parameters.m_accessorPackage.getElementName();
        parameters.m_accessorClassName = "Messages";
        parameters.m_accessorFullClassName = "test.Messages";
        parameters.m_accessorExists = false;
        parameters.m_propertySourceFolder = parameters.m_accessorSourceFolder;
        parameters.m_propertyPackage = parameters.m_accessorPackage;
        parameters.m_propertyFileName = "messages.properties";
        parameters.m_propertyBundleName = "test.messages";
        parameters.m_propertyFileExists = false;
        editableSupport.addSource(editableSource, new SourceDescription(ModernEclipseSource.class, ModernEclipseSourceNewComposite.class), (Object)parameters);
        StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)frame).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.Test_this_title);", "  }", "}");
        String messages = StringUtils.replace((String)SourceEclipseModernTest.getFileContentSrc("test/Messages.java"), (String)"\r\n", (String)"\n");
        SourceEclipseModernTest.assertEquals((Object)SourceEclipseModernTest.getSourceDQ("package test;", "", "import org.eclipse.osgi.util.NLS;", "", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  public static String Test_this_title;", "  ////////////////////////////////////////////////////////////////////////////", "  //", "  // Constructor", "  //", "  ////////////////////////////////////////////////////////////////////////////", "  private Messages() {", "    // do not instantiate", "  }", "  ////////////////////////////////////////////////////////////////////////////", "  //", "  // Class initialization", "  //", "  ////////////////////////////////////////////////////////////////////////////", "  static {", "    // load message values from bundle file", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"), (Object)messages);
        String newProperties = SourceEclipseModernTest.getFileContentSrc("test/messages.properties");
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("#Eclipse modern messages class"));
        SourceEclipseModernTest.assertTrue((boolean)newProperties.contains("Test_this_title=My JFrame"));
    }

    private void createAccessorAndProperties() throws Exception {
        SourceEclipseModernTest.setFileContentSrc("test/messages.properties", SourceEclipseModernTest.getSourceDQ("frame_title=My JFrame", "frame_name=My name"));
        SourceEclipseModernTest.setFileContentSrc("test/Messages.java", SourceEclipseModernTest.getSourceDQ("package test;", "import org.eclipse.osgi.util.NLS;", "public class Messages extends NLS {", "  private static final String BUNDLE_NAME = 'test.messages'; //$NON-NLS-1$", "  public static String frame_title;", "  public static String frame_name;", "  private Messages() {}", "  static {", "    NLS.initializeMessages(BUNDLE_NAME, Messages.class);", "  }", "}"));
        SourceEclipseModernTest.waitForAutoBuild();
    }
}

