/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.WrapperMethodInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterAssociation;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterCreation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class MethodOrderTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_MethodOrderDescription_parse_bad() throws Exception {
        try {
            MethodOrder.parse((String)"noSuchMethodOrder");
            MethodOrderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_addMethodInvocation_default_default() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setAutoscrolls(true);", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    setAutoscrolls(true);", "  }", "}");
        MethodOrderTest.assertInstanceOf(MethodOrderAfterCreation.class, (Object)panel.getDescription().getDefaultMethodOrder());
    }

    @Test
    public void test_this_addMethodInvocation_default_afterCreation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public void foo(int value) {", "  }", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterCreation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MethodOrderTest.assertInstanceOf(MethodOrderAfterCreation.class, (Object)button.getDescription().getDefaultMethodOrder());
        button.addMethodInvocation("foo(int)", "555");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.foo(555);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_this_addMethodInvocation_default_afterAssociation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public void foo(int value) {", "  }", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MethodOrderTest.assertInstanceOf(MethodOrderAfterAssociation.class, (Object)button.getDescription().getDefaultMethodOrder());
        button.addMethodInvocation("foo(int)", "555");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      add(button);", "      button.foo(555);", "    }", "  }", "}");
    }

    private void prepare_first_setEnabled() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled' order='first'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
    }

    @Test
    public void test_first_addMethodInvocation() throws Exception {
        this.prepare_first_setEnabled();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "    setAutoscrolls(true);", "  }", "}");
    }

    @Test
    public void test_first_addMethodInvocation_inversionThis() throws Exception {
        this.prepare_first_setEnabled();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        panel.addMethodInvocation("setAutoscrolls(boolean)", "true");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "    setAutoscrolls(true);", "  }", "}");
    }

    @Test
    public void test_first_addMethodInvocation_inversion() throws Exception {
        this.prepare_first_setEnabled();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    myPanel.setEnabled(false);", "    add(myPanel);", "  }", "}");
        ContainerInfo panel = (ContainerInfo)MethodOrderTest.getJavaInfoByName("myPanel");
        panel.addMethodInvocation("setAutoscrolls(boolean)", "true");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    myPanel.setEnabled(false);", "    myPanel.setAutoscrolls(true);", "    add(myPanel);", "  }", "}");
    }

    @Test
    public void test_first_getTarget() throws Exception {
        this.prepare_first_setEnabled();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        ComponentInfo newButton = MethodOrderTest.createJButton();
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    private void prepare_setEnabled_after_setAutoscrolls() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled' order='after setAutoscrolls(boolean)'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
    }

    @Test
    public void test_addMethodInvocation_after_canReference() throws Exception {
        this.prepare_setEnabled_after_setAutoscrolls();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_addMethodInvocation_after_withTarget() throws Exception {
        this.prepare_setEnabled_after_setAutoscrolls();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_addMethodInvocation_after_withTarget2() throws Exception {
        this.prepare_setEnabled_after_setAutoscrolls();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "    setAutoscrolls(true);", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "    setAutoscrolls(true);", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_addMethodInvocation_after_noTarget() throws Exception {
        this.prepare_setEnabled_after_setAutoscrolls();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setFont(null);", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "    setFont(null);", "  }", "}");
    }

    @Test
    public void test_addMethodInvocation_after_transitivity() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setAutoscrolls' order='after setOpaque(boolean)'>", "      <parameter type='boolean'/>", "    </method>", "    <method name='setEnabled' order='after setAutoscrolls(boolean)'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setOpaque(false);", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setOpaque(false);", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_addMethodInvocation_after_inversion() throws Exception {
        this.prepare_setEnabled_after_setAutoscrolls();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        panel.addMethodInvocation("setAutoscrolls(boolean)", "true");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setFont(null);", "    setAutoscrolls(true);", "    setEnabled(false);", "  }", "}");
    }

    private void prepare_setEnabled_last() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled' order='last'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
    }

    @Test
    public void test_addMethodInvocation_last() throws Exception {
        this.prepare_setEnabled_last();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setAutoscrolls(true);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_getTarget_last() throws Exception {
        this.prepare_setEnabled_last();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        ComponentInfo newButton = MethodOrderTest.createJButton();
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_addMethodInvocation_last_whenWrapper() throws Exception {
        this.prepare_setEnabled_last_whenWrapper();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton wrapped = wrapper.getControl();", "  }", "}");
        Object wrapper = MethodOrderTest.getJavaInfoByName("wrapper");
        wrapper.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton wrapped = wrapper.getControl();", "    wrapper.setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_getTarget_last_whenWrapper_andNonExecutableInvocation() throws Exception {
        this.prepare_setEnabled_last_whenWrapper();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    wrapper.hashCode();", "    JButton wrapped = wrapper.getControl();", "  }", "}");
        Object wrapper = MethodOrderTest.getJavaInfoByName("wrapper");
        wrapper.addMethodInvocation("setEnabled(boolean)", "false");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    wrapper.hashCode();", "    JButton wrapped = wrapper.getControl();", "    wrapper.setEnabled(false);", "  }", "}");
    }

    private void prepare_setEnabled_last_whenWrapper() throws Exception {
        MethodOrderTest.setFileContentSrc("test/TestWrapper.java", this.getTestSource("public class TestWrapper {", "  JButton m_control;", "  public TestWrapper(Container parent){", "    m_control = new JButton();", "    m_control.setBounds(10, 10, 10, 10);", "    parent.add(m_control);", "  }", "  public JButton getControl(){", "    return m_control;", "  }", "  public void setEnabled(boolean enabled){", "  }", "}"));
        MethodOrderTest.setFileContentSrc("test/TestWrapper.wbp-component.xml", MethodOrderTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <toolkit id='org.eclipse.wb.swing'/>", "  <model class='" + WrapperMethodInfo.class.getName() + "'/>", "  <creation>", "    <source><![CDATA[new test.TestWrapper(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "  <methods>", "    <method name='setEnabled' order='last'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='Wrapper.method'>getControl</parameter>", "  </parameters>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
    }

    @Test
    public void test_beforeAssociation_addInvocation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='beforeAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      button.setEnabled(false);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)button, null);
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)button, 4), false);
    }

    @Test
    public void test_beforeAssociation_forThis_addInvocation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='beforeAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_beforeAssociation_forThis_exposed_addInvocation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyFrame.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyFrame extends JFrame {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyFrame.getContentPane__.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='beforeAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyFrame {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        ComponentInfo contentPane = (ComponentInfo)panel.getChildrenComponents().get(0);
        contentPane.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends MyFrame {", "  public Test() {", "    getContentPane().setEnabled(false);", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_beforeAssociation_lazy() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='beforeAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends JPanel {", "  private MyButton button;", "  public Test() {", "    add(getButton());", "  }", "  private MyButton getButton() {", "    if (button == null) {", "      button = new MyButton();", "      button.setDefaultCapable(true);", "    }", "    return button;", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends JPanel {", "  private MyButton button;", "  public Test() {", "    add(getButton());", "  }", "  private MyButton getButton() {", "    if (button == null) {", "      button = new MyButton();", "      button.setEnabled(false);", "      button.setDefaultCapable(true);", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_beforeAssociation_forRoot() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        MethodOrderAfterAssociation methodOrder = new MethodOrderAfterAssociation();
        StatementTarget target = methodOrder.getTarget((JavaInfo)panel, "noMatter()");
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_beforeAssociation_CREATE() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <invocation signature='setText(java.lang.String)'><![CDATA['New Button']]></invocation>", "  </creation>", "  <method-order>", "    <default order='beforeAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)MethodOrderTest.createJavaInfo("test.MyButton");
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      myButton.setText('New Button');", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_afterAssociation_forChild_addInvocation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      add(button);", "      button.setEnabled(false);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)button, null);
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)button, 4), false);
    }

    @Test
    public void test_afterAssociation_implicitAssociation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  public MyPanel() {", "    add(getContent());", "  }", "  protected abstract Component getContent();", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends MyPanel {", "  public Test() {", "  }", "  protected Component getContent() {", "    MyButton myButton = new MyButton();", "    myButton.setDefaultCapable(true);", "    return myButton;", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        MethodOrderTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: myButton} {/new MyButton()/ /myButton.setDefaultCapable(true)/ /myButton/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "  }", "  protected Component getContent() {", "    MyButton myButton = new MyButton();", "    myButton.setEnabled(false);", "    myButton.setDefaultCapable(true);", "    return myButton;", "  }", "}");
    }

    @Test
    public void test_afterAssociation_forThis_addInvocation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_afterAssociation_forThis_exposed_addInvocation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyFrame.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyFrame extends JFrame {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyFrame.getContentPane__.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyFrame {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        ComponentInfo contentPane = (ComponentInfo)panel.getChildrenComponents().get(0);
        contentPane.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends MyFrame {", "  public Test() {", "    getContentPane().setEnabled(false);", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_afterAssociation_forRoot() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        MethodOrderAfterAssociation methodOrder = new MethodOrderAfterAssociation();
        StatementTarget target = methodOrder.getTarget((JavaInfo)panel, "noMatter()");
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_afterAssociation_CREATE() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <invocation signature='setText(java.lang.String)'><![CDATA['New Button']]></invocation>", "  </creation>", "  <method-order>", "    <default order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)MethodOrderTest.createJavaInfo("test.MyButton");
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "      myButton.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_this_addMethodInvocation_thisSpecific_0() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    JPanel contentArea = new JPanel();", "    add(contentArea);", "    createDialogArea(contentArea);", "  }", "  protected abstract void createDialogArea(Container parent);", "}"));
        MethodOrderTest.setFileContentSrc("test/MyDialog.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled'>", "      <parameter type='boolean'/>", "      <tag name='thisTargetMethod' value='createDialogArea(java.awt.Container)'/>", "    </method>", "  </methods>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "  }", "}");
        panel.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_this_addMethodInvocation_thisSpecific_1() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    JPanel contentArea = new JPanel();", "    add(contentArea);", "    createDialogArea(contentArea);", "  }", "  protected void createDialogArea(Container parent) {", "  }", "}"));
        MethodOrderTest.setFileContentSrc("test/MyDialog.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled'>", "      <parameter type='boolean'/>", "      <tag name='thisTargetMethod' value='createDialogArea(java.awt.Container)'/>", "    </method>", "  </methods>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "    super.createDialogArea(parent);", "    int value;", "  }", "}");
        panel.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "    super.createDialogArea(parent);", "    setEnabled(false);", "    int value;", "  }", "}");
    }

    @Test
    public void test_afterCreation() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <default order='afterCreation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setEnabled(false);", "      button.setAutoscrolls(true);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)button, null);
        MethodOrderTest.assertTarget(target, null, MethodOrderTest.getStatement((JavaInfo)button, 4), false);
    }

    @Test
    public void test_rules_separateOrderForMethod() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <method signature='setSelected(boolean)' order='beforeAssociation'/>", "    <method signature='setEnabled(boolean)' order='afterAssociation'/>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MethodDescription method = button.getDescription().getMethod("setSelected(boolean)");
        String orderClassName = method.getOrder().getClass().getName();
        Assertions.assertThat((String)orderClassName).endsWith((CharSequence)"MethodOrderBeforeAssociation");
        method = button.getDescription().getMethod("setEnabled(boolean)");
        orderClassName = method.getOrder().getClass().getName();
        Assertions.assertThat((String)orderClassName).endsWith((CharSequence)"MethodOrderAfterAssociation");
    }

    @Test
    public void test_rules_severalMethods() throws Exception {
        MethodOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        MethodOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", MethodOrderTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <methods order='beforeAssociation'>", "      <s>setEnabled(boolean)</s>", "      <s>setSelected(boolean)</s>", "    </methods>", "    <methods order='afterAssociation'>", "      <s>setAutoscrolls(boolean)</s>", "    </methods>", "  </method-order>", "</component>"));
        MethodOrderTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton();", "      button.setAutoscrolls(true);", "      add(button);", "      button.setAutoscrolls(true);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MethodDescription method = button.getDescription().getMethod("setEnabled(boolean)");
        String orderClassName = method.getOrder().getClass().getName();
        Assertions.assertThat((String)orderClassName).endsWith((CharSequence)"MethodOrderBeforeAssociation");
        method = button.getDescription().getMethod("setSelected(boolean)");
        orderClassName = method.getOrder().getClass().getName();
        Assertions.assertThat((String)orderClassName).endsWith((CharSequence)"MethodOrderBeforeAssociation");
        method = button.getDescription().getMethod("setAutoscrolls(boolean)");
        orderClassName = method.getOrder().getClass().getName();
        Assertions.assertThat((String)orderClassName).endsWith((CharSequence)"MethodOrderAfterAssociation");
    }

    @Test
    public void test_afterChildren_invocations() throws Exception {
        this.configureProject_afterChildren();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("property_2");
        MethodOrderTest.assertNotNull((Object)property);
        property.setValue((Object)7);
        this.assertEditor("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "    setProperty_2(7);", "  }", "}");
        property = panel.getPropertyByTitle("property_1");
        MethodOrderTest.assertNotNull((Object)property);
        property.setValue((Object)112);
        this.assertEditor("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "    setProperty_2(7);", "    setProperty_1(112);", "  }", "}");
    }

    @Test
    public void test_afterChildren_betweenAddedChildren() throws Exception {
        this.configureProject_afterChildren();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "  }", "}");
        JavaInfo item1 = JavaInfoUtils.createJavaInfo((AstEditor)panel.getEditor(), (String)"test.ItemPanel1", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)item1, null, (JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "  }", "}");
        JavaInfo item2 = JavaInfoUtils.createJavaInfo((AstEditor)panel.getEditor(), (String)"test.ItemPanel2", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)item2, null, (JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "  }", "}");
        Property property = panel.getPropertyByTitle("property_2");
        MethodOrderTest.assertNotNull((Object)property);
        property.setValue((Object)7);
        this.assertEditor("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    setProperty_2(7);", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "  }", "}");
        property = panel.getPropertyByTitle("property_1");
        MethodOrderTest.assertNotNull((Object)property);
        property.setValue((Object)112);
        this.assertEditor("// filler filler filler", "public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    setProperty_2(7);", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "    setProperty_1(112);", "  }", "}");
    }

    @Test
    public void test_afterChildren_betweenChildren() throws Exception {
        this.configureProject_afterChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "  }", "}");
        Property property = panel.getPropertyByTitle("property_2");
        MethodOrderTest.assertNotNull((Object)property);
        property.setValue((Object)7);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    setProperty_2(7);", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "  }", "}");
        property = panel.getPropertyByTitle("property_1");
        MethodOrderTest.assertNotNull((Object)property);
        property.setValue((Object)112);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    setProperty_2(7);", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "    setProperty_1(112);", "  }", "}");
    }

    @Test
    public void test_afterChildren_addChild() throws Exception {
        this.configureProject_afterChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    setProperty_2(7);", "    setProperty_1(112);", "  }", "}");
        JavaInfo item2 = JavaInfoUtils.createJavaInfo((AstEditor)panel.getEditor(), (String)"test.ItemPanel2", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)item2, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    setProperty_2(7);", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "    setProperty_1(112);", "  }", "}");
        JavaInfo item1 = JavaInfoUtils.createJavaInfo((AstEditor)panel.getEditor(), (String)"test.ItemPanel1", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)item1, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel1 itemPanel1 = new ItemPanel1(this);", "    }", "    setProperty_2(7);", "    {", "      ItemPanel2 itemPanel2 = new ItemPanel2(this);", "    }", "    setProperty_1(112);", "  }", "}");
    }

    private void configureProject_afterChildren() throws Exception {
        this.setJavaContentSrc("test", "ItemPanel1", new String[]{"public class ItemPanel1 extends JPanel {", "  public ItemPanel1(JPanel parent){", "    parent.add(this);", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.ItemPanel1(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"});
        this.setJavaContentSrc("test", "ItemPanel2", new String[]{"public class ItemPanel2 extends JPanel {", "  public ItemPanel2(JPanel parent){", "    parent.add(this);", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.ItemPanel2(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"});
        this.setJavaContentSrc("test", "ContainerPanel", new String[]{"public class ContainerPanel extends JPanel {", "  public void setProperty_1(int value){", "  }", "  public void setProperty_2(int value){", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <method signature='setProperty_1(int)' order='last'/>", "    <method signature='setProperty_2(int)' order='afterChildren test.ItemPanel1'/>", "  </method-order>", "</component>"});
    }

    @Test
    public void test_afterParentChildren_invocation() throws Exception {
        this.configureProject_afterParentChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    setProperty(new PropertyItem());", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "  }", "}");
        List childrenComponents = panel.getChildrenComponents();
        JavaInfo propertyItemInfo = (JavaInfo)childrenComponents.get(0);
        MethodOrderTest.assertEquals((Object)propertyItemInfo.getDescription().getComponentClass().getCanonicalName(), (Object)"test.PropertyItem");
        JavaInfo panelItemInfo = (JavaInfo)childrenComponents.get(1);
        MethodOrderTest.assertInstanceOf(JPanelInfo.class, (Object)panelItemInfo);
        Property property = propertyItemInfo.getPropertyByTitle("value");
        property.setValue((Object)10);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    PropertyItem propertyItem = new PropertyItem();", "    setProperty(propertyItem);", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    propertyItem.setValue(10);", "  }", "}");
    }

    @Test
    public void test_afterParentChildren_invocationAsLast() throws Exception {
        this.configureProject_afterParentChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    setProperty(new PropertyItem());", "  }", "}");
        List childrenComponents = panel.getChildrenComponents();
        JavaInfo panelItemInfo = (JavaInfo)childrenComponents.get(0);
        MethodOrderTest.assertInstanceOf(JPanelInfo.class, (Object)panelItemInfo);
        JavaInfo propertyItemInfo = (JavaInfo)childrenComponents.get(1);
        MethodOrderTest.assertEquals((Object)propertyItemInfo.getDescription().getComponentClass().getCanonicalName(), (Object)"test.PropertyItem");
        Property property = propertyItemInfo.getPropertyByTitle("value");
        property.setValue((Object)50);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    PropertyItem propertyItem = new PropertyItem();", "    setProperty(propertyItem);", "    propertyItem.setValue(50);", "  }", "}");
    }

    @Test
    public void test_afterParentChildren_addChild() throws Exception {
        this.configureProject_afterParentChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    setProperty(new PropertyItem());", "  }", "}");
        List childrenComponents = panel.getChildrenComponents();
        JavaInfo propertyItemInfo = (JavaInfo)childrenComponents.get(0);
        MethodOrderTest.assertEquals((Object)propertyItemInfo.getDescription().getComponentClass().getCanonicalName(), (Object)"test.PropertyItem");
        Property property = propertyItemInfo.getPropertyByTitle("value");
        property.setValue((Object)100);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    PropertyItem propertyItem = new PropertyItem();", "    setProperty(propertyItem);", "    propertyItem.setValue(100);", "  }", "}");
        JavaInfo item = JavaInfoUtils.createJavaInfo((AstEditor)panel.getEditor(), (String)"test.ItemPanel", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)item, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    PropertyItem propertyItem = new PropertyItem();", "    setProperty(propertyItem);", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    propertyItem.setValue(100);", "  }", "}");
    }

    @Test
    public void test_afterParentChildren_invocationBlockFirst() throws Exception {
        this.configureProject_afterParentChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      setProperty(new PropertyItem());", "    }", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "  }", "}");
        List childrenComponents = panel.getChildrenComponents();
        JavaInfo propertyInfo = (JavaInfo)childrenComponents.get(0);
        childrenComponents.get(1);
        propertyInfo.getPropertyByTitle("value").setValue((Object)10);
        this.assertEditor("public class Test extends ContainerPanel {", "  private PropertyItem propertyItem;", "  public Test() {", "    {", "      propertyItem = new PropertyItem();", "      setProperty(propertyItem);", "    }", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    propertyItem.setValue(10);", "  }", "}");
    }

    @Test
    public void test_afterParentChildren_invocationBlockLast() throws Exception {
        this.configureProject_afterParentChildren();
        ContainerInfo panel = this.parseContainer("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    {", "      setProperty(new PropertyItem());", "    }", "  }", "}");
        List childrenComponents = panel.getChildrenComponents();
        childrenComponents.get(0);
        JavaInfo propertyInfo = (JavaInfo)childrenComponents.get(1);
        propertyInfo.getPropertyByTitle("value").setValue((Object)10);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    {", "      PropertyItem propertyItem = new PropertyItem();", "      setProperty(propertyItem);", "      propertyItem.setValue(10);", "    }", "  }", "}");
        JavaInfo item = JavaInfoUtils.createJavaInfo((AstEditor)panel.getEditor(), (String)"test.ItemPanel", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)item, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends ContainerPanel {", "  public Test() {", "    {", "      ItemPanel itemPanel = new ItemPanel(this);", "    }", "    {", "      PropertyItem propertyItem = new PropertyItem();", "      setProperty(propertyItem);", "      {", "        ItemPanel itemPanel = new ItemPanel(this);", "      }", "      propertyItem.setValue(10);", "    }", "  }", "}");
    }

    private void configureProject_afterParentChildren() throws Exception {
        this.setJavaContentSrc("test", "ItemPanel", new String[]{"public class ItemPanel extends JPanel {", "  public ItemPanel(JPanel parent){", "    parent.add(this);", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.ItemPanel(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"});
        this.setJavaContentSrc("test", "PropertyItem", new String[]{"public class PropertyItem extends Component {", "  public PropertyItem(){", "  }", "  public void setValue(int value){", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <method-order>", "    <method signature='setValue(int)' order='afterParentChildren test.ItemPanel'/>", "  </method-order>", "</component>"});
        this.setJavaContentSrc("test", "ContainerPanel", new String[]{"public class ContainerPanel extends JPanel {", "  public void setProperty(test.PropertyItem value){", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setProperty'>", "      <parameter type='test.PropertyItem' child='true'/>", "    </method>", "  </methods>", "</component>"});
        MethodOrderTest.waitForAutoBuild();
    }
}

