/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.table;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.tests.designer.core.model.property.table.AbstractPropertyTableTest;
import org.junit.Test;

public class PropertyTableEditorsTest
extends AbstractPropertyTableTest {
    private static final PropertyEditor stringEditor = StringPropertyEditor.INSTANCE;

    @Test
    public void test_1_noProperty() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor);
        this.m_propertyTable.setInput(new Property[]{property});
        PropertyTableEditorsTest.assertNull((Object)this.m_propertyTable.forTests_getActiveEditor());
        this.m_sender.click(this.m_propertyTable.getSplitter() + 10, 100, 1);
        PropertyTableEditorsTest.waitEventLoop(10);
        PropertyTableEditorsTest.assertNull((Object)this.m_propertyTable.forTests_getActiveEditor());
    }

    @Test
    public void test_2_activateDeactivate() throws Exception {
        PropertyEditor xEditor = StringPropertyEditor.INSTANCE;
        PropertyEditor yEditor = StringPropertyEditor.INSTANCE;
        AbstractPropertyTableTest.TestProperty propertyX = new AbstractPropertyTableTest.TestProperty("x", true, "100", xEditor);
        AbstractPropertyTableTest.TestProperty propertyY = new AbstractPropertyTableTest.TestProperty("y", true, "200", yEditor);
        AbstractPropertyTableTest.TestProperty propertyXY = new AbstractPropertyTableTest.TestProperty("location", true, "100, 200", (PropertyEditor)new AbstractPropertyTableTest.ComplexEditor(new Property[]{propertyX, propertyY}));
        this.m_propertyTable.setInput(new Property[]{propertyXY});
        PropertyTableEditorsTest.waitEventLoop(10);
        PropertyTableEditorsTest.assertNull((Object)this.m_propertyTable.forTests_getValueLocation(null));
        Point locationSXY = this.m_propertyTable.forTests_getStateLocation((Property)propertyXY);
        this.m_sender.click(locationSXY, 1);
        PropertyTableEditorsTest.waitEventLoop(10);
        PropertyTableEditorsTest.assertNull((Object)this.m_propertyTable.forTests_getActiveEditor());
        Point locationVX = this.m_propertyTable.forTests_getValueLocation((Property)propertyX);
        this.m_sender.click(locationVX, 1);
        PropertyTableEditorsTest.assertSame((Object)xEditor, (Object)this.m_propertyTable.forTests_getActiveEditor());
        PropertyTableEditorsTest.waitEventLoop(10);
        Point locationVY = this.m_propertyTable.forTests_getValueLocation((Property)propertyY);
        this.m_sender.click(locationVY, 1);
        PropertyTableEditorsTest.assertSame((Object)yEditor, (Object)this.m_propertyTable.forTests_getActiveEditor());
        PropertyTableEditorsTest.waitEventLoop(10);
        this.m_sender.click(locationSXY, 1);
        PropertyTableEditorsTest.waitEventLoop(10);
        PropertyTableEditorsTest.assertNull((Object)this.m_propertyTable.forTests_getActiveEditor());
    }
}

