/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.nonvisual;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualAssociation;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanContainerInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.Test;

public class NonVisualBeansTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noBeans() throws Exception {
        ContainerInfo panel = this.parseContainer("import java.util.ArrayList;", "class Test extends JPanel {", "  private ArrayList m_testBean = new ArrayList();", "  Test() {", "  }", "}");
        NonVisualBeansTest.assertNull((Object)NonVisualBeanContainerInfo.find((JavaInfo)panel));
    }

    @Test
    public void test_constructorBean() throws Exception {
        ContainerInfo panel = this.parseContainer("import java.util.ArrayList;", "class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private ArrayList m_testBean = new ArrayList();", "  Test() {", "  }", "}");
        NonVisualBeansTest.test_nonVisual(panel);
        NonVisualBeansTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {NonVisualBeans}", "    {new: java.util.ArrayList} {field-initializer: m_testBean} {/new ArrayList()/}");
        JavaInfo bean = NonVisualBeansTest.getNVO(panel);
        NonVisualBeansTest.assertInstanceOf(NonVisualAssociation.class, (Object)bean.getAssociation());
    }

    @Test
    public void test_swingBean() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private JButton m_testBean = new JButton();", "  Test() {", "  }", "}");
        panel.refresh();
        NonVisualBeansTest.test_nonVisual(panel);
    }

    @Test
    public void test_isNVO() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private JButton button = new JButton();", "  Test() {", "  }", "}");
        Object button = NonVisualBeansTest.getJavaInfoByName("button");
        NonVisualBeansTest.assertFalse((boolean)NonVisualBeanInfo.isNVO((JavaInfo)panel));
        NonVisualBeansTest.assertTrue((boolean)NonVisualBeanInfo.isNVO(button));
    }

    @Test
    public void test_staticFactory() throws Exception {
        NonVisualBeansTest.setFileContentSrc("test/MyStaticFactory.java", this.getTestSource("public final class MyStaticFactory {", "  public static Object createTestBean() {", "    return new Object();", "  }", "}"));
        NonVisualBeansTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("import java.util.ArrayList;", "class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private Object m_testBean = MyStaticFactory.createTestBean();", "  Test() {", "  }", "}");
        NonVisualBeansTest.test_nonVisual(panel);
    }

    @Test
    public void test_instanceFactory() throws Exception {
        NonVisualBeansTest.setFileContentSrc("test/MyInstanceFactory.java", this.getTestSource("public final class MyInstanceFactory {", "  public Object createTestBean() {", "    return new Object();", "  }", "}"));
        NonVisualBeansTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("import java.util.ArrayList;", "class Test extends JPanel {", "  private MyInstanceFactory factory = new MyInstanceFactory();", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private Object m_testBean = factory.createTestBean();", "  Test() {", "  }", "}");
        NonVisualBeansTest.test_nonVisual(panel);
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  Test() {", "  }", "}");
        NonVisualBeansTest.assertNull((Object)NonVisualBeanContainerInfo.find((JavaInfo)panel));
        Object newInfo = NonVisualBeansTest.createJavaInfo("java.util.ArrayList");
        NonVisualBeanContainerInfo.add((JavaInfo)panel, newInfo, (Point)new Point(10, 20));
        NonVisualBeansTest.test_nonVisual(panel);
        this.assertEditor("import java.util.ArrayList;", "// filler filler filler", "class Test extends JPanel {", "  /**", "\t * @wbp.nonvisual location=10,20", "\t */", "  private final ArrayList arrayList = new ArrayList();", "  Test() {", "  }", "}");
    }

    @Test
    public void test_moveBean() throws Exception {
        ContainerInfo panel = this.parseContainer("import java.util.ArrayList;", "class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private ArrayList m_testBean = new ArrayList();", "  Test() {", "  }", "}");
        NonVisualBeanInfo beanInfo = NonVisualBeansTest.test_nonVisual(panel);
        beanInfo.moveLocation(new Point(5, 7));
        NonVisualBeansTest.assertEquals((Object)new Point(15, 27), (Object)beanInfo.getLocation());
        this.assertEditor("import java.util.ArrayList;", "class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=15,27", "  */", "  private ArrayList m_testBean = new ArrayList();", "  Test() {", "  }", "}");
    }

    @Test
    public void test_convertInto_VO() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private JButton m_button = new JButton();", "  Test() {", "  }", "}");
        NonVisualBeansTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {NonVisualBeans}", "    {new: javax.swing.JButton} {field-initializer: m_button} {/new JButton()/}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)NonVisualBeansTest.getNVO(panel);
        NonVisualBeansTest.assertInstanceOf(NonVisualAssociation.class, (Object)button.getAssociation());
        ((FlowLayoutInfo)panel.getLayout()).move(button, null);
        this.assertEditor("class Test extends JPanel {", "  private JButton m_button = new JButton();", "  Test() {", "    add(m_button);", "  }", "}");
        NonVisualBeansTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(m_button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {NonVisualBeans}", "  {new: javax.swing.JButton} {field-initializer: m_button} {/new JButton()/ /add(m_button)/}");
        NonVisualBeansTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_lazy_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private Object m_testBean;", "  Test() {", "  }", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private Object getTestBean() {", "    if (m_testBean == null) {", "      m_testBean = new Object();", "    }", "    return m_testBean;", "  }", "}");
        NonVisualBeansTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {NonVisualBeans}", "    {new: java.lang.Object} {lazy: m_testBean getTestBean()} {/new Object()/ /m_testBean/}");
        NonVisualBeansTest.test_nonVisual(panel);
        JavaInfo bean = NonVisualBeansTest.getNVO(panel);
        NonVisualBeansTest.assertInstanceOf(NonVisualAssociation.class, (Object)bean.getAssociation());
    }

    @Test
    public void test_lazy_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        NonVisualBeansTest.assertNull((Object)NonVisualBeanContainerInfo.find((JavaInfo)panel));
        Object newNVO = NonVisualBeansTest.createJavaInfo("java.lang.Object");
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        NonVisualBeanContainerInfo.add((JavaInfo)panel, newNVO, (Point)new Point(10, 20));
        NonVisualBeansTest.test_nonVisual(panel);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private Object object;", "  public Test() {", "  }", "  /**", "\t * @wbp.nonvisual location=10,20", "\t */", "  private Object getObject() {", "    if (object == null) {", "      object = new Object();", "    }", "    return object;", "  }", "}");
        panel.refresh();
        NonVisualBeansTest.assertNotNull((Object)newNVO.getObject());
    }

    private static NonVisualBeanInfo test_nonVisual(ContainerInfo panel) throws Exception {
        JavaInfo child = NonVisualBeansTest.getNVO(panel);
        NonVisualBeansTest.assertInstanceOf(NonVisualAssociation.class, (Object)child.getAssociation());
        NonVisualBeanInfo beanInfo = NonVisualBeanInfo.getNonVisualInfo((JavaInfo)child);
        NonVisualBeansTest.assertNotNull((Object)beanInfo);
        NonVisualBeansTest.assertEquals((Object)new Point(10, 20), (Object)beanInfo.getLocation());
        return beanInfo;
    }

    private static JavaInfo getNVO(ContainerInfo panel) {
        NonVisualBeanContainerInfo container = NonVisualBeanContainerInfo.find((JavaInfo)panel);
        NonVisualBeansTest.assertNotNull((Object)container);
        List children = container.getChildren(JavaInfo.class);
        Assertions.assertThat((List)children).hasSize(1);
        return (JavaInfo)children.get(0);
    }
}

