/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class GenericPropertyDescriptionTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setter_getType() throws Exception {
        GenericPropertyDescriptionTest.setFileContentSrc("test/MyObject.java", GenericPropertyDescriptionTest.getSourceDQ("package test;", "public class MyObject {", "  public void setA(int value) {", "  }", "  public void setB(double value) {", "  }", "  public void setC(String value) {", "  }", "}"));
        GenericPropertyDescriptionTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescriptionTest.assertPropertyType(description, "setA(int)", Integer.TYPE);
        GenericPropertyDescriptionTest.assertPropertyType(description, "setB(double)", Double.TYPE);
        GenericPropertyDescriptionTest.assertPropertyType(description, "setC(java.lang.String)", String.class);
    }

    @Test
    public void test_field_getType() throws Exception {
        GenericPropertyDescriptionTest.setFileContentSrc("test/MyObject.java", GenericPropertyDescriptionTest.getSourceDQ("package test;", "public class MyObject {", "  public int a;", "  public double b;", "  public String c;", "}"));
        GenericPropertyDescriptionTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescriptionTest.assertPropertyType(description, "a", Integer.TYPE);
        GenericPropertyDescriptionTest.assertPropertyType(description, "b", Double.TYPE);
        GenericPropertyDescriptionTest.assertPropertyType(description, "c", String.class);
    }

    private static void assertPropertyType(ComponentDescription description, String id, Class<?> expectedType) {
        GenericPropertyDescription property = description.getProperty(id);
        GenericPropertyDescriptionTest.assertSame(expectedType, (Object)property.getType());
    }

    private ComponentDescription getMyObjectDescription() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        return ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyObject");
    }

    @Test
    public void test_JavaBean_preferred() throws Exception {
        GenericPropertyDescriptionTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private String m_value;", "  public String getValue() {", "    return m_value;", "  }", "  public void setValue(String value) {", "    m_value = value;", "  }", "}"));
        GenericPropertyDescriptionTest.setFileContentSrc("test/MyPanelBeanInfo.java", this.getTestSource("import java.beans.*;", "public class MyPanelBeanInfo extends SimpleBeanInfo {", "  private PropertyDescriptor[] m_descriptors;", "  public MyPanelBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JPanel.class);", "      PropertyDescriptor[] descriptors = info.getPropertyDescriptors();", "      m_descriptors = new PropertyDescriptor[descriptors.length + 1];", "      System.arraycopy(descriptors, 0, m_descriptors, 0, descriptors.length);", "      m_descriptors[descriptors.length] = new PropertyDescriptor('value', MyPanel.class, 'getValue', 'setValue');", "      m_descriptors[descriptors.length].setPreferred(true);", "    } catch (Throwable e) {", "    }", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_descriptors;", "  }", "}"));
        GenericPropertyDescriptionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("value");
        GenericPropertyDescriptionTest.assertNotNull((Object)property);
        GenericPropertyDescriptionTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)property.getCategory());
    }
}

