/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.awt.Container;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.UnknownAssociation;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.creation.MethodParameterCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.variable.MethodParameterVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class ComponentDescriptionHelperTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_objectIcon() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyObject.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public class MyObject {", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        JavaInfo panel = this.parseSource("test", "Test_1.java", this.getTestSource("public class Test_1 extends JPanel {", "  public Test_1() {", "  }", "}"));
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, Object.class);
        ComponentDescriptionHelperTest.assertNotNull((Object)description.getIcon());
        try {
            panel.refresh();
        }
        finally {
            panel.refresh_dispose();
            panel.getBroadcastObject().dispose();
        }
        panel = this.parseSource("test", "Test_2.java", this.getTestSource("public class Test_2 extends JPanel {", "  public Test_2() {", "  }", "}"));
        description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, Object.class);
        ComponentDescriptionHelperTest.assertNotNull((Object)description.getIcon());
        try {
            panel.refresh();
        }
        finally {
            panel.refresh_dispose();
            panel.getBroadcastObject().dispose();
        }
    }

    @Test
    public void test_iconsForInterfaces() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/IComponent.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public interface IComponent {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/IComponent.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <toolkit id='org.eclipse.wb.swing'/>", "  <model class='org.eclipse.wb.core.model.JavaInfo'/>", "</component>"));
        TestUtils.createImagePNG(m_testProject, "src/test/IComponent.png", 1, 1);
        ComponentDescriptionHelperTest.setFileContentSrc("test/Component.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public class Component implements IComponent {", "}"));
        TestUtils.createImagePNG(m_testProject, "src/test/Component.png", 2, 2);
        ComponentDescriptionHelperTest.setFileContentSrc("test/Component_2.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public class Component_2 implements IComponent {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyComponent_1.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public class MyComponent_1 extends Component {", "}"));
        TestUtils.createImagePNG(m_testProject, "src/test/MyComponent_1.png", 3, 3);
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyComponent_2.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public class MyComponent_2 extends Component {", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.IComponent");
        ComponentDescriptionHelperTest.assertEquals((long)description.getIcon().getImageData((int)100).width, (long)1L);
        description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.Component");
        ComponentDescriptionHelperTest.assertEquals((long)description.getIcon().getImageData((int)100).width, (long)2L);
        description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.Component_2");
        ComponentDescriptionHelperTest.assertEquals((long)description.getIcon().getImageData((int)100).width, (long)1L);
        description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComponent_1");
        ComponentDescriptionHelperTest.assertEquals((long)description.getIcon().getImageData((int)100).width, (long)3L);
        description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComponent_2");
        ComponentDescriptionHelperTest.assertEquals((long)description.getIcon().getImageData((int)100).width, (long)2L);
    }

    @Test
    public void test_unknow_propertyEditor() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public void setQ(int q) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setQ(int)'>", "    <editor id='no-such-editor'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        try {
            this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
            ComponentDescriptionHelperTest.fail();
        }
        catch (DesignerException e) {
            ComponentDescriptionHelperTest.assertInstanceOf(IllegalArgumentException.class, (Object)DesignerExceptionUtils.getRootCause((Throwable)e));
        }
    }

    @Test
    public void test_BeanInfo_icon() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanelBeanInfo.java", this.getTestSource("import java.awt.image.*;", "public class MyPanelBeanInfo extends java.beans.SimpleBeanInfo {", "  public Image getIcon(int iconKind) {", "    return new BufferedImage(10, 15, BufferedImage.TYPE_INT_RGB);", "  }", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescription description = panel.getDescription();
        ComponentDescriptionHelperTest.assertNotNull((Object)description.getBeanInfo());
        ImageDescriptor icon = description.getIcon();
        ComponentDescriptionHelperTest.assertEquals((long)10L, (long)icon.getImageData((int)100).width);
        ComponentDescriptionHelperTest.assertEquals((long)15L, (long)icon.getImageData((int)100).height);
    }

    @Test
    public void test_cachedComponentDescriptions() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentDescriptionHelperTest.assertTrue((boolean)panel.getDescription().isCached());
        ComponentDescriptionHelperTest.assertFalse((boolean)button.getDescription().isCached());
    }

    @Test
    public void test_cachedComponentDescriptions_noCacheParameter() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = NotCachedButton.class.getName();
            String descriptionsPath = "wbp-meta/" + CodeUtils.getPackage((String)className).replace('.', '/') + "/";
            testBundle.addClass(NotCachedButton.class);
            testBundle.setFile(descriptionsPath + ".wbp-cache-descriptions", "Please, cache this package.");
            testBundle.setFile(descriptionsPath + CodeUtils.getShortClass((String)className) + ".wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='dontCacheDescription'>true</parameter>", "  </parameters>", "</component>"));
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-bundle bundle='" + testBundle.getId() + "'/>", "</toolkit>");
            testBundle.install(true);
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)className);
                ComponentDescriptionHelperTest.assertFalse((boolean)description.isCached());
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_presentationCaching_use_forStandardComponents() throws Exception {
        String[] lines = new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"javax.swing.JButton");
        ComponentDescriptionHelperTest.assertTrue((boolean)description.isPresentationCached());
    }

    @Test
    public void test_presentationCaching_disable_forComponentInProject() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"));
        TestUtils.createImagePNG(m_testProject, "src/test/MyButton.png", 10, 10);
        ComponentDescriptionHelperTest.waitForAutoBuild();
        String[] lines = new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyButton");
        ComponentDescriptionHelperTest.assertFalse((boolean)description.isPresentationCached());
    }

    @Test
    public void test_source_fromProjectMeta() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContent("wbp-meta/test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>My description</description>", "  <parameters>", "    <parameter name='parameter_1'>AAA</parameter>", "  </parameters>", "</component>"));
        this.createImagePNG("wbp-meta/test/MyPanel.png", 10, 10);
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescription description = panel.getDescription();
        ComponentDescriptionHelperTest.assertEquals((Object)"AAA", (Object)description.getParameter("parameter_1"));
        ComponentDescriptionHelperTest.assertEquals((Object)"My description", (Object)description.getDescription());
        ImageDescriptor icon = description.getIcon();
        ComponentDescriptionHelperTest.assertEquals((long)icon.getImageData((int)100).width, (long)10L);
        ComponentDescriptionHelperTest.assertEquals((long)icon.getImageData((int)100).height, (long)10L);
    }

    @Test
    public void test_textualDescription_plainText() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContent("wbp-meta/test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>My description</description>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        String description = panel.getDescription().getDescription();
        ComponentDescriptionHelperTest.assertEquals((Object)"My description", (Object)description);
    }

    @Test
    public void test_textualDescription_HTML() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContent("wbp-meta/test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>My &lt;b&gt;cool&lt;/b&gt; description</description>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        String description = panel.getDescription().getDescription();
        ComponentDescriptionHelperTest.assertEquals((Object)"My <b>cool</b> description", (Object)description);
    }

    @Test
    public void test_defaultPropertyValue_true() throws Exception {
        this.assert_defaultPropertyValue("boolean", "true", Boolean.TRUE);
    }

    @Test
    public void test_defaultPropertyValue_false() throws Exception {
        this.assert_defaultPropertyValue("boolean", "false", Boolean.FALSE);
    }

    @Test
    public void test_defaultPropertyValue_intPositive() throws Exception {
        this.assert_defaultPropertyValue("int", "10", 10);
    }

    @Test
    public void test_defaultPropertyValue_intNegative() throws Exception {
        this.assert_defaultPropertyValue("int", "-10", -10);
    }

    @Test
    public void test_defaultPropertyValue_intExpression() throws Exception {
        this.assert_defaultPropertyValue("int", "1 + 2 * 3", 7);
    }

    @Test
    public void test_defaultPropertyValue_intStaticField() throws Exception {
        this.assert_defaultPropertyValue("int", "javax.swing.SwingConstants.RIGHT", 4);
    }

    @Test
    public void test_defaultPropertyValue_stringValue() throws Exception {
        this.assert_defaultPropertyValue("java.lang.String", "\"str\"", "str");
    }

    @Test
    public void test_defaultPropertyValue_objectValue() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/Position.java", ComponentDescriptionHelperTest.getSourceDQ("package test;", "public class Position {", "  public static Position LEFT = new Position('left');", "  public static Position RIGHT = new Position('right');", "  public static Position CENTER = new Position('center');", "  private String position;", "  private Position(String position) {", "    this.position = position;", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setValue(test.Position value) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setValue(test.Position)'>", "    <editor id='staticField'>", "      <parameter name='class'>test.Position</parameter>", "      <parameter name='fields'>LEFT RIGHT CENTER</parameter>", "    </editor>", "    <defaultValue value='test.Position.LEFT'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertEquals((Object)"LEFT", (Object)ComponentDescriptionHelperTest.getPropertyText(panel.getPropertyByTitle("value")));
        this.disposeLastModel();
        ComponentDescriptionHelperTest.getFileSrc("test/Test.java").delete(true, null);
        panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertEquals((Object)"LEFT", (Object)ComponentDescriptionHelperTest.getPropertyText(panel.getPropertyByTitle("value")));
    }

    @Test
    public void test_defaultPropertyValue_bad() throws Exception {
        try {
            this.assert_defaultPropertyValue("boolean", "bad-string", null);
            ComponentDescriptionHelperTest.fail();
        }
        catch (DesignerException designerException) {
            // empty catch block
        }
    }

    @Test
    public void test_defaultPropertyValue_ignoreAccessor() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public int getFoo() {", "    return 5;", "  }", "  public void setFoo(int foo) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setFoo(int)'>", "    <defaultValue value='2'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertEquals((Object)2, (Object)panel.getPropertyByTitle("foo").getValue());
    }

    private void prepare_defaultPropertyValue(String propertyType, String defaultValueString) throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public void setQ(" + propertyType + " q) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setQ(" + propertyType + ")'>", "    <defaultValue value='" + defaultValueString + "'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
    }

    private void assert_defaultPropertyValue(String propertyType, String defaultValueString, Object expectedValue) throws Exception {
        this.prepare_defaultPropertyValue(propertyType, defaultValueString);
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertEquals((Object)expectedValue, (Object)panel.getPropertyByTitle("q").getValue());
    }

    @Test
    public void test_propertyCategory() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setA(int value) {", "  }", "  public void setB(int value) {", "  }", "  public void setC(int value) {", "  }", "  public void setD(int value) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setA(int)'>", "    <category value='normal'/>", "  </property>", "  <property id='setB(int)'>", "    <category value='preferred'/>", "  </property>", "  <property id='setC(int)'>", "    <category value='advanced'/>", "  </property>", "  <property id='setD(int)'>", "    <category value='hidden'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescription description = panel.getDescription();
        ComponentDescriptionHelperTest.assertSame((Object)PropertyCategory.NORMAL, (Object)description.getProperty("setA(int)").getCategory());
        ComponentDescriptionHelperTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)description.getProperty("setB(int)").getCategory());
        ComponentDescriptionHelperTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)description.getProperty("setC(int)").getCategory());
        ComponentDescriptionHelperTest.assertSame((Object)PropertyCategory.HIDDEN, (Object)description.getProperty("setD(int)").getCategory());
    }

    @Test
    public void test_propertyCategory_bad() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setA(int value) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setA(int)'>", "    <category value='no-such-category'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        try {
            this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        }
        catch (Throwable e) {
            e = DesignerExceptionUtils.getRootCause((Throwable)e);
            ComponentDescriptionHelperTest.assertInstanceOf(SAXParseException.class, (Object)e);
        }
    }

    @Test
    public void test_MethodRule() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public String foo(int value) {", "    return null;", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='foo'>", "      <parameter type='int'/>", "      <tag name='myTagName' value='myTagValue'/>", "    </method>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        MethodDescription methodDescription = panel.getDescription().getMethod("foo(int)");
        ComponentDescriptionHelperTest.assertNotNull((Object)methodDescription);
        ComponentDescriptionHelperTest.assertEquals((Object)"test.MyPanel", (Object)methodDescription.getDeclaringClass().getName());
        ComponentDescriptionHelperTest.assertEquals((Object)"java.lang.String", (Object)methodDescription.getReturnClass().getName());
        ComponentDescriptionHelperTest.assertEquals((Object)"myTagValue", (Object)methodDescription.getTag("myTagName"));
        ComponentDescriptionHelperTest.assertNull((Object)methodDescription.getTag("no-such-tag"));
    }

    @Test
    public void test_AbstractDescription_hasTrueTag() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public void foo() {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='foo'>", "      <tag name='myTrueTag' value='true'/>", "      <tag name='myFalseTag' value='false'/>", "    </method>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        MethodDescription methodDescription = panel.getDescription().getMethod("foo()");
        ComponentDescriptionHelperTest.assertTrue((boolean)methodDescription.hasTrueTag("myTrueTag"));
        ComponentDescriptionHelperTest.assertFalse((boolean)methodDescription.hasTrueTag("myFalseTag"));
        ComponentDescriptionHelperTest.assertFalse((boolean)methodDescription.hasTrueTag("noSuchTag"));
    }

    @Test
    public void test_MethodsOperationRule_signatureInclude() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public void foo() {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <methods-include signature='foo()'/>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertNotNull((Object)panel.getDescription().getMethod("foo()"));
    }

    @Test
    public void test_MethodsOperationRule_signatureExclude() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <methods-exclude signature='setEnabled(boolean)'/>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertNull((Object)panel.getDescription().getMethod("setEnabled(boolean)"));
        ComponentDescriptionHelperTest.assertNotNull((Object)panel.getDescription().getMethod("setAutoscrolls(boolean)"));
    }

    @Test
    public void test_MethodsOperationRule_regexpInclude() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public void foo() {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <methods-include signature='/foo.+/'/>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertNotNull((Object)panel.getDescription().getMethod("foo()"));
    }

    @Test
    public void test_MethodsOperationRule_regexpExclude() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <methods-exclude signature='/setEnabled.+/'/>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertNull((Object)panel.getDescription().getMethod("setEnabled(boolean)"));
        ComponentDescriptionHelperTest.assertNotNull((Object)panel.getDescription().getMethod("setAutoscrolls(boolean)"));
    }

    @Test
    public void test_exposedChildren_rules() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test_1/MyPanel_1.java", ComponentDescriptionHelperTest.getSourceDQ("package test_1;", "import javax.swing.*;", "public class MyPanel_1 extends JPanel {", "  public MyPanel_1() {", "    add(getButton_1());", "  }", "  private JButton m_button_1 = new JButton();", "  public JButton getButton_1() {", "    return m_button_1;", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test_2/MyPanel_2.java", ComponentDescriptionHelperTest.getSourceDQ("package test_2;", "import javax.swing.*;", "public class MyPanel_2 extends test_1.MyPanel_1 {", "  public MyPanel_2() {", "    add(getButton_2());", "  }", "  private JButton m_button_2 = new JButton();", "  public JButton getButton_2() {", "    return m_button_2;", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test_2/MyPanel_2.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <exposing-rules>", "    <exclude package='test_1'/>", "  </exposing-rules>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends test_2.MyPanel_2 {", "  public Test() {", "  }", "}");
        List components = panel.getChildrenComponents();
        ComponentDescriptionHelperTest.assertEquals((long)1L, (long)components.size());
        ExposedPropertyCreationSupport exposedCreationSupport = (ExposedPropertyCreationSupport)((ComponentInfo)components.get(0)).getCreationSupport();
        Assertions.assertThat((String)exposedCreationSupport.toString()).contains(new CharSequence[]{"getButton_2()"});
    }

    @Test
    public void test_exposedChildren_specificDescriptions() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    add(getButton());", "  }", "  private Container m_button = new JButton();", "  public Container getButton() {", "    return m_button;", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.getButton.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ContainerInfo exposedButton = (ContainerInfo)panel.getChildrenComponents().get(0);
        Assertions.assertThat((String)exposedButton.toString()).contains(new CharSequence[]{"getButton()"});
        ComponentDescriptionHelperTest.assertFalse((boolean)exposedButton.hasLayout());
    }

    @Test
    public void test_exposedChildren_noSpecificDescription() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        Assertions.assertThat((String)contentPane.toString()).contains(new CharSequence[]{"getContentPane()"});
        ComponentDescriptionHelperTest.assertSame((Object)contentPane.getDescription(), (Object)ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, Container.class));
    }

    private void prepare_parameterChildren_specificDescription(boolean withDescription) throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public abstract class MyDialog extends JPanel {", "  public MyDialog() {", "    setLayout(new BorderLayout());", "    JPanel contentArea = new JPanel();", "    add(contentArea);", "    createDialogArea(contentArea);", "  }", "  protected abstract void createDialogArea(Container parent);", "}"));
        if (withDescription) {
            ComponentDescriptionHelperTest.setFileContentSrc("test/MyDialog.createDialogArea_java.awt.Container_.0.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='parameter_1'>value_1</parameter>", "  </parameters>", "</component>"));
        }
        ComponentDescriptionHelperTest.waitForAutoBuild();
    }

    @Test
    public void test_parameterChildren_specificDescription_0() throws Exception {
        this.prepare_parameterChildren_specificDescription(false);
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "  }", "}");
        ComponentDescriptionHelperTest.assertHierarchy("{this: test.MyDialog} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {parameter} {parent} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentDescriptionHelperTest.assertInstanceOf(UnknownAssociation.class, (Object)parent.getAssociation());
        ComponentDescriptionHelperTest.assertInstanceOf(MethodParameterCreationSupport.class, (Object)parent.getCreationSupport());
        ComponentDescriptionHelperTest.assertInstanceOf(MethodParameterVariableSupport.class, (Object)parent.getVariableSupport());
        ComponentDescriptionHelperTest.assertNull((Object)parent.getDescription().getParameter("parameter_1"));
        ComponentDescriptionHelperTest.assertSame((Object)ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, Container.class), (Object)parent.getDescription());
    }

    @Test
    public void test_parameterChildren_specificDescription_1() throws Exception {
        this.prepare_parameterChildren_specificDescription(true);
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "  }", "}");
        ComponentDescriptionHelperTest.assertHierarchy("{this: test.MyDialog} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {parameter} {parent} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentDescriptionHelperTest.assertInstanceOf(UnknownAssociation.class, (Object)parent.getAssociation());
        ComponentDescriptionHelperTest.assertInstanceOf(MethodParameterCreationSupport.class, (Object)parent.getCreationSupport());
        ComponentDescriptionHelperTest.assertInstanceOf(MethodParameterVariableSupport.class, (Object)parent.getVariableSupport());
        ComponentDescriptionHelperTest.assertEquals((Object)"value_1", (Object)parent.getDescription().getParameter("parameter_1"));
    }

    @Test
    public void test_parameterChildren_specificDescription_2() throws Exception {
        this.prepare_parameterChildren_specificDescription(true);
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyDialog2.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyDialog2 extends MyDialog {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyDialog2.createDialogArea_java.awt.Container_.0.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='parameter_2'>value_2</parameter>", "  </parameters>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyDialog2 {", "  public Test() {", "  }", "  protected void createDialogArea(Container parent) {", "  }", "}");
        ComponentDescriptionHelperTest.assertHierarchy("{this: test.MyDialog2} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {parameter} {parent} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentDescriptionHelperTest.assertInstanceOf(UnknownAssociation.class, (Object)parent.getAssociation());
        ComponentDescriptionHelperTest.assertInstanceOf(MethodParameterCreationSupport.class, (Object)parent.getCreationSupport());
        ComponentDescriptionHelperTest.assertInstanceOf(MethodParameterVariableSupport.class, (Object)parent.getVariableSupport());
        ComponentDescriptionHelperTest.assertEquals((Object)"value_1", (Object)parent.getDescription().getParameter("parameter_1"));
        ComponentDescriptionHelperTest.assertEquals((Object)"value_2", (Object)parent.getDescription().getParameter("parameter_2"));
    }

    @Test
    public void test_parameters() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='parameter_1'>AAA</parameter>", "    <parameter name='parameter_2'>BBB</parameter>", "    <parameter name='parameter_3'/>", "  </parameters>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescription description = panel.getDescription();
        ComponentDescriptionHelperTest.assertEquals((Object)"AAA", (Object)description.getParameter("parameter_1"));
        ComponentDescriptionHelperTest.assertEquals((Object)"BBB", (Object)description.getParameter("parameter_2"));
        ComponentDescriptionHelperTest.assertEquals((Object)"", (Object)description.getParameter("parameter_3"));
        ComponentDescriptionHelperTest.assertNull((Object)description.getParameter("parameter_No"));
        Map parameters = description.getParameters();
        Assertions.assertThat((Map)parameters).contains(new Map.Entry[]{MapEntry.entry((Object)"parameter_1", (Object)"AAA"), MapEntry.entry((Object)"parameter_2", (Object)"BBB"), MapEntry.entry((Object)"parameter_3", (Object)"")});
    }

    @Test
    public void test_configurableProperty() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void clear() {", "  }", "  public void addItem(String item) {", "  }", "  public void insertItem(String item, int index) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <add-property id='stringsAdd' title='items'>", "    <parameter name='addMethod'>addItem</parameter>", "    <parameter name='removeMethods'>clear() insertItem(java.lang.String,int)</parameter>", "  </add-property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    addItem('aaa');", "    addItem('bbb');", "  }", "}");
        Property itemsProperty = panel.getPropertyByTitle("items");
        ComponentDescriptionHelperTest.assertNotNull((Object)itemsProperty);
    }

    @Test
    public void test_ParameterDescription_flags() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void foo_1(Component component) {", "  }", "  public void foo_2(Component component) {", "  }", "  public void foo_3(Component component_1, Component component_2) {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='foo_1'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "    <method name='foo_2'>", "      <parameter type='java.awt.Component' parent='true'/>", "    </method>", "    <method name='foo_3'>", "      <parameter type='java.awt.Component' parent2='true'/>", "      <parameter type='java.awt.Component' child2='true'/>", "    </method>", "  </methods>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescription componentDescription = panel.getDescription();
        MethodDescription method = componentDescription.getMethod("foo_1(java.awt.Component)");
        ComponentDescriptionHelperTest.assertEquals((Object)"foo_1({java.awt.Component,child})", (Object)method.toString());
        ComponentDescriptionHelperTest.assertTrue((boolean)method.getParameter(0).isChild());
        ComponentDescriptionHelperTest.assertFalse((boolean)method.getParameter(0).isParent());
        ComponentDescriptionHelperTest.assertFalse((boolean)method.getParameter(0).isParent2());
        ComponentDescriptionHelperTest.assertFalse((boolean)method.getParameter(0).isChild2());
        method = componentDescription.getMethod("foo_2(java.awt.Component)");
        ComponentDescriptionHelperTest.assertEquals((Object)"foo_2({java.awt.Component,parent})", (Object)method.toString());
        ComponentDescriptionHelperTest.assertTrue((boolean)method.getParameter(0).isParent());
        method = componentDescription.getMethod("foo_3(java.awt.Component,java.awt.Component)");
        ComponentDescriptionHelperTest.assertEquals((Object)"foo_3({java.awt.Component,parent2},{java.awt.Component,child2})", (Object)method.toString());
        ComponentDescriptionHelperTest.assertTrue((boolean)method.getParameter(0).isParent2());
        ComponentDescriptionHelperTest.assertTrue((boolean)method.getParameter(1).isChild2());
    }

    @Test
    public void test_ParameterDescription_name() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String methodSignature = "setEnabled(boolean)";
        MethodDescription methodDescription = panel.getDescription().getMethod(methodSignature);
        ComponentDescriptionHelperTest.assertEquals((Object)"enabled", (Object)methodDescription.getParameter(0).getName());
    }

    @Test
    public void test_StandardBeanPropertiesRule_ignoreStaticMethods() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public static void setFoo(int value) {", "  }", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertNull((Object)panel.getPropertyByTitle("foo"));
    }

    @Test
    public void test_StandardBeanPropertiesRule_nonStandardGetter() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(int foo) {", "  }", "  public int getMyFoo() {", "    return 555;", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setFoo(int)'>", "    <getter name='getMyFoo'/>", "  </property>", "</component>"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ComponentDescriptionHelperTest.assertEquals((Object)555, (Object)property.getValue());
    }

    @Test
    public void test_ComponentDescription_getConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        MethodInvocation methodInvocation = panel.getMethodInvocation("setEnabled(boolean)");
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodInvocation)methodInvocation);
        ComponentDescriptionHelperTest.assertNull((Object)panel.getDescription().getConstructor(methodBinding));
    }

    @Test
    public void test_badConstructor() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ComponentDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='int'/>", "    </constructor>", "  </constructors>", "</component>"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel{", "  public MyPanel() {", "  }", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        try {
            this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        }
        catch (Throwable e) {
            Throwable root = DesignerExceptionUtils.getRootCause((Throwable)e);
            ((AbstractStringAssert)Assertions.assertThat((String)root.getMessage()).contains(new CharSequence[]{"test.MyPanel"})).contains(new CharSequence[]{"<init>(int)"});
        }
    }

    @Test
    public void test_AbstractInvocationDescription() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String methodSignature = "setEnabled(boolean)";
        MethodDescription methodDescription = panel.getDescription().getMethod(methodSignature);
        ComponentDescriptionHelperTest.assertTrue((boolean)methodDescription.equals((Object)methodDescription));
        ComponentDescriptionHelperTest.assertFalse((boolean)methodDescription.equals((Object)this));
        ComponentDescriptionHelperTest.assertEquals((long)methodSignature.hashCode(), (long)methodDescription.hashCode());
    }

    @Test
    public void test_instanceFactory_model_onlyStatic() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, Box.class);
        ComponentDescriptionHelperTest.assertTrue((boolean)ComponentInfo.class.isAssignableFrom(componentDescription.getModelClass()));
    }

    @Test
    public void test_loadModelClass() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        DescriptionHelper.loadModelClass((String)"org.eclipse.wb.core.model.JavaInfo");
        DescriptionHelper.loadModelClass((String)"org.eclipse.wb.internal.swt.model.widgets.ControlInfo");
        try {
            DescriptionHelper.loadModelClass((String)"no.such.Class");
            ComponentDescriptionHelperTest.fail();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void test_getDescription_variants() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertSame((Object)ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, JPanel.class), (Object)ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"javax.swing.JPanel"));
    }

    @Test
    public void test_hasComponentDescriptionResource() throws Exception {
        ComponentDescriptionHelperTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"));
        ComponentDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertTrue((boolean)DescriptionHelper.hasComponentDescriptionResource((ILoadingContext)this.m_lastLoadingContext, Container.class));
        ComponentDescriptionHelperTest.assertFalse((boolean)DescriptionHelper.hasComponentDescriptionResource((ILoadingContext)this.m_lastLoadingContext, this.m_lastLoader.loadClass("test.MyButton")));
    }

    @Test
    public void test_hasForcedToolkitForComponent() throws Exception {
        String swingToolkitId = SwingToolkitDescription.INSTANCE.getId();
        ComponentDescriptionHelperTest.setFileContentSrc("test/NoForced.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class NoForced extends JButton {", "  public NoForced() {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/HasForced.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class HasForced extends JButton {", "  public HasForced() {", "  }", "}"));
        ComponentDescriptionHelperTest.setFileContentSrc("test/HasForced.wbp-forced-toolkit.txt", swingToolkitId);
        ComponentDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentDescriptionHelperTest.assertFalse((boolean)DescriptionHelper.hasForcedToolkitForComponent((ILoadingContext)this.m_lastLoadingContext, (String)"no.matter", (String)"test.NoForced"));
        ComponentDescriptionHelperTest.assertTrue((boolean)DescriptionHelper.hasForcedToolkitForComponent((ILoadingContext)this.m_lastLoadingContext, (String)swingToolkitId, (String)"test.HasForced"));
        ComponentDescriptionHelperTest.assertFalse((boolean)DescriptionHelper.hasForcedToolkitForComponent((ILoadingContext)this.m_lastLoadingContext, (String)"not.required.toolkit", (String)"test.HasForced"));
    }

    public static class NotCachedButton
    extends JButton {
        private static final long serialVersionUID = 0L;
    }
}

