/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.Before;
import org.junit.Test;

public class ExecutionFlowUtils2Test
extends AbstractEngineTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            ExecutionFlowUtils2Test.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getValue_valueInDeclaration() throws Exception {
        String expressionSource = "a =";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_useDeclaredVariable() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_valueInAssignment() throws Exception {
        String expressionSource = "b =";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    int b;", "    b = a;", "    System.out.println(b);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_assignInheritedField() throws Exception {
        ExecutionFlowUtils2Test.setFileContentSrc("test/Base.java", ExecutionFlowUtils2Test.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Base {", "  protected int m_field;", "}"));
        ExecutionFlowUtils2Test.waitForAutoBuild();
        String expressionSource = "b =";
        String expected = "2";
        this.check_getValue(new String[]{"package test;", "public class Test extends Base {", "  public Test() {", "    m_field = 1;", "    int b = 2;", "    System.out.println(b);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_useAssignedValue() throws Exception {
        String expressionSource = "b);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    int b;", "    b = a;", "    System.out.println(b);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_useAssignedValue_separateDeclaration() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a;", "    a = 1;", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_useInInnerBlock() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    {", "      System.out.println(a);", "    }", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_assignInInnerBlock() throws Exception {
        String expressionSource = "a);";
        String expected = "2";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    {", "      a = 2;", "    }", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_followMethodInvocation() throws Exception {
        String expressionSource = "p);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    foo(a);", "  }", "  private void foo(int p) {", "    System.out.println(p);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_followConstructorInvocation() throws Exception {
        String expressionSource = "p);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    this(1);", "  }", "  public Test(int p) {", "    System.out.println(p);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_followMethodInvocation_varArgs_hasValues() throws Exception {
        String expressionSource = "p);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    foo(1, 2, 3);", "  }", "  private void foo(int... p) {", "    System.out.println(p);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_followMethodInvocation_varArgs_noValues() throws Exception {
        String expressionSource = "p);";
        String expected = null;
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    foo();", "  }", "  private void foo(int... p) {", "    System.out.println(p);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_reTrack_afterFlowChange() throws Exception {
        String expressionSource = "p);";
        String expected = "1";
        ExecutionFlowDescription executionFlow = this.prepare_flowDescription(new String[]{"public class Test {", "  public Test() {", "  }", "  private void foo() {", "    bar(1);", "  }", "  private void bar(int p) {", "    System.out.println(p);", "  }", "}"});
        ExpressionValue value = this.getValue(executionFlow, expressionSource);
        ExecutionFlowUtils2Test.assertNull((Object)value);
        MethodDeclaration fooMethod = this.getNode("foo", MethodDeclaration.class);
        executionFlow.addStartMethod(fooMethod);
        this.check_getValue(executionFlow, expressionSource, expected);
    }

    @Test
    public void test_getValue_useDeclaredField() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a = 1;", "  public Test() {", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    a = 1;", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_withThisQualifier_1() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    this.a = 1;", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_withThisQualifier_2() throws Exception {
        String expressionSource = ".a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    this.a = 1;", "    System.out.println(this.a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_withThisQualifier_applicationPattern() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  private int a;", "  public static void main(String[] args) {", "    new Test();", "  }", "  public Test() {", "    this.a = 1;", "    System.out.println(this.a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_withThisQualifier_4() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    setValue(1);", "    System.out.println(a);", "  }", "  private void setValue(int a) {", "    this.a = a;", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldWithoutInitilizer() throws Exception {
        String expressionSource = "a);";
        String expected = "{p}{p}int a;";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_applicationPattern_withConstructor() throws Exception {
        String expressionSource = "a.";
        String expected = "Integer.valueOf(123)";
        this.check_getValue(new String[]{"public class Test {", "  protected Object a;", "  public static void main(String[] args) {", "    Test window = new Test();", "    window.open();", "  }", "  public Test() {", "  }", "  public void open() {", "    a = Integer.valueOf(123);", "    a.hashCode();", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_applicationPattern_separateDeclaration() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public static void main(String[] args) {", "    Test window = new Test();", "    window.open();", "  }", "  public void open() {", "    int a;", "    a = 1;", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_visibleInOtherMethod() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    a = 1;", "  }", "  public void foo() {", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_noOverrideInOtherMethod_1() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    a = 1;", "  }", "  public void foo() {", "    this.a = 2;", "  }", "  public void bar() {", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_fieldAssign_noOverrideInOtherMethod_2() throws Exception {
        String expressionSource = "a);";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  int a;", "  public Test() {", "    a = 1;", "  }", "  public void foo() {", "    a = 2;", "  }", "  public void bar() {", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_noMethodInvocation_parameterUse() throws Exception {
        String expressionSource = "a);";
        String expected = "{p}int a";
        this.check_getValue(new String[]{"public class Test {", "  public Test(int a) {", "    System.out.println(a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_usePermanentValue_local() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtils2Test.getSource("import javax.swing.*;", "public class Test {", "  public Test() {", "    JButton a = new JButton();", "    System.out.println(a);", "  }", "}"));
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        ExecutionFlowDescription executionFlow = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        ClassInstanceCreation creation = (ClassInstanceCreation)this.getNode("new JButton()");
        ExpressionValue permanentValue = ExecutionFlowUtils2.ensurePermanentValue((Expression)creation);
        ExecutionFlowUtils2Test.assertSame((Object)creation, (Object)permanentValue.getExpression());
        Expression target = (Expression)this.getNode("a);");
        ExpressionValue value = ExecutionFlowUtils2.getValue((ExecutionFlowDescription)executionFlow, (Expression)target);
        ExecutionFlowUtils2Test.assertSame((Object)permanentValue, (Object)value);
    }

    @Test
    public void test_getValue_usePermanentValue_parameter() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtils2Test.getSource("import javax.swing.*;", "public class Test {", "  public Test(JButton a) {", "    System.out.println(a);", "  }", "}"));
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        ExecutionFlowDescription executionFlow = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        SimpleName parameterName = (SimpleName)this.getNode("a) {");
        ExpressionValue permanentValue = ExecutionFlowUtils2.ensurePermanentValue((Expression)parameterName);
        ExecutionFlowUtils2Test.assertSame((Object)parameterName, (Object)permanentValue.getExpression());
        Expression target = (Expression)this.getNode("a);");
        ExpressionValue value = ExecutionFlowUtils2.getValue((ExecutionFlowDescription)executionFlow, (Expression)target);
        ExecutionFlowUtils2Test.assertSame((Object)permanentValue, (Object)value);
    }

    @Test
    public void test_getValue_useDeclaredVariable_inParenthesis() throws Exception {
        String expressionSource = "(a)";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println((a));", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_useDeclaredVariable_casted() throws Exception {
        String expressionSource = "(int) a";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println((int) a);", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_lazy() throws Exception {
        String expressionSource = "{p}getButton());";
        String expected = "new JButton()";
        this.check_getValue(new String[]{"import javax.swing.*;", "public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    add(getButton());", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_returnFromMethod() throws Exception {
        String expressionSource = "{p}getButton());";
        String expected = "new JButton()";
        this.check_getValue(new String[]{"import javax.swing.*;", "public class Test extends JPanel {", "  public Test() {", "    add(getButton());", "  }", "  private JButton getButton() {", "    return new JButton();", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getValue_returnFromMethod_ignoreStatic() throws Exception {
        String expressionSource = "{p}createButton());";
        String expected = null;
        this.check_getValue(new String[]{"import javax.swing.*;", "public class Test extends JPanel {", "  public Test() {", "    add(createButton());", "  }", "  private static JButton createButton() {", "    return new JButton();", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_PostfixExpression_getValue() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtils2Test.getSource("import javax.swing.*;", "public class Test {", "  public Test() {", "    int a = 1;", "    a++;", "  }", "}"));
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        ExecutionFlowDescription executionFlow = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        Expression operandInIncrement = (Expression)this.getNode("a++");
        PostfixExpression increment = (PostfixExpression)operandInIncrement.getParent();
        ExpressionValue value = ExecutionFlowUtils2.getValue((ExecutionFlowDescription)executionFlow, (Expression)operandInIncrement);
        ExecutionFlowUtils2Test.assertNotNull((Object)value);
        ExecutionFlowUtils2Test.assertSame((Object)increment, (Object)value.getExpression());
        value = ExecutionFlowUtils2.getValuePrev((ExecutionFlowDescription)executionFlow, (Expression)operandInIncrement);
        ExecutionFlowUtils2Test.assertNotNull((Object)value);
        ExecutionFlowUtils2Test.assertEquals((Object)"1", (Object)this.m_lastEditor.getSource((ASTNode)value.getExpression()));
    }

    @Test
    public void test_getValue_whenReturn_withoutExpression() throws Exception {
        String expressionSource = "a =";
        String expected = "1";
        this.check_getValue(new String[]{"public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println(a);", "    foo();", "  }", "  private void foo() {", "    return;", "  }", "}"}, expressionSource, expected);
    }

    @Test
    public void test_getPermanentValue0_clearPermanentValue() throws Exception {
        this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtils2Test.getSource("public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println(a);", "  }", "}"));
        Expression target = this.getTarget("a)");
        ExpressionValue permanentValue = ExecutionFlowUtils2.ensurePermanentValue((Expression)target);
        ExecutionFlowUtils2Test.assertSame((Object)permanentValue, (Object)ExecutionFlowUtils2.getPermanentValue0((Expression)target));
        ExecutionFlowUtils2.clearPermanentValue((Expression)target);
        ExecutionFlowUtils2Test.assertSame(null, (Object)ExecutionFlowUtils2.getPermanentValue0((Expression)target));
    }

    @Test
    public void test_getValue0() throws Exception {
        this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtils2Test.getSource("public class Test {", "  public Test() {", "    int a = 1;", "    System.out.println(a);", "  }", "}"));
        Expression target = this.getTarget("a)");
        ExpressionValue value = new ExpressionValue(null);
        ExpressionValue permanentValue = new ExpressionValue(null);
        ExecutionFlowUtils2Test.assertSame(null, (Object)ExecutionFlowUtils2.getValue0((Expression)target));
        ExecutionFlowUtils2.setPermanentValue0((Expression)target, (ExpressionValue)permanentValue);
        ExecutionFlowUtils2Test.assertSame((Object)permanentValue, (Object)ExecutionFlowUtils2.getValue0((Expression)target));
        ExecutionFlowUtils2.setValue0((Expression)target, (ExpressionValue)value);
        ExecutionFlowUtils2Test.assertSame((Object)value, (Object)ExecutionFlowUtils2.getValue0((Expression)target));
    }

    private void check_getValue(String[] lines, String expressionSource, String expected) throws Exception {
        ExecutionFlowDescription executionFlow = this.prepare_flowDescription(lines);
        this.check_getValue(executionFlow, expressionSource, expected);
    }

    private ExecutionFlowDescription prepare_flowDescription(String[] lines) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", ExecutionFlowUtils2Test.getSource(lines));
        MethodDeclaration entryPoint = typeDeclaration.getMethods()[0];
        ExecutionFlowDescription executionFlow = new ExecutionFlowDescription(new MethodDeclaration[]{entryPoint});
        return executionFlow;
    }

    private void check_getValue(ExecutionFlowDescription executionFlow, String expressionSource, String expected) {
        ExpressionValue value = this.getValue(executionFlow, expressionSource);
        if (expected != null) {
            ExecutionFlowUtils2Test.assertNotNull((Object)value);
            Expression actual = value.getExpression();
            while (expected.startsWith("{p}")) {
                ExecutionFlowUtils2Test.assertNotNull((Object)actual);
                expected = expected.substring("{p}".length());
                actual = actual.getParent();
            }
            ExecutionFlowUtils2Test.assertNotNull((Object)actual);
            ExecutionFlowUtils2Test.assertEquals((Object)expected, (Object)actual.toString().trim());
        } else {
            ExecutionFlowUtils2Test.assertNull((Object)value);
        }
    }

    private ExpressionValue getValue(ExecutionFlowDescription executionFlow, String expressionSource) {
        Expression target = this.getTarget(expressionSource);
        return ExecutionFlowUtils2.getValue((ExecutionFlowDescription)executionFlow, (Expression)target);
    }

    private Expression getTarget(String expressionSource) {
        int parentLevel = 0;
        while (expressionSource.startsWith("{p}")) {
            ++parentLevel;
            expressionSource = expressionSource.substring("{p}".length());
        }
        Expression target = (Expression)this.getNode(expressionSource);
        int i = 0;
        while (i < parentLevel) {
            target = (Expression)target.getParent();
            ++i;
        }
        return target;
    }
}

