/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.wb.tests.designer.WindowBuilderTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Suite;

public class JUnitUtils {
    private static Comparator<Class<?>> COMPARE_BY_NAME = Comparator.comparing(Class::getName);
    private static File TEST_DIR = new File("src");
    private static Set<Class<?>> TEST_ANNOTATIONS = Set.of(Test.class, Ignore.class, Before.class, After.class, BeforeClass.class, AfterClass.class);

    public static Set<Class<?>> getRepeatedlyExecutedClasses() {
        HashMap<Class, Integer> counts = new HashMap<Class, Integer>();
        for (Class<?> clazz2 : JUnitUtils.getAllExecutedClasses(WindowBuilderTests.class)) {
            counts.compute(clazz2, (k, v) -> v == null ? 1 : v + 1);
        }
        TreeSet result = new TreeSet(COMPARE_BY_NAME);
        counts.forEach((clazz, count) -> {
            if (count > 1) {
                result.add((Class<?>)clazz);
            }
        });
        return Collections.unmodifiableSet(result);
    }

    public static Map<Class<?>, List<Method>> getUnusedMethod() {
        TreeMap result = new TreeMap(COMPARE_BY_NAME);
        for (Class<?> clazz : JUnitUtils.getAllClasses(TEST_DIR)) {
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!JUnitUtils.isTestMethod(method)) {
                    result.computeIfAbsent(clazz, key -> new ArrayList()).add(method);
                }
                ++n2;
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public static Set<Class<?>> getUnusedClasses() {
        Set<Class<?>> allClasses = JUnitUtils.getAllClasses(TEST_DIR);
        List<Class<?>> allExecutedClasses = JUnitUtils.getAllExecutedClasses(WindowBuilderTests.class);
        TreeSet result = new TreeSet(COMPARE_BY_NAME);
        result.addAll(allClasses);
        result.removeAll(allExecutedClasses);
        return Collections.unmodifiableSet(result);
    }

    private static List<Class<?>> getAllExecutedClasses(Class<?> clazz) {
        ArrayList result = new ArrayList();
        result.add(clazz);
        Suite.SuiteClasses suiteClasses = clazz.getAnnotation(Suite.SuiteClasses.class);
        if (suiteClasses != null) {
            Class[] classArray = suiteClasses.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class suiteClass = classArray[n2];
                result.addAll(JUnitUtils.getAllExecutedClasses(suiteClass));
                ++n2;
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static Set<Class<?>> getAllClasses(File userDir) {
        TreeSet result = new TreeSet(COMPARE_BY_NAME);
        for (File classFile : JUnitUtils.getAllClassesByFile(userDir)) {
            Path classPath = userDir.toPath().relativize(classFile.toPath());
            String className = classPath.toString().replaceAll(File.separator, ".").replaceAll(".java$", "");
            try {
                Class<?> clazz = JUnitUtils.class.getClassLoader().loadClass(className);
                if (clazz.isEnum() || clazz.isInterface() || clazz.isAnnotation() || (clazz.getModifiers() & 0x400) > 0) continue;
                result.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static Set<File> getAllClassesByFile(File current) {
        TreeSet<File> result = new TreeSet<File>();
        if (current.isDirectory()) {
            File[] fileArray = current.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File next = fileArray[n2];
                result.addAll(JUnitUtils.getAllClassesByFile(next));
                ++n2;
            }
        } else if (current.isFile() && current.getName().endsWith(".java")) {
            result.add(current);
        }
        return Collections.unmodifiableSet(result);
    }

    private static boolean isTestMethod(Method method) {
        Annotation[] annotationArray = method.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (TEST_ANNOTATIONS.contains(annotation.annotationType())) {
                return true;
            }
            ++n2;
        }
        return method.getName().equals("_test_exit") || !method.getName().contains("test");
    }
}

