/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gefTree.policy;

import org.eclipse.gef.EditPart;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.nonvisual.AbstractArrayObjectInfo;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class ArrayObjectRequestValidator
implements ILayoutRequestValidator {
    private final AbstractArrayObjectInfo m_arrayInfo;

    public ArrayObjectRequestValidator(AbstractArrayObjectInfo arrayInfo) {
        this.m_arrayInfo = arrayInfo;
    }

    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        return this.isValidModel(request.getNewObject());
    }

    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        for (EditPart editPart : request.getEditParts()) {
            if (!this.isValidModel(editPart.getModel())) {
                return false;
            }
            JavaInfo javaInfo = (JavaInfo)((Object)editPart.getModel());
            if (((Object)((Object)this.m_arrayInfo)).equals((Object)AbstractArrayObjectInfo.getArrayObjectInfo(javaInfo)) || javaInfo.getVariableSupport() instanceof EmptyVariableSupport) continue;
            return false;
        }
        return true;
    }

    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        return this.validateMoveRequest(host, request);
    }

    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        return false;
    }

    public boolean isValidModel(Object objectModel) {
        if (objectModel instanceof JavaInfo) {
            return (Boolean)ExecutionUtils.runObjectLog(() -> {
                JavaInfo info = (JavaInfo)((Object)((Object)objectModel));
                return ReflectionUtils.isSuccessorOf(info.getDescription().getComponentClass(), (String)this.m_arrayInfo.getItemClass().getCanonicalName());
            }, (Object)false);
        }
        return false;
    }
}

