/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.CompositeIterator;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.MappedSuperclass;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.impl.PersistenceSourceRefElementImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class EntityImpl
extends PersistenceSourceRefElementImpl
implements Entity {
    protected static final String DEFAULT_NAME_EDEFAULT = null;
    protected String defaultName = DEFAULT_NAME_EDEFAULT;
    protected static final String SPECIFIED_NAME_EDEFAULT = null;
    protected String specifiedName = SPECIFIED_NAME_EDEFAULT;
    protected static final AccessType ACCESS_TYPE_EDEFAULT = AccessType.DEFAULT_LITERAL;
    protected AccessType accessType = ACCESS_TYPE_EDEFAULT;
    protected Table table = null;
    protected EList attributeOverrides = null;
    protected Inheritance inheritance = null;
    static /* synthetic */ Class class$0;

    protected EntityImpl() {
    }

    protected EntityImpl(IEntityModelAdapter entityModelAdapter) {
        super(entityModelAdapter);
        this.table = OrmFactory.eINSTANCE.createTable(entityModelAdapter.createTableModelAdapter());
        ((InternalEObject)this.table).eInverseAdd((InternalEObject)this, -4, null, null);
        this.inheritance = OrmFactory.eINSTANCE.createInheritance(entityModelAdapter.createInheritanceModelAdapter());
        ((InternalEObject)this.inheritance).eInverseAdd((InternalEObject)this, -6, null, null);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.ENTITY;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultNameGen(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDefaultName, (Object)this.defaultName));
        }
    }

    public void setDefaultName(String defaultName) {
        this.setDefaultNameGen(defaultName);
        this.getTable().setDefaultName(this.getName());
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    public void setSpecifiedNameGen(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSpecifiedName, (Object)this.specifiedName));
        }
    }

    public void setSpecifiedName(String newName) {
        this.setSpecifiedNameGen(newName);
        ((IEntityModelAdapter)this.getModelAdapter()).specifiedNameChanged();
        this.getTable().setDefaultName(this.getName());
        this.getPersistentType().setName(this.getName());
    }

    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType newAccessType) {
        AccessType oldAccessType = this.accessType;
        AccessType accessType = this.accessType = newAccessType == null ? ACCESS_TYPE_EDEFAULT : newAccessType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldAccessType, (Object)this.accessType));
        }
    }

    public Table getTable() {
        return this.table;
    }

    public NotificationChain basicSetTable(Table newTable, NotificationChain msgs) {
        Table oldTable = this.table;
        this.table = newTable;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTable, (Object)newTable);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public EList getAttributeOverrides() {
        if (this.attributeOverrides == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dali.orm.AttributeOverride");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.attributeOverrides = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 4);
        }
        return this.attributeOverrides;
    }

    public Inheritance getInheritance() {
        return this.inheritance;
    }

    public NotificationChain basicSetInheritance(Inheritance newInheritance, NotificationChain msgs) {
        Inheritance oldInheritance = this.inheritance;
        this.inheritance = newInheritance;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldInheritance, (Object)newInheritance);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetTable(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getAttributeOverrides()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return this.basicSetInheritance(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDefaultName();
            }
            case 1: {
                return this.getSpecifiedName();
            }
            case 2: {
                return this.getAccessType();
            }
            case 3: {
                return this.getTable();
            }
            case 4: {
                return this.getAttributeOverrides();
            }
            case 5: {
                return this.getInheritance();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDefaultName((String)newValue);
                return;
            }
            case 1: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 2: {
                this.setAccessType((AccessType)((Object)newValue));
                return;
            }
            case 4: {
                this.getAttributeOverrides().clear();
                this.getAttributeOverrides().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDefaultName(DEFAULT_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setAccessType(ACCESS_TYPE_EDEFAULT);
                return;
            }
            case 4: {
                this.getAttributeOverrides().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DEFAULT_NAME_EDEFAULT == null ? this.defaultName != null : !DEFAULT_NAME_EDEFAULT.equals(this.defaultName);
            }
            case 1: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 2: {
                return this.accessType != ACCESS_TYPE_EDEFAULT;
            }
            case 3: {
                return this.table != null;
            }
            case 4: {
                return this.attributeOverrides != null && !this.attributeOverrides.isEmpty();
            }
            case 5: {
                return this.inheritance != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (defaultName: ");
        result.append(this.defaultName);
        result.append(", specifiedName: ");
        result.append(this.specifiedName);
        result.append(", accessType: ");
        result.append((Object)this.accessType);
        result.append(')');
        return result.toString();
    }

    public org.eclipse.dali.db.Table getResolvedDBTable() {
        return this.getTable().getDBTable();
    }

    protected void addProblemsTo(List problems) {
        this.addNoIdProblemTo(problems);
        this.addUnresolvedTableProblemTo(problems);
        this.addAttributeOverridesProblemsTo(problems);
    }

    private void addNoIdProblemTo(List problems) {
        if (!this.containsId()) {
            problems.add(this.buildProblem("Entity does not have an Id", this.getTextRange()));
        }
    }

    public boolean containsId() {
        Iterator stream = this.getPersistentType().getAllPersistentAttributes().iterator();
        while (stream.hasNext()) {
            if (((PersistentAttribute)stream.next()).getAttributeMappingKey() != "id") continue;
            return true;
        }
        return false;
    }

    private void addUnresolvedTableProblemTo(List problems) {
        if (this.getPersistenceProject().getConnectionInfo().isConnected() && this.getResolvedDBTable() == null) {
            problems.add(this.buildProblem("Table \"" + this.getTable().getName() + "\" cannot be resolved", this.tableTextRange()));
        }
    }

    private void addAttributeOverridesProblemsTo(List problems) {
        Iterator i = this.getAttributeOverrides().iterator();
        while (i.hasNext()) {
            AttributeOverride override = (AttributeOverride)i.next();
            if (!CollectionTools.contains((Iterator)this.inheritedAttributeNames(), (Object)override.getName())) {
                problems.add(this.buildProblem(this.unresolvedAttributeOverrideMessage(override), this.getTextRange()));
            }
            if (override.columnResolves()) continue;
            problems.add(this.buildProblem(this.unresolvedColumnMessage(override), override.getTextRange()));
        }
    }

    protected String unresolvedColumnMessage(AttributeOverride override) {
        return "Inherited attribute \"" + override.getName() + "\" mapped to unresolved column \"" + override.getColumn().getName() + "\"";
    }

    protected String unresolvedAttributeOverrideMessage(AttributeOverride override) {
        return "Attribute override \"" + override.getName() + "\" is not a valid inherited attribute";
    }

    private ITextRange tableTextRange() {
        ITextRange tableTextRange = ((IEntityModelAdapter)this.getModelAdapter()).tableTextRange();
        if (tableTextRange != null) {
            return tableTextRange;
        }
        return this.getTextRange();
    }

    public PersistentType getPersistentType() {
        return (PersistentType)this.getParent();
    }

    public void initialize(PersistentType persistentType) {
        this.setAccessType(persistentType.getAccessType());
    }

    public String getAnnotationName() {
        return "Entity";
    }

    public TypeMapping.Key getKey() {
        return Entity.Key.INSTANCE;
    }

    public Iterator inheritedAttributeNames() {
        PersistentType persistentType = this.getParentPersistentType();
        if (persistentType != null && persistentType.getTypeMappingKey().equals(MappedSuperclass.Key.INSTANCE)) {
            return this.inheritedAttributeNames(persistentType);
        }
        return NullIterator.instance();
    }

    public Iterator inheritedAttributeNames(PersistentType persistentType) {
        if (persistentType == null) {
            return NullIterator.instance();
        }
        return new CompositeIterator((Iterator)new TransformationIterator(persistentType.getPersistentAttributes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentAttribute)next).getName();
            }
        }, this.inheritedAttributeNames(persistentType.getParentPersistentType()));
    }

    public PersistentType getParentPersistentType() {
        return this.getPersistentType().getParentPersistentType();
    }
}

