/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.InheritanceType;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.provider.InheritanceItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class InheritanceComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private Inheritance inheritance;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private InheritanceItemProvider inheritanceItemProvider;
    private ComboViewer strategyViewer;
    private INotifyChangedListener inheritanceListener;
    static /* synthetic */ Class class$0;

    protected InheritanceComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.inheritanceItemProvider = (InheritanceItemProvider)this.adapterFactory.createInheritanceAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Label strategyLabel = new Label((Composite)this, 16384);
        strategyLabel.setText(DaliUiMessages.InheritanceComposite_strategy);
        this.strategyViewer = this.buildStrategyCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.strategyViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.strategyViewer.getCombo(), "org.eclipse.dali.ui.entity_inheritanceStrategy");
    }

    private ComboViewer buildStrategyCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(InheritanceType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (InheritanceComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    InheritanceType strategy = (InheritanceType)selection.getFirstElement();
                    if (!InheritanceComposite.this.inheritance.getStrategy().equals(strategy)) {
                        InheritanceComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)InheritanceComposite.this.editingDomain, (Object)InheritanceComposite.this.inheritance, (Object)OrmPackage.eINSTANCE.getInheritance_Strategy(), (Object)strategy));
                    }
                }
            }
        });
        return viewer;
    }

    public void populate(EObject model) {
        if (this.inheritance != null) {
            this.inheritanceItemProvider.removeListener(this.getInheritanceListener());
            this.inheritance.eAdapters().remove((Object)this.inheritanceItemProvider);
        }
        if (model == null) {
            this.inheritance = null;
            this.populating = false;
            return;
        }
        this.inheritance = (Inheritance)model;
        this.inheritanceItemProvider.addListener(this.getInheritanceListener());
        this.inheritance.eAdapters().add((Object)this.inheritanceItemProvider);
        if (this.inheritance.getStrategy() == InheritanceType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.DEFAULT_LITERAL) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.DEFAULT_LITERAL));
            }
        } else if (this.inheritance.getStrategy() == InheritanceType.JOINED_LITERAL) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.JOINED_LITERAL) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.JOINED_LITERAL));
            }
        } else if (this.inheritance.getStrategy() == InheritanceType.SINGLE_TABLE_LITERAL) {
            if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.SINGLE_TABLE_LITERAL) {
                this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.SINGLE_TABLE_LITERAL));
            }
        } else if (((StructuredSelection)this.strategyViewer.getSelection()).getFirstElement() != InheritanceType.TABLE_PER_CLASS_LITERAL) {
            this.strategyViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.TABLE_PER_CLASS_LITERAL));
        }
    }

    private INotifyChangedListener getInheritanceListener() {
        if (this.inheritanceListener == null) {
            this.inheritanceListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.Inheritance");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 0) {
                        InheritanceType inheritanceType = (InheritanceType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, inheritanceType){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ InheritanceType val$inheritanceType;
                            {
                                this.this$1 = var1_1;
                                this.val$inheritanceType = inheritanceType;
                            }

                            public void run() {
                                if (((StructuredSelection)InheritanceComposite.access$3(2.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$inheritanceType) {
                                    InheritanceComposite.access$3(2.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$inheritanceType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ InheritanceComposite access$0(2 var0) {
                    return var0.InheritanceComposite.this;
                }
            };
        }
        return this.inheritanceListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.strategyViewer.getCombo().setFocus();
    }

    public void dispose() {
        this.inheritanceItemProvider.removeListener(this.inheritanceListener);
        super.dispose();
    }

    static /* synthetic */ ComboViewer access$3(InheritanceComposite inheritanceComposite) {
        return inheritanceComposite.strategyViewer;
    }
}

