/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;

public class FnDateTime
extends Function {
    private static Collection _expected_args = null;

    public FnDateTime() {
        super(new QName("dateTime"), 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnDateTime.dateTime(args, ec.getStaticContext());
    }

    public static ResultSequence dateTime(Collection args, StaticContext sc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnDateTime.expected_args());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        ResultSequence arg2 = (ResultSequence)argiter.next();
        if (arg1.empty() || arg2.empty()) {
            return ResultBuffer.EMPTY;
        }
        XSDate param1 = (XSDate)arg1.first();
        XSTime param2 = (XSTime)arg2.first();
        Calendar cal = Calendar.getInstance();
        cal.set(param1.year(), param1.month() - 1, param1.day());
        cal.set(11, param2.hour());
        cal.set(12, param2.minute());
        cal.set(13, new Double(Math.floor(param2.second())).intValue());
        cal.set(14, 0);
        XSDuration dateTimeZone = param1.tz();
        XSDuration timeTimeZone = param2.tz();
        if (dateTimeZone != null && timeTimeZone != null && !dateTimeZone.getStringValue().equals(timeTimeZone.getStringValue())) {
            throw DynamicError.inconsistentTimeZone();
        }
        if (dateTimeZone == null && timeTimeZone != null) {
            return new XSDateTime(cal, timeTimeZone);
        }
        if (dateTimeZone != null && timeTimeZone == null) {
            return new XSDateTime(cal, dateTimeZone);
        }
        if (dateTimeZone != null && timeTimeZone != null && dateTimeZone.getStringValue().equals(timeTimeZone.getStringValue())) {
            return new XSDateTime(cal, dateTimeZone);
        }
        return new XSDateTime(cal, null);
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSDate(), 3));
            _expected_args.add(new SeqType(new XSTime(), 3));
        }
        return _expected_args;
    }
}

