/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;

public class CompositeOrTypeConstraint
implements ITypeConstraint {
    private final ITypeConstraint[] fConstraints;

    CompositeOrTypeConstraint(ITypeConstraint[] constraints) {
        Assert.isNotNull((Object)constraints);
        this.fConstraints = CompositeOrTypeConstraint.sort(CompositeOrTypeConstraint.getCopy(constraints));
    }

    private static ITypeConstraint[] getCopy(ITypeConstraint[] constraints) {
        List<ITypeConstraint> l = Arrays.asList(constraints);
        return l.toArray(new ITypeConstraint[l.size()]);
    }

    private static ITypeConstraint[] sort(ITypeConstraint[] constraints) {
        Arrays.sort(constraints, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o2.toString().compareTo(o1.toString());
            }
        });
        return constraints;
    }

    @Override
    public String toResolvedString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.fConstraints.length) {
            ITypeConstraint constraint = this.fConstraints[i];
            if (i > 0) {
                buff.append(" or ");
            }
            buff.append(constraint.toResolvedString());
            ++i;
        }
        return buff.toString();
    }

    @Override
    public boolean isSimpleTypeConstraint() {
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.fConstraints.length) {
            ITypeConstraint constraint = this.fConstraints[i];
            if (i > 0) {
                buff.append(" or ");
            }
            buff.append(constraint.toString());
            ++i;
        }
        return buff.toString();
    }

    public ITypeConstraint[] getConstraints() {
        return this.fConstraints;
    }
}

