/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.BooleanValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.NullValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.NumberValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.StringValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.UndefinedValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventQueue;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequestManager;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.crossfire.CrossFirePlugin;
import org.eclipse.wst.jsdt.debug.internal.crossfire.Tracing;
import org.eclipse.wst.jsdt.debug.internal.crossfire.event.CFEventQueue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.BreakpointTracker;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFBooleanValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFEventRequestManager;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFNullValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFNumberValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFScriptReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFStackFrame;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFStringValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFThreadReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFUndefinedValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.Messages;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.RemoteBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFEventPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFRequestPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFResponsePacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;

public class CFVirtualMachine
extends CFMirror
implements VirtualMachine {
    private final NullValue nullvalue = new CFNullValue(this);
    private final UndefinedValue undefinedvalue = new CFUndefinedValue(this);
    private final DebugSession session;
    private final CFEventRequestManager ermanager = new CFEventRequestManager(this);
    private final CFEventQueue queue = new CFEventQueue(this, this.ermanager);
    private boolean disconnected = false;
    private Map threads = null;
    private Map scripts = null;

    public CFVirtualMachine(DebugSession session) {
        this.session = session;
        this.initializeBreakpoints();
    }

    void initializeBreakpoints() {
        CFRequestPacket request;
        List list;
        CFResponsePacket response;
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] managerBreakpoints = manager.getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        Vector allBps = new Vector();
        int i = 0;
        while (i < managerBreakpoints.length) {
            IBreakpoint current = managerBreakpoints[i];
            try {
                if (current.isRegistered() && current instanceof JavaScriptLineBreakpoint) {
                    QualifiedName qName;
                    JavaScriptLineBreakpoint breakpoint = (JavaScriptLineBreakpoint)current;
                    IResource resource = breakpoint.getMarker().getResource();
                    String url = resource.getPersistentProperty(qName = new QualifiedName("org.eclipse.wst.jsdt.core", "scriptURL"));
                    if (url == null) {
                        String path = breakpoint.getScriptPath();
                        url = JavaScriptDebugPlugin.getExternalScriptPath((IPath)new Path(path));
                    }
                    if (url != null) {
                        String condition;
                        HashMap<String, Object> location = new HashMap<String, Object>();
                        location.put("line", breakpoint.getLineNumber());
                        location.put("url", url);
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        if (breakpoint.isConditionEnabled() && (condition = breakpoint.getCondition()) != null) {
                            attributes.put("condition", condition);
                        }
                        attributes.put("enabled", new Boolean(breakpoint.isEnabled()));
                        int hitCount = breakpoint.getHitCount();
                        if (hitCount != -1) {
                            attributes.put("hitCount", hitCount);
                        }
                        HashMap<String, Object> bpMap = new HashMap<String, Object>();
                        bpMap.put("type", "line");
                        bpMap.put("location", location);
                        bpMap.put("attributes", attributes);
                        allBps.add(bpMap);
                    }
                }
            }
            catch (CoreException e) {
                CrossFirePlugin.log(e);
            }
            ++i;
        }
        if (allBps.size() > 0) {
            CFRequestPacket request2 = new CFRequestPacket("setBreakpoints", null);
            request2.setArgument("breakpoints", Arrays.asList(allBps.toArray()));
            response = ((CFVirtualMachine)this.virtualMachine()).sendRequest(request2);
            if (response.isSuccess()) {
                list = (List)response.getBody().get("breakpoints");
                if (list != null && list.size() > 0) {
                    for (Map bp : list) {
                        if (bp == null) continue;
                        RemoteBreakpoint rb = BreakpointTracker.addBreakpoint((CFVirtualMachine)this.virtualMachine(), bp);
                        BreakpointTracker.findLocalBreakpoint(rb);
                    }
                }
            } else if (TRACE) {
                Tracing.writeString("VM [failed setbreakpoints request]: " + JSON.serialize(request2));
            }
        }
        if ((response = this.sendRequest(request = new CFRequestPacket("getBreakpoints", null))).isSuccess()) {
            list = (List)response.getBody().get("breakpoints");
            Map bp2 = null;
            for (Map bp2 : list) {
                BreakpointTracker.createLocalBreakpoint(this, bp2);
            }
        } else if (TRACE) {
            Tracing.writeString("VM [failed getbreakpoints request]: " + JSON.serialize(request));
        }
    }

    public boolean supportsSuspendOnScriptLoads() {
        return false;
    }

    public void toggleBreakpoint(Map json) {
        if (json != null) {
            Boolean isset = (Boolean)json.get("set");
            if (isset != null && isset.booleanValue()) {
                Map bp = (Map)json.get("breakpoint");
                RemoteBreakpoint rb = BreakpointTracker.updateBreakpoint(bp);
                if (rb == null) {
                    BreakpointTracker.createLocalBreakpoint(this, bp);
                }
            } else {
                Map bp = (Map)json.get("breakpoint");
                Number handle = (Number)bp.get("handle");
                BreakpointTracker.removeLocalBreakpoint(this, handle);
            }
        }
    }

    boolean ready() {
        return !this.disconnected;
    }

    boolean createContext(String url) {
        if (url != null && this.ready()) {
            CFRequestPacket request = new CFRequestPacket("createContext", null);
            request.getArguments().put("url", url);
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                return true;
            }
            if (TRACE) {
                Tracing.writeString("VM [failed createcontext request]: " + JSON.serialize(request));
            }
        }
        return false;
    }

    CFStackFrame getFrame(String contextid, int index, boolean includescopes) {
        CFThreadReference thread;
        if (index > -1 && (thread = this.findThread(contextid)) != null) {
            CFRequestPacket request = new CFRequestPacket("frame", thread.id());
            request.setArgument("index", index);
            request.setArgument("includeScopes", new Boolean(includescopes));
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                return new CFStackFrame(this, thread, response.getBody());
            }
            if (TRACE) {
                Tracing.writeString("VM [failed frame request]: " + JSON.serialize(request));
            }
        }
        return null;
    }

    boolean enableTools(String[] tools) {
        if (tools != null && tools.length > 0 && this.ready()) {
            CFRequestPacket request = new CFRequestPacket("enableTools", null);
            request.getArguments().put("tools", Arrays.asList(tools));
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                return true;
            }
            if (TRACE) {
                Tracing.writeString("VM [failed enabletool request]: " + JSON.serialize(request));
            }
        }
        return false;
    }

    boolean disableTools(String[] tools) {
        if (tools != null && tools.length > 0 && this.ready()) {
            CFRequestPacket request = new CFRequestPacket("disableTools", null);
            request.getArguments().put("tools", Arrays.asList(tools));
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                return true;
            }
            if (TRACE) {
                Tracing.writeString("VM [failed disabletool request]: " + JSON.serialize(request));
            }
        }
        return false;
    }

    List allTools() {
        if (this.ready()) {
            CFRequestPacket request = new CFRequestPacket("getTools", null);
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                List tools = (List)response.getBody().get("tools");
                if (tools != null) {
                    return tools;
                }
            } else if (TRACE) {
                Tracing.writeString("VM [failed alltools request]: " + JSON.serialize(request));
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void resume() {
        if (this.ready() && this.threads != null) {
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : this.threads.entrySet()) {
                CFThreadReference thread = (CFThreadReference)entry2.getValue();
                if (!thread.isSuspended()) continue;
                CFRequestPacket request = new CFRequestPacket("continue", thread.id());
                CFResponsePacket response = this.sendRequest(request);
                if (response.isSuccess()) {
                    if (!thread.isSuspended()) continue;
                    thread.markSuspended(false);
                    continue;
                }
                if (!TRACE) continue;
                Tracing.writeString("VM [failed continue request][context: " + thread.id() + "]: " + JSON.serialize(request));
            }
        }
    }

    public void suspend() {
        if (this.ready() && this.threads != null) {
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : this.threads.entrySet()) {
                CFThreadReference thread = (CFThreadReference)entry2.getValue();
                if (!thread.isRunning()) continue;
                CFRequestPacket request = new CFRequestPacket("suspend", thread.id());
                CFResponsePacket response = this.sendRequest(request);
                if (response.isSuccess()) {
                    if (thread.isSuspended()) continue;
                    thread.markSuspended(true);
                    continue;
                }
                if (!TRACE) continue;
                Tracing.writeString("VM [failed suspend request]: " + JSON.serialize(request));
            }
        }
    }

    public void terminate() {
        if (this.ready()) {
            this.disconnectVM();
        }
    }

    public String name() {
        return Messages.vm_name;
    }

    public String description() {
        return Messages.crossfire_vm;
    }

    public synchronized String version() {
        if (this.ready()) {
            CFRequestPacket request = new CFRequestPacket("version", null);
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                Map json = response.getBody();
                return (String)json.get("version");
            }
            if (TRACE) {
                Tracing.writeString("VM [failed version request]: " + JSON.serialize(request));
            }
        }
        return "unknown";
    }

    public synchronized List allThreads() {
        if (this.threads == null) {
            this.threads = new HashMap();
            CFRequestPacket request = new CFRequestPacket("listContexts", null);
            CFResponsePacket response = this.sendRequest(request);
            if (response.isSuccess()) {
                List contexts = (List)response.getBody().get("contexts");
                for (Map json : contexts) {
                    CFThreadReference thread = new CFThreadReference(this, json);
                    this.threads.put(thread.id(), thread);
                }
            } else if (TRACE) {
                Tracing.writeString("VM [failed allthreads request]: " + JSON.serialize(request));
            }
        }
        return new ArrayList(this.threads.values());
    }

    public CFThreadReference addThread(String id, String url) {
        if (this.threads == null) {
            this.allThreads();
        }
        CFThreadReference thread = new CFThreadReference(this, id, url);
        this.threads.put(thread.id(), thread);
        return thread;
    }

    public void removeThread(String id) {
        if (this.threads != null) {
            Object obj = this.threads.remove(id);
            if (TRACE && obj == null) {
                Tracing.writeString("VM [failed to remove thread]: " + id);
            }
        }
    }

    public synchronized CFThreadReference findThread(String id) {
        if (this.threads == null) {
            this.allThreads();
        }
        CFThreadReference thread = (CFThreadReference)this.threads.get(id);
        if (TRACE && thread == null) {
            Tracing.writeString("VM [failed to find thread]: " + id);
        }
        return thread;
    }

    public synchronized List allScripts() {
        if (this.scripts == null) {
            this.scripts = new HashMap();
            List threads = this.allThreads();
            for (CFThreadReference thread : threads) {
                CFRequestPacket request = new CFRequestPacket("scripts", thread.id());
                request.setArgument("includeSource", Boolean.FALSE);
                CFResponsePacket response = this.sendRequest(request);
                if (response.isSuccess()) {
                    List scriptz = (List)response.getBody().get("scripts");
                    for (Map smap : scriptz) {
                        if (smap == null) continue;
                        CFScriptReference script = new CFScriptReference(this, thread.id(), smap);
                        this.scripts.put(script.url(), script);
                    }
                    continue;
                }
                if (!TRACE) continue;
                Tracing.writeString("VM [failed scripts request]: " + JSON.serialize(request));
            }
            if (this.scripts.size() < 1) {
                this.scripts = null;
                return Collections.EMPTY_LIST;
            }
        }
        return new ArrayList(this.scripts.values());
    }

    public synchronized CFScriptReference findScript(String url) {
        if (this.scripts == null) {
            this.allScripts();
        }
        CFScriptReference script = null;
        if (this.scripts != null) {
            script = (CFScriptReference)this.scripts.get(url);
        }
        if (script == null && TRACE) {
            Tracing.writeString("VM [failed to find script]: " + url);
        }
        return script;
    }

    public CFScriptReference addScript(String context_id, Map json) {
        if (this.scripts == null) {
            this.allScripts();
        }
        CFScriptReference script = new CFScriptReference(this, context_id, json);
        this.scripts.put(script.url(), script);
        return script;
    }

    public void removeScriptsForContext(String contextid) {
        if (this.scripts != null) {
            Map.Entry e = null;
            Iterator i = this.scripts.entrySet().iterator();
            while (i.hasNext()) {
                e = i.next();
                if (!contextid.equals(((CFScriptReference)e.getValue()).context())) continue;
                i.remove();
            }
        }
    }

    public void removeScript(String url) {
        if (this.scripts != null) {
            Object obj = this.scripts.remove(url);
            if (TRACE && obj == null) {
                Tracing.writeString("VM [failed to remove script]: " + url);
            }
        }
    }

    public synchronized void dispose() {
        try {
            if (TRACE) {
                Tracing.writeString("VM [disposing]");
            }
            this.queue.dispose();
            this.ermanager.dispose();
        }
        finally {
            this.disconnectVM();
        }
    }

    public UndefinedValue mirrorOfUndefined() {
        return this.undefinedvalue;
    }

    public NullValue mirrorOfNull() {
        return this.nullvalue;
    }

    public BooleanValue mirrorOf(boolean bool) {
        return new CFBooleanValue(this, bool);
    }

    public NumberValue mirrorOf(Number number) {
        return new CFNumberValue((VirtualMachine)this, number);
    }

    public StringValue mirrorOf(String string) {
        return new CFStringValue(this, string);
    }

    public synchronized EventRequestManager eventRequestManager() {
        return this.ermanager;
    }

    public synchronized EventQueue eventQueue() {
        return this.queue;
    }

    public CFEventPacket receiveEvent() throws TimeoutException, DisconnectedException {
        return (CFEventPacket)this.session.receive("event", 30000);
    }

    public CFEventPacket receiveEvent(int timeout) throws TimeoutException, DisconnectedException {
        return (CFEventPacket)this.session.receive("event", timeout);
    }

    public CFResponsePacket sendRequest(CFRequestPacket request) {
        try {
            this.session.send((Packet)request);
            return (CFResponsePacket)this.session.receiveResponse(request.getSequence(), 3000);
        }
        catch (DisconnectedException de) {
            this.disconnectVM();
            this.handleException(de.getMessage(), de.getCause() == null ? de : de.getCause());
        }
        catch (TimeoutException te) {
            CrossFirePlugin.log(te);
        }
        return CFResponsePacket.FAILED;
    }

    public synchronized void disconnectVM() {
        if (this.disconnected) {
            if (TRACE) {
                Tracing.writeString("VM [already disconnected]");
            }
            return;
        }
        if (TRACE) {
            Tracing.writeString("VM [disconnecting]");
        }
        try {
            if (this.threads != null) {
                this.threads.clear();
            }
            if (this.scripts != null) {
                this.scripts.clear();
            }
            this.queue.dispose();
            this.ermanager.dispose();
            this.session.dispose();
            BreakpointTracker.disconnect(this);
        }
        finally {
            this.disconnected = true;
        }
    }

    public boolean canUpdateBreakpoints() {
        return true;
    }

    public void updateBreakpoint(IJavaScriptBreakpoint breakpoint) {
        RemoteBreakpoint rb = BreakpointTracker.findRemoteBreakpoint(breakpoint);
        if (rb != null) {
            try {
                BreakpointTracker.syncRemoteBreakpoint(rb, breakpoint);
                CFRequestPacket request = new CFRequestPacket("changeBreakpoint", null);
                request.setArgument("handle", rb.getHandle());
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("enabled", rb.isEnabled());
                attributes.put("condition", rb.getCondition());
                request.setArgument("attributes", attributes);
                CFResponsePacket response = this.sendRequest(request);
                if (!response.isSuccess() && TRACE) {
                    Tracing.writeString("VM [failed changebreakpoint request]: " + JSON.serialize(request));
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

