/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.axis.creation.ui.plugin.WebServiceAxisCreationUIPlugin;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateAxisWSDDFileTask
extends AbstractDataModelOperation {
    private final String DEPLOY_XSL = "deploy.xsl";
    private final String DEPLOY_BAK = "deploy.wsdd.bak";
    private final String CLASSNAME_PARAM = "newClassName";
    private JavaWSDLParameter javaWSDLParam_;
    private IProject serviceProject_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        block8: {
            IEnvironment environment = this.getEnvironment();
            status = Status.OK_STATUS;
            if (this.javaWSDLParam_ == null) {
                status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
                environment.getStatusHandler().reportError(status);
                return status;
            }
            IProject project = this.serviceProject_;
            String outputLocation = this.javaWSDLParam_.getJavaOutput();
            if (outputLocation == null) {
                return status;
            }
            String webContentPath = J2EEUtils.getWebContentContainer((IProject)project).getLocation().toString();
            try {
                if (this.javaWSDLParam_.getDeploymentFiles() == null || this.javaWSDLParam_.getDeploymentFiles().length <= 0) break block8;
                String wsdd_deploy = this.javaWSDLParam_.getDeploymentFiles()[0];
                Path deployPath = new Path(wsdd_deploy);
                String deployBackup = deployPath.removeLastSegments(1).append("deploy.wsdd.bak").toString();
                FileUtil.createTargetFile((String)wsdd_deploy, (String)deployBackup, (boolean)true);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(this.getPluginFileAsInputStream("deploy.xsl")));
                transformer.setParameter("newClassName", this.javaWSDLParam_.getBeanName());
                try (FileOutputStream wsddStream = new FileOutputStream(wsdd_deploy);){
                    transformer.transform(new StreamSource(deployBackup), new StreamResult(wsddStream));
                }
                IResource deployFile = ResourceUtils.findResourceAtLocation((String)wsdd_deploy, (IProject)project);
                if (deployFile != null) {
                    deployFile.refreshLocal(0, monitor);
                }
            }
            catch (Exception e) {
                Object[] errorMsgStrings = new String[]{project.toString(), outputLocation.toString(), webContentPath.toString()};
                status = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_UPDATE_AXIS_WSDD, (Object[])errorMsgStrings), (Throwable)e);
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        return status;
    }

    private InputStream getPluginFileAsInputStream(String pluginfileName) throws CoreException {
        try {
            InputStream is = WebServiceAxisCreationUIPlugin.getInstance().getBundle().getEntry(pluginfileName).openStream();
            return is;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.creation.ui", 0, AxisCreationUIMessages.MSG_PLUGIN_FILE_URL, (Throwable)e));
        }
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }
}

