/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class CommonEditorPreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.sse.ui");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                CommonEditorPreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.wst.sse.ui");
            }
        }
        catch (BundleException e) {
            CommonEditorPreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.wst.sse.ui exception: " + (Object)((Object)e)));
        }
        this.bundleGetPreference("org.eclipse.wst.sse.ui", CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String value = Platform.getPreferencesService().getString(bundleName, prefKey, defaultValue, null);
        CommonEditorPreferencesTest.assertNotSame((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (Object)defaultValue, (Object)value);
    }

    public void testPluginGetDefaultPreferences() {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        this.pluginGetDefaultPreference(store, CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, Boolean.toString(true));
    }

    private void pluginGetDefaultPreference(IPreferenceStore store, String prefKey, String expected) {
        String defaultValue = store.getDefaultString(prefKey);
        CommonEditorPreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)defaultValue);
    }

    public void testPluginSetPreferences() {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        this.pluginSetPreferenceBoolean(store, CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
    }

    private void pluginSetPreferenceBoolean(IPreferenceStore store, String prefKey) {
        boolean originalValue = store.getBoolean(prefKey);
        boolean expectedValue = !originalValue;
        store.setValue(prefKey, expectedValue);
        boolean foundValue = store.getBoolean(prefKey);
        CommonEditorPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        store.setValue(prefKey, originalValue);
    }
}

