/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class ExclusivePositionUpdaterTest
extends TestCase {
    private IPositionUpdater fUpdater;
    private static final String CATEGORY = "testcategory";
    private Position fPos;
    private IDocument fDoc;

    public static Test suite() {
        return new TestSuite(ExclusivePositionUpdaterTest.class);
    }

    protected void setUp() throws Exception {
        this.fUpdater = new DefaultPositionUpdater(CATEGORY);
        this.fDoc = this.createDocument("ccccccccccccccccccccccccccccccccccccccccccccc");
        this.fPos = new Position(5, 5);
        this.fDoc.addPositionUpdater(this.fUpdater);
        this.fDoc.addPositionCategory(CATEGORY);
        this.fDoc.addPosition(CATEGORY, this.fPos);
    }

    private IDocument createDocument(String contents) {
        IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId("org.eclipse.core.runtime.xml");
        BasicStructuredDocument document = (BasicStructuredDocument)handler.getDocumentLoader().createNewStructuredDocument();
        document.set(contents);
        return document;
    }

    protected void tearDown() throws Exception {
        this.fDoc.removePositionUpdater(this.fUpdater);
        this.fDoc.removePositionCategory(CATEGORY);
    }

    public void testDeleteAfter() throws BadLocationException {
        this.fDoc.replace(20, 2, "");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testAddAfter() throws BadLocationException {
        this.fDoc.replace(20, 0, "yy");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testDeleteBefore() throws BadLocationException {
        this.fDoc.replace(2, 2, "");
        Assert.assertEquals((int)3, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testAddBefore() throws BadLocationException {
        this.fDoc.replace(2, 0, "yy");
        Assert.assertEquals((int)7, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testAddRightBefore() throws BadLocationException {
        this.fDoc.replace(5, 0, "yy");
        Assert.assertEquals((int)7, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testDeleteAtOffset() throws BadLocationException {
        this.fDoc.replace(5, 2, "");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)3, (int)this.fPos.length);
    }

    public void testDeleteRightBefore() throws BadLocationException {
        this.fDoc.replace(3, 2, "");
        Assert.assertEquals((int)3, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testAddRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 0, "yy");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testDeleteRightAfter() throws BadLocationException {
        this.fDoc.replace(10, 2, "");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)5, (int)this.fPos.length);
    }

    public void testAddWithin() throws BadLocationException {
        this.fDoc.replace(6, 0, "yy");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)7, (int)this.fPos.length);
    }

    public void testDeleteWithin() throws BadLocationException {
        this.fDoc.replace(6, 2, "");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)3, (int)this.fPos.length);
    }

    public void testReplaceLeftBorder() throws BadLocationException {
        this.fDoc.replace(4, 2, "yy");
        Assert.assertEquals((int)6, (int)this.fPos.offset);
        Assert.assertEquals((int)4, (int)this.fPos.length);
    }

    public void testReplaceRightBorder() throws BadLocationException {
        this.fDoc.replace(9, 2, "yy");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)4, (int)this.fPos.length);
    }

    public void testDeleteOverRightBorder() throws BadLocationException {
        this.fDoc.replace(9, 2, "");
        Assert.assertEquals((int)5, (int)this.fPos.offset);
        Assert.assertEquals((int)4, (int)this.fPos.length);
    }

    public void testDeleted() throws BadLocationException {
        this.fDoc.replace(4, 7, "");
        Assert.assertTrue((boolean)this.fPos.isDeleted);
    }

    public void testReplaced() throws BadLocationException {
        this.fDoc.replace(4, 7, "yyyyyyy");
        Assert.assertTrue((boolean)this.fPos.isDeleted);
    }
}

