/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.util;

import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ControlSwitcherTest {
    private PageBook pageBook;
    Composite pane1;
    Composite pane2;
    private Composite parent;

    private Composite buildPane1() {
        if (this.pane1 == null) {
            this.pane1 = new Composite((Composite)this.pageBook, 0);
            this.pane1.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(this.pane1, 0);
            label.setText("&Test2:");
            Text text = new Text(this.pane1, 2048);
            text.setLayoutData((Object)new GridData(768));
            Combo combo = new Combo(this.pane1, 2048);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            combo.setLayoutData((Object)data);
        }
        return this.pane1;
    }

    private Composite buildPane2() {
        if (this.pane2 == null) {
            this.pane2 = new Composite((Composite)this.pageBook, 0);
            this.pane2.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(this.pane2, 0);
            label.setText("&Test1:");
            Text text = new Text(this.pane2, 2048);
            text.setLayoutData((Object)new GridData(768));
        }
        return this.pane2;
    }

    private Transformer<Boolean, Control> buildTransformer() {
        return new PaneTransformer();
    }

    @Before
    public void setUp() {
        this.parent = new Composite((Composite)DisplayTools.getShell(), 0);
        this.parent.setLayout((Layout)new GridLayout());
        this.pageBook = new PageBook(this.parent, 0);
        this.pageBook.setLayoutData((Object)new GridData());
    }

    @After
    public void tearDown() {
        if (this.parent != null) {
            this.parent.dispose();
            this.parent = null;
            this.pageBook = null;
        }
    }

    @Test
    public void testSwitch() {
        SimplePropertyValueModel switchHolder = new SimplePropertyValueModel();
        Transformer<Boolean, Control> transformer = this.buildTransformer();
        this.pane1 = this.buildPane1();
        this.pane1.setVisible(false);
        this.pane2 = this.buildPane2();
        this.pane2.setVisible(false);
        SWTBindingTools.bind((PropertyValueModel)switchHolder, transformer, (PageBook)this.pageBook);
        switchHolder.setValue((Object)true);
        Control control = (Control)ObjectTools.get((Object)this.pageBook, (String)"currentPage");
        Assert.assertNotNull((String)"The page book's page shouldn't be null", (Object)control);
        Assert.assertSame((String)"The current pane should be pane1", (Object)this.pane1, (Object)control);
        Point pane1Size = this.pane1.computeSize(-1, -1);
        Point pageBookSize = this.pageBook.computeSize(-1, -1);
        Assert.assertEquals((String)"The width of the PageBook should be the same as the width of pane1", (long)pane1Size.x, (long)pageBookSize.x);
        Assert.assertEquals((String)"The height of the PageBook should be the same as the height of pane1", (long)pane1Size.y, (long)pageBookSize.y);
        switchHolder.setValue((Object)false);
        control = (Control)ObjectTools.get((Object)this.pageBook, (String)"currentPage");
        Assert.assertNotNull((String)"The page book's page shouldn't be null", (Object)control);
        Assert.assertSame((String)"The current pane should be pane2", (Object)this.pane2, (Object)control);
        Point pane2Size = this.pane2.computeSize(-1, -1);
        pageBookSize = this.pageBook.computeSize(-1, -1);
        Assert.assertEquals((String)"The width of the PageBook should be the same as the width of pane2", (long)pane2Size.x, (long)pageBookSize.x);
        Assert.assertEquals((String)"The height of the PageBook should be the same as the height of pane2", (long)pane2Size.y, (long)pageBookSize.y);
    }

    protected class PaneTransformer
    extends AbstractTransformer<Boolean, Control> {
        protected PaneTransformer() {
        }

        public Control transform_(Boolean value) {
            return value != false ? ControlSwitcherTest.this.pane1 : ControlSwitcherTest.this.pane2;
        }
    }
}

