/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.ConnectionCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowValidation;

public class ReconnectConnectionCommand
extends ConnectionCommand {
    public boolean canExecute() {
        if (this.link == null || this.link.eContainer() == null) {
            return false;
        }
        if (this.oldSource != null && this.source != null && this.oldTarget != null && this.target != null && !PageflowValidation.getInstance().isValidLinkForCreation(this.source, this.target)) {
            return false;
        }
        if (this.oldSource != null && this.source != null && !PageflowValidation.getInstance().isValidLinkForCreation(this.source, this.oldTarget)) {
            return false;
        }
        return this.oldTarget == null || this.target == null || PageflowValidation.getInstance().isValidLinkForCreation(this.oldSource, this.target);
    }

    public void doExecute() {
        String outcome = null;
        String action = null;
        String largeIcon = null;
        String smallIcon = null;
        boolean isRedirect = false;
        outcome = this.link.getOutcome();
        action = this.link.getFromaction();
        isRedirect = this.link.isRedirect();
        largeIcon = this.link.getLargeicon();
        smallIcon = this.link.getSmallicon();
        if (this.oldSource != null && this.source != null) {
            this.link.setSource(this.source);
        }
        if (this.oldTarget != null && this.target != null) {
            this.link.setTarget(this.target);
        }
        this.link.setOutcome(outcome);
        this.link.setFromaction(action);
        this.link.setLargeicon(largeIcon);
        this.link.setSmallicon(smallIcon);
        this.link.setRedirect(isRedirect);
    }

    public void undo() {
        if (this.canExecute()) {
            if (this.oldSource != null && this.source != null) {
                if (this.link.getSource() != null) {
                    this.link.getSource().getOutlinks().remove((Object)this.link);
                }
                this.source.getOutlinks().remove((Object)this.link);
                this.link.setSource(this.oldSource);
            }
            if (this.oldTarget != null && this.target != null) {
                if (this.link.getTarget() != null) {
                    this.link.getTarget().getInlinks().remove((Object)this.link);
                }
                this.target.getInlinks().remove((Object)this.link);
                this.link.setTarget(this.oldTarget);
            }
        }
    }
}

