/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.javaee.web.WelcomeFileList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class WebFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)cfg;
            IJavaProject jproj = JavaCore.create((IProject)project);
            WtpUtils.addNatures((IProject)project);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IPath pjpath = project.getFullPath();
            IPath contentdir = this.setContentPropertyIfNeeded(model, pjpath, project);
            WebFacetInstallDelegate.mkdirs(ws.getRoot().getFolder(contentdir));
            IPath webinf = contentdir.append("WEB-INF");
            IFolder webinfFolder = ws.getRoot().getFolder(webinf);
            WebFacetInstallDelegate.mkdirs(webinfFolder);
            IPath webinflib = webinf.append("lib");
            WebFacetInstallDelegate.mkdirs(ws.getRoot().getFolder(webinflib));
            IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
            c.create(0, null);
            String contextRoot = model.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
            this.setContextRootPropertyIfNeeded(c, contextRoot);
            this.setOutputFolder(model, c);
            IVirtualFolder webroot = c.getRootFolder();
            if (webroot.getProjectRelativePath().equals((Object)new Path("/"))) {
                Path configFolderPath = new Path(model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
                webroot.createLink((IPath)configFolderPath, 0, null);
                J2EEModuleVirtualComponent.setDefaultDeploymentDescriptorFolder((IVirtualFolder)webroot, (IPath)configFolderPath, null);
            }
            if (fv == WebFacetUtils.WEB_60) {
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
                    this.createWeb60DeploymentDescriptor(project, fv, webinfFolder, monitor);
                }
            } else if (fv == WebFacetUtils.WEB_50) {
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
                    this.createWeb50DeploymentDescriptor(project, fv, webinfFolder, monitor);
                }
            } else if (fv == WebFacetUtils.WEB_40) {
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
                    this.createWeb40DeploymentDescriptor(project, fv, webinfFolder, monitor);
                }
            } else if (fv == WebFacetUtils.WEB_31) {
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
                    this.createWeb31DeploymentDescriptor(project, fv, webinfFolder, monitor);
                }
            } else if (fv == WebFacetUtils.WEB_30) {
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
                    this.createWeb30DeploymentDescriptor(project, fv, webinfFolder, monitor);
                }
            } else if (fv == WebFacetUtils.WEB_25) {
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
                    this.createWeb25DeploymentDescriptor(project, fv, webinfFolder, monitor);
                }
            } else if (!webinfFolder.getFile("web.xml").exists()) {
                String ver = fv.getVersionString();
                int nVer = J2EEVersionUtil.convertVersionStringToInt((String)ver);
                WebArtifactEdit.createDeploymentDescriptor(project, nVer);
            }
            IVirtualFolder jsrc = c.getRootFolder().getFolder("/WEB-INF/classes");
            IClasspathEntry[] cp = jproj.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).segmentCount() > 0) {
                    try {
                        IFolder srcFolder = ws.getRoot().getFolder(cpe.getPath());
                        IVirtualResource[] virtualResource = ComponentCore.createResources((IResource)srcFolder);
                        if (virtualResource.length == 0) {
                            jsrc.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                        }
                    }
                    catch (Exception e) {
                        WebPlugin.logError(e);
                    }
                }
                ++i;
            }
            IVirtualFile vf = c.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            IFile manifestmf = vf.getUnderlyingFile();
            if (manifestmf == null || !manifestmf.exists()) {
                try {
                    this.createManifest(project, c.getRootFolder().getUnderlyingFolder(), monitor);
                }
                catch (InvocationTargetException e) {
                    WebPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    WebPlugin.logError(e);
                }
            }
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            if (model.getBooleanProperty("IWebFacetInstallDataModelProperties.INSTALL_WEB_LIBRARY")) {
                Path webLibContainer = new Path("org.eclipse.jst.j2ee.internal.web.container");
                WebFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)JavaCore.newContainerEntry((IPath)webLibContainer));
            }
            if (model.getBooleanProperty("IJ2EEModuleFacetInstallDataModelProperties.INSTALL_EAR_LIBRARY")) {
                Path earLibContainer = new Path("org.eclipse.jst.j2ee.internal.module.container");
                WebFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)JavaCore.newContainerEntry((IPath)earLibContainer));
            }
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                WebPlugin.logError(e);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void setContextRootPropertyIfNeeded(IVirtualComponent c, String contextRoot) {
        String existing = c.getMetaProperties().getProperty("context-root");
        if (existing == null) {
            c.setMetaProperty("context-root", contextRoot);
        }
    }

    private IPath setContentPropertyIfNeeded(IDataModel model, IPath pjpath, IProject project) {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
        if (c.exists() && !c.getRootFolder().getProjectRelativePath().isRoot()) {
            return c.getRootFolder().getUnderlyingResource().getFullPath();
        }
        return pjpath.append(model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
    }

    private void createWeb50DeploymentDescriptor(IProject project, IProjectFacetVersion fv, IFolder webinfFolder, IProgressMonitor monitor) throws CoreException {
        IFile webxmlFile = webinfFolder.getFile("web.xml");
        if (!webxmlFile.exists()) {
            try {
                webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"5.0\" xmlns=\"https://jakarta.ee/xml/ns/jakartaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/web-app_5_0.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                this.populateDefaultContent(project, fv);
            }
            catch (UnsupportedEncodingException e) {
                WebPlugin.logError(e);
            }
        }
    }

    private void createWeb60DeploymentDescriptor(IProject project, IProjectFacetVersion fv, IFolder webinfFolder, IProgressMonitor monitor) throws CoreException {
        IFile webxmlFile = webinfFolder.getFile("web.xml");
        if (!webxmlFile.exists()) {
            try {
                webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"6.0\" xmlns=\"https://jakarta.ee/xml/ns/jakartaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/web-app_6_0.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                this.populateDefaultContent(project, fv);
            }
            catch (UnsupportedEncodingException e) {
                WebPlugin.logError(e);
            }
        }
    }

    private void createWeb40DeploymentDescriptor(IProject project, IProjectFacetVersion fv, IFolder webinfFolder, IProgressMonitor monitor) throws CoreException {
        IFile webxmlFile = webinfFolder.getFile("web.xml");
        if (!webxmlFile.exists()) {
            try {
                webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"4.0\" xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_4_0.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                this.populateDefaultContent(project, fv);
            }
            catch (UnsupportedEncodingException e) {
                WebPlugin.logError(e);
            }
        }
    }

    private void createWeb31DeploymentDescriptor(IProject project, IProjectFacetVersion fv, IFolder webinfFolder, IProgressMonitor monitor) throws CoreException {
        IFile webxmlFile = webinfFolder.getFile("web.xml");
        if (!webxmlFile.exists()) {
            try {
                webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"3.1\" xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                this.populateDefaultContent(project, fv);
            }
            catch (UnsupportedEncodingException e) {
                WebPlugin.logError(e);
            }
        }
    }

    private void createWeb30DeploymentDescriptor(IProject project, IProjectFacetVersion fv, IFolder webinfFolder, IProgressMonitor monitor) throws CoreException {
        IFile webxmlFile = webinfFolder.getFile("web.xml");
        if (!webxmlFile.exists()) {
            try {
                webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                this.populateDefaultContent(project, fv);
            }
            catch (UnsupportedEncodingException e) {
                WebPlugin.logError(e);
            }
        }
    }

    private void createWeb25DeploymentDescriptor(IProject project, IProjectFacetVersion fv, IFolder webinfFolder, IProgressMonitor monitor) throws CoreException {
        IFile webxmlFile = webinfFolder.getFile("web.xml");
        if (!webxmlFile.exists()) {
            try {
                webxmlFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\">\n</web-app>".getBytes("UTF-8")), true, monitor);
                this.populateDefaultContent(project, fv);
            }
            catch (UnsupportedEncodingException e) {
                WebPlugin.logError(e);
            }
        }
    }

    private void populateDefaultContent(final IProject project, IProjectFacetVersion fv) {
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project, (IProjectFacetVersion)fv);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebApp webApp = (WebApp)provider.getModelObject();
                DisplayName displayName = JavaeeFactory.eINSTANCE.createDisplayName();
                displayName.setValue(project.getName());
                webApp.getDisplayNames().add(displayName);
                List<String> welcomeFiles = Arrays.asList("index.html", "index.jsp", "index.htm", "index.xhtml", "default.html", "default.jsp", "default.htm", "default.xhtml");
                WelcomeFileList welcomeFileList = WebFactory.eINSTANCE.createWelcomeFileList();
                welcomeFileList.getWelcomeFiles().addAll(welcomeFiles);
                webApp.getWelcomeFileLists().add(welcomeFileList);
            }
        };
        provider.modify(runnable, null);
    }

    private static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                WebFacetInstallDelegate.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        } else {
            IFolder x = folder;
            while (x instanceof IFolder && x.isDerived()) {
                x.setDerived(false);
                x = x.getParent();
            }
        }
    }
}

