/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.schema;

public enum JSONSchemaType {
    Array("array"),
    Boolean("boolean"),
    Integer("integer"),
    Number("number"),
    Null("null"),
    Object("object"),
    String("string");

    public static final JSONSchemaType[] EMPTY_TYPES;
    private final String name;

    static {
        EMPTY_TYPES = new JSONSchemaType[0];
    }

    private JSONSchemaType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static JSONSchemaType getType(String type) {
        if (type == null) {
            return null;
        }
        JSONSchemaType t = null;
        JSONSchemaType[] types = JSONSchemaType.values();
        int i = 0;
        while (i < types.length) {
            t = types[i];
            if (t.getName().equals(type)) {
                return t;
            }
            ++i;
        }
        return null;
    }
}

