/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import org.eclipse.jpt.common.utility.factory.Factory;

public class ThreadLocalFactory<T>
implements Factory<T> {
    private final ThreadLocal<Factory<? extends T>> threadLocal;
    private final Factory<? extends T> defaultFactory;

    public ThreadLocalFactory(Factory<? extends T> defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException();
        }
        this.defaultFactory = defaultFactory;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<Factory<? extends T>> buildThreadLocal() {
        return new ThreadLocal<Factory<? extends T>>();
    }

    @Override
    public T create() {
        return this.get().create();
    }

    private Factory<? extends T> get() {
        Factory<? extends T> factory = this.threadLocal.get();
        return factory != null ? factory : this.defaultFactory;
    }

    public void set(Factory<? extends T> factory) {
        this.threadLocal.set(factory);
    }

    public String toString() {
        return this.get().toString();
    }
}

