/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public final class OpenDeclarationHyperlink
implements IHyperlink {
    private String typeName;
    private IJavaProject javaProject;
    private IRegion region;
    private String hyperlinkText;

    public OpenDeclarationHyperlink(IJavaProject javaProject, String typeName, IRegion region, String hyperlinkText) {
        this.region = region;
        this.typeName = typeName;
        this.javaProject = javaProject;
        this.hyperlinkText = hyperlinkText;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        try {
            IType type = this.javaProject.findType(this.typeName);
            IJavaElement javaElement = type.getParent();
            IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)false);
            if (editorPart instanceof ITextEditor) {
                ISourceRange range = type.getNameRange();
                ((ITextEditor)editorPart).selectAndReveal(range.getOffset(), range.getLength());
            }
        }
        catch (Exception e) {
            JptJpaUiPlugin.instance().logError(e);
        }
    }
}

