/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class NewJavaClassDataModelProvider
extends ArtifactEditOperationDataModelProvider {
    protected IStatus validateJavaSourceFolder(String folderFullPath) {
        if (folderFullPath == null || folderFullPath.length() == 0) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NAME_EMPTY;
            return J2EEPlugin.createStatus(4, msg);
        }
        if (!new Path(folderFullPath).isAbsolute()) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_ABSOLUTE;
            return J2EEPlugin.createStatus(4, msg);
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_EXIST;
            return J2EEPlugin.createStatus(4, msg);
        }
        if (!project.isAccessible()) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_EXIST;
            return J2EEPlugin.createStatus(4, msg);
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                String msg = J2EECommonMessages.ERR_JAVA_CLASS_NOT_JAVA_PROJECT;
                return J2EEPlugin.createStatus(4, msg);
            }
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
        IFolder sourcefolder = this.getJavaSourceFolder();
        if (sourcefolder == null || !sourcefolder.getFullPath().equals((Object)new Path(folderFullPath))) {
            String msg = J2EECommonMessages.getResourceString(J2EECommonMessages.ERR_JAVA_CLASS_FOLDER_NOT_SOURCE, new String[]{folderFullPath});
            return J2EEPlugin.createStatus(4, msg);
        }
        return J2EEPlugin.OK_STATUS;
    }

    protected IContainer getDefaultJavaSourceFolder() {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        try {
            IClasspathEntry[] entries = JavaCore.create((IProject)project).getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3) {
                    return project.getFolder(entries[i].getPath());
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            J2EEPlugin.logError((CoreException)((Object)e));
        }
        return null;
    }

    public IDataModelOperation getDefaultOperation() {
        return new NewJavaClassOperation(this.getDataModel());
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewJavaClassDataModel.SOURCE_FOLDER");
        propertyNames.add("NewJavaClassDataModel.JAVA_PACKAGE");
        propertyNames.add("NewJavaClassDataModel.CLASS_NAME");
        propertyNames.add("NewJavaClassDataModel.SUPERCLASS");
        propertyNames.add("NewJavaClassDataModel.MODIFIER_PUBLIC");
        propertyNames.add("NewJavaClassDataModel.MODIFIER_ABSTRACT");
        propertyNames.add("NewJavaClassDataModel.MODIFIER_FINAL");
        propertyNames.add("NewJavaClassDataModel.INTERFACES");
        propertyNames.add("NewJavaClassDataModel.MAIN_METHOD");
        propertyNames.add("NewJavaClassDataModel.CONSTRUCTOR");
        propertyNames.add("NewJavaClassDataModel.ABSTRACT_METHODS");
        propertyNames.add("NewJavaClassDataModel.OPEN_IN_EDITOR");
        propertyNames.add("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        propertyNames.add("NewJavaClassDataModel.JAVA_SOURCE_FOLDER");
        propertyNames.add("NewJavaClassDataModel.PROJECT");
        propertyNames.add("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
        propertyNames.add("INewJavaClassDataModelProperties.GENERATE_DD");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            IContainer sourceFolder = this.getDefaultJavaSourceFolder();
            if (sourceFolder != null && sourceFolder.exists()) {
                return sourceFolder.getFullPath().toOSString();
            }
        } else {
            if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
                return new String("java.lang.Object");
            }
            if (propertyName.equals("NewJavaClassDataModel.MODIFIER_PUBLIC")) {
                return Boolean.TRUE;
            }
            if (propertyName.equals("NewJavaClassDataModel.CONSTRUCTOR")) {
                return Boolean.TRUE;
            }
            if (propertyName.equals("NewJavaClassDataModel.ABSTRACT_METHODS")) {
                return Boolean.TRUE;
            }
            if (propertyName.equals("NewJavaClassDataModel.OPEN_IN_EDITOR")) {
                return Boolean.TRUE;
            }
            if (propertyName.equals("NewJavaClassDataModel.PROJECT")) {
                return this.getTargetProject();
            }
            if (propertyName.equals("NewJavaClassDataModel.JAVA_SOURCE_FOLDER")) {
                return this.getJavaSourceFolder();
            }
            if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT")) {
                return this.getJavaPackageFragmentRoot();
            }
            if (propertyName.equals("NewJavaClassDataModel.QUALIFIED_CLASS_NAME")) {
                return this.getQualifiedClassName();
            }
            if ("INewJavaClassDataModelProperties.GENERATE_DD".equals(propertyName)) {
                return Boolean.FALSE;
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    private String getQualifiedClassName() {
        String packageName = this.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + "." + className;
        }
        return className;
    }

    public IStatus validate(String propertyName) {
        IStatus existsStatus;
        IStatus result = super.validate(propertyName);
        if (result != null && !result.isOK()) {
            return result;
        }
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            return this.validateJavaSourceFolder(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && (result = this.validateJavaClassName(this.getStringProperty(propertyName))).getSeverity() != 4 && (existsStatus = this.canCreateTypeInClasspath(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"))).matches(6)) {
            result = existsStatus;
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return this.validateSuperclass(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.MODIFIER_ABSTRACT") || propertyName.equals("NewJavaClassDataModel.MODIFIER_FINAL")) {
            return this.validateModifier(propertyName, this.getBooleanProperty(propertyName));
        }
        if (result == null) {
            result = J2EEPlugin.OK_STATUS;
        }
        return result;
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName != null && packName.trim().length() > 0) {
            IStatus javaStatus = JavaConventions.validatePackageName((String)packName);
            if (javaStatus.getSeverity() == 4) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
                return J2EEPlugin.createStatus(4, msg);
            }
            if (javaStatus.getSeverity() == 2) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
                return J2EEPlugin.createStatus(2, msg);
            }
        }
        return J2EEPlugin.OK_STATUS;
    }

    protected IStatus validateJavaClassName(String className) {
        if (className == null || className.trim().length() == 0) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_NAME_EMPTY;
            return J2EEPlugin.createStatus(4, msg);
        }
        if (className.lastIndexOf(46) != -1) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_NAME_QUALIFIED;
            return J2EEPlugin.createStatus(4, msg);
        }
        IStatus javaStatus = JavaConventions.validateJavaTypeName((String)className);
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_CLASS_NAME_INVALID) + javaStatus.getMessage();
            return J2EEPlugin.createStatus(4, msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_CLASS_NAME_WARNING) + javaStatus.getMessage();
            return J2EEPlugin.createStatus(2, msg);
        }
        return J2EEPlugin.OK_STATUS;
    }

    private IStatus validateSuperclass(String superclassName) {
        IStatus status;
        if (superclassName == null || superclassName.trim().length() == 0) {
            String msg = J2EECommonMessages.ERR_JAVA_CLASS_NAME_EMPTY;
            return J2EEPlugin.createStatus(4, msg);
        }
        if (superclassName.equals("java.lang.Object")) {
            return J2EEPlugin.OK_STATUS;
        }
        String className = superclassName;
        int index = superclassName.lastIndexOf(".");
        if (index != -1) {
            className = superclassName.substring(index + 1);
        }
        if ((status = this.validateJavaClassName(className)).getSeverity() != 4) {
            IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.getTargetProject());
            IType supertype = null;
            try {
                supertype = javaProject.findType(superclassName);
            }
            catch (Exception exception) {}
            if (supertype == null) {
                String msg = J2EECommonMessages.ERR_JAVA_CLASS_SUPERCLASS_NOT_EXIST;
                return J2EEPlugin.createStatus(4, msg);
            }
            int flags = -1;
            try {
                flags = supertype.getFlags();
                if (Modifier.isFinal(flags)) {
                    String msg = J2EECommonMessages.ERR_JAVA_CLASS_SUPERCLASS_FINAL;
                    return J2EEPlugin.createStatus(4, msg);
                }
            }
            catch (Exception e) {
                J2EEPlugin.logError(e);
            }
        }
        return status;
    }

    private IStatus validateModifier(String propertyName, boolean prop) {
        if (prop) {
            if (propertyName.equals("NewJavaClassDataModel.MODIFIER_ABSTRACT") && this.getBooleanProperty("NewJavaClassDataModel.MODIFIER_FINAL")) {
                String msg = J2EECommonMessages.ERR_BOTH_FINAL_AND_ABSTRACT;
                return J2EEPlugin.createStatus(4, msg);
            }
            if (propertyName.equals("NewJavaClassDataModel.MODIFIER_FINAL") && this.getBooleanProperty("NewJavaClassDataModel.MODIFIER_ABSTRACT")) {
                String msg = J2EECommonMessages.ERR_BOTH_FINAL_AND_ABSTRACT;
                return J2EEPlugin.createStatus(4, msg);
            }
        }
        return J2EEPlugin.OK_STATUS;
    }

    protected IStatus canCreateTypeInClasspath(String className) {
        String packageName = this.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        return this.canCreateTypeInClasspath(packageName, className);
    }

    protected IStatus canCreateTypeInClasspath(String packageName, String typeName) {
        IPackageFragmentRoot packRoot = this.getJavaPackageFragmentRoot();
        IPackageFragment pack = null;
        if (packRoot != null) {
            pack = packRoot.getPackageFragment(packageName);
        }
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            String fullyQualifiedName = JavaModelUtil.getFullyQualifiedName(cu.getType(typeName));
            IResource resource = cu.getResource();
            if (resource.exists()) {
                String message = NLS.bind((String)J2EECommonMessages.ERR_TYPE_ALREADY_EXIST, (Object[])new Object[]{fullyQualifiedName});
                return J2EEPlugin.createStatus(4, message);
            }
            URI location = resource.getLocationURI();
            if (location != null) {
                try {
                    IFileStore store = EFS.getStore((URI)location);
                    if (store.fetchInfo().exists()) {
                        String message = NLS.bind((String)J2EECommonMessages.ERR_TYPE_DIFFERENT_CASE_EXIST, (Object[])new Object[]{fullyQualifiedName});
                        return J2EEPlugin.createStatus(4, message);
                    }
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(e);
                }
            }
        }
        return J2EEPlugin.OK_STATUS;
    }

    protected final IFolder getJavaSourceFolder() {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers(this.getTargetProject());
        if (sources == null || sources.length == 0) {
            return null;
        }
        String folderFullPath = this.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        int i = 0;
        while (i < sources.length) {
            if (sources[i].getPath().equals((Object)new Path(folderFullPath))) {
                try {
                    return (IFolder)sources[i].getCorrespondingResource();
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    protected IPackageFragmentRoot getJavaPackageFragmentRoot() {
        IFolder sourcefolder;
        IJavaProject aJavaProject;
        IProject project = this.getTargetProject();
        if (project != null && (aJavaProject = JemProjectUtilities.getJavaProject((IProject)project)) != null && (sourcefolder = (IFolder)this.getProperty("NewJavaClassDataModel.JAVA_SOURCE_FOLDER")) != null) {
            return aJavaProject.getPackageFragmentRoot((IResource)sourcefolder);
        }
        return null;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (result && ("IArtifactEditOperationDataModelProperties.COMPONENT_NAME".equals(propertyName) || "IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName)) && this.getDefaultJavaSourceFolder() != null) {
            this.setProperty("NewJavaClassDataModel.SOURCE_FOLDER", this.getDefaultJavaSourceFolder().getFullPath().toOSString());
        }
        return result;
    }
}

