/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.cnf.CompositeServerImageDescriptor;
import org.eclipse.wst.server.ui.internal.cnf.ServerContentProvider;
import org.eclipse.wst.server.ui.internal.cnf.ServerDecorator;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.viewers.BaseCellLabelProvider;
import org.osgi.framework.Bundle;

public class ServerLabelProvider
extends BaseCellLabelProvider {
    private final Map<String, Image> providerImageCache = new HashMap<String, Image>();

    public String getText(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            if (ms.module == null) {
                return "";
            }
            return ms.getModuleDisplayName();
        }
        if (element instanceof IServer) {
            IServer server = (IServer)element;
            return this.notNull(server.getName());
        }
        if (element == ServerContentProvider.INITIALIZING) {
            return Messages.viewInitializing;
        }
        if (element instanceof IWorkspaceRoot) {
            return Platform.getResourceString((Bundle)ServerUIPlugin.getInstance().getBundle(), (String)"%viewServers");
        }
        return "";
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.providerImageCache != null) {
            Iterator<Image> providerImageCacheIterator = this.providerImageCache.values().iterator();
            while (providerImageCacheIterator.hasNext()) {
                providerImageCacheIterator.next().dispose();
            }
            this.providerImageCache.clear();
        }
    }

    public Image getImage(Object element) {
        Image serverStatusImg;
        Image serverTypeImg;
        String key;
        IServer server;
        Image image = null;
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            ILabelProvider labelProvider = ServerUICore.getLabelProvider();
            image = labelProvider.getImage((Object)ms.module[ms.module.length - 1]);
            labelProvider.dispose();
        } else if (element instanceof IServer && (server = (IServer)element).getServerType() != null && (image = this.providerImageCache.get(key = this.getCacheKey(server, serverTypeImg = ImageResource.getImage(server.getServerType().getId()), serverStatusImg = ServerDecorator.getServerStateImageOverlay(server)))) == null) {
            CompositeServerImageDescriptor dsid = new CompositeServerImageDescriptor(serverTypeImg, serverStatusImg);
            image = dsid.createImage();
            this.providerImageCache.put(key, image);
        }
        return image;
    }

    private final String getCacheKey(IServer server, Image serverTypeImg, Image serverStatusImg) {
        StringBuffer key = new StringBuffer();
        if (server != null) {
            key.append(server.getName());
        }
        if (serverTypeImg != null) {
            key.append(serverTypeImg.toString());
        }
        if (serverStatusImg != null) {
            key.append(serverStatusImg.toString());
        }
        return key.toString();
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof IServer && property.equalsIgnoreCase("ICON")) {
            return true;
        }
        return true;
    }

    @Override
    public Image getColumnImage(Object element, int index) {
        return null;
    }

    @Override
    public String getColumnText(Object element, int index) {
        return null;
    }
}

