/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.CompoundPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class ANDTests
extends TestCase {
    private CompoundPredicate<Number> andPredicate;

    public ANDTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.andPredicate = PredicateTools.and((Predicate[])new Predicate[]{this.buildMin(1.0), this.buildMax(10.0)});
    }

    private Predicate<Number> buildMin(double min) {
        return new Min(min);
    }

    private Predicate<Number> buildMax(double max) {
        return new Max(max);
    }

    private Predicate<Number> buildIsEven() {
        return new IsEven();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate2() {
        ANDTests.assertTrue((boolean)this.andPredicate.evaluate((Object)new Integer(7)));
        ANDTests.assertTrue((boolean)this.andPredicate.evaluate((Object)new Integer(2)));
        ANDTests.assertTrue((boolean)this.andPredicate.evaluate((Object)new Double(6.666)));
        ANDTests.assertFalse((boolean)this.andPredicate.evaluate((Object)new Double(-99.0)));
        ANDTests.assertFalse((boolean)this.andPredicate.evaluate((Object)new Double(-1.0)));
        ANDTests.assertFalse((boolean)this.andPredicate.evaluate((Object)new Double(11.0)));
        ANDTests.assertFalse((boolean)this.andPredicate.evaluate((Object)new Double(111.0)));
    }

    public void testEvaluate3() {
        CompoundPredicate andPredicate2 = PredicateTools.and((Predicate[])new Predicate[]{this.andPredicate, this.buildIsEven()});
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Integer(7)));
        ANDTests.assertTrue((boolean)andPredicate2.evaluate((Object)new Integer(2)));
        ANDTests.assertTrue((boolean)andPredicate2.evaluate((Object)new Double(6.1)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(-99.0)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(-1.0)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(11.0)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(111.0)));
    }

    public void testComposite() {
        CompoundPredicate andPredicate2 = PredicateTools.and((Predicate[])new Predicate[]{this.buildMin(1.0), this.buildMax(10.0), this.buildIsEven()});
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Integer(7)));
        ANDTests.assertTrue((boolean)andPredicate2.evaluate((Object)new Integer(2)));
        ANDTests.assertTrue((boolean)andPredicate2.evaluate((Object)new Double(6.1)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(-99.0)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(-1.0)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(11.0)));
        ANDTests.assertFalse((boolean)andPredicate2.evaluate((Object)new Double(111.0)));
    }

    public void testEquals() {
        CompoundPredicate andPredicate2 = PredicateTools.and((Predicate[])new Predicate[]{this.buildMin(1.0), this.buildMax(10.0)});
        ANDTests.assertEquals(this.andPredicate, (Object)andPredicate2);
        ANDTests.assertEquals((int)this.andPredicate.hashCode(), (int)andPredicate2.hashCode());
        ANDTests.assertFalse((boolean)this.andPredicate.equals((Object)IsNotNull.instance()));
    }

    static class IsEven
    extends PredicateAdapter<Number> {
        IsEven() {
        }

        public boolean evaluate(Number number) {
            return BitTools.isEven((int)number.intValue());
        }
    }

    static class Max
    extends CriterionPredicate<Number, Number> {
        Max(double max) {
            super((Object)new Double(max));
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() <= ((Number)this.criterion).doubleValue();
        }
    }

    static class Min
    extends CriterionPredicate<Number, Number> {
        Min(double min) {
            super((Object)new Double(min));
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() >= ((Number)this.criterion).doubleValue();
        }
    }
}

