/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal.platforms;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.tests.internal.platforms.DTPPlatformTests;

public class PostgreSQLTests
extends DTPPlatformTests {
    private static final String CR = System.getProperty("line.separator");

    public PostgreSQLTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformPropertiesFileName() {
        return "postgresql.properties";
    }

    @Override
    protected String getDriverName() {
        return "PostgreSQL JDBC Driver";
    }

    @Override
    protected String getDriverDefinitionID() {
        return "DriverDefn.PostgreSQL JDBC Driver";
    }

    @Override
    protected String getDriverDefinitionType() {
        return "org.eclipse.datatools.enablement.postgresql.postgresqlDriverTemplate";
    }

    @Override
    protected String getDatabaseVendor() {
        return "postgres";
    }

    @Override
    protected String getDatabaseVersion() {
        return "8.x";
    }

    @Override
    protected String getDriverClass() {
        return "org.postgresql.Driver";
    }

    @Override
    protected String getDefaultJDBCURL() {
        return "jdbc:postgresql";
    }

    @Override
    protected String getProfileName() {
        return "PostgreSQL";
    }

    @Override
    protected String getProfileDescription() {
        return "PostgreSQL 8.2 JDBC Profile [Test]";
    }

    @Override
    protected boolean supportsCatalogs() {
        return true;
    }

    @Override
    protected boolean executeOfflineTests() {
        return false;
    }

    public void testSchema() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSchema("TEST1");
        this.dropSchema("TEST2");
        this.executeUpdate("CREATE SCHEMA TEST1");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema1 = this.getDefaultCatalog().getSchemaForIdentifier("TEST1");
        PostgreSQLTests.assertNotNull((Object)schema1);
        this.executeUpdate("CREATE SCHEMA TEST2");
        Schema schema2 = this.getDefaultCatalog().getSchemaForIdentifier("TEST2");
        PostgreSQLTests.assertNull((Object)schema2);
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        PostgreSQLTests.assertSame((Object)this.getDatabase(), (Object)listener.changedDatabase);
        schema2 = this.getDefaultCatalog().getSchemaForIdentifier("TEST2");
        PostgreSQLTests.assertNotNull((Object)schema2);
        PostgreSQLTests.assertNotSame((Object)schema1, (Object)this.getDefaultCatalog().getSchemaForIdentifier("TEST1"));
        this.dropSchema("TEST2");
        this.dropSchema("TEST1");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testSchemaLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSchema("LOOKUP_TEST");
        this.dropSchema("\"lookup_TEST\"");
        this.executeUpdate("CREATE SCHEMA LOOKUP_TEST");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaNamed("LOOKUP_TEST"));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("LOOKUP_TEST"));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaNamed("lookup_test"));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("lookup_test"));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaNamed("lookup_TEST"));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("lookup_TEST"));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("\"lookup_test\""));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("\"lookup_TEST\""));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("\"LOOKUP_TEST\""));
        this.dropSchema("LOOKUP_TEST");
        this.executeUpdate("CREATE SCHEMA \"lookup_TEST\"");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaNamed("LOOKUP_TEST"));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("LOOKUP_TEST"));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaNamed("lookup_test"));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("lookup_test"));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaNamed("lookup_TEST"));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("lookup_TEST"));
        PostgreSQLTests.assertNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("\"LOOKUP_TEST\""));
        PostgreSQLTests.assertNotNull((Object)this.getDefaultCatalog().getSchemaForIdentifier("\"lookup_TEST\""));
        this.dropSchema("\"lookup_TEST\"");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testSchemaIdentifier() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSchema("LOOKUP_TEST");
        this.dropSchema("\"lookup_TEST\"");
        this.executeUpdate("CREATE SCHEMA lookup_test");
        this.executeUpdate("CREATE SCHEMA \"lookup_TEST\"");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDefaultCatalog().getSchemaForIdentifier("LOOKUP_TEST");
        PostgreSQLTests.assertEquals((String)"lookup_test", (String)schema.getIdentifier());
        PostgreSQLTests.assertEquals((String)"lookup_test", (String)schema.getIdentifier("LookupTest"));
        PostgreSQLTests.assertNull((Object)schema.getIdentifier("Lookup_Test"));
        schema = this.getDefaultCatalog().getSchemaNamed("lookup_test");
        PostgreSQLTests.assertEquals((String)"lookup_test", (String)schema.getIdentifier());
        schema = this.getDefaultCatalog().getSchemaForIdentifier("\"lookup_TEST\"");
        PostgreSQLTests.assertEquals((String)"\"lookup_TEST\"", (String)schema.getIdentifier());
        PostgreSQLTests.assertEquals((String)"\"lookup_TEST\"", (String)schema.getIdentifier("lookup_TEST"));
        this.dropSchema("\"lookup_TEST\"");
        this.dropSchema("LOOKUP_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testTable() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("TABLE_TEST", "FOO_BAZ");
        this.dropTable("TABLE_TEST", "BAZ");
        this.dropTable("TABLE_TEST", "FOO");
        this.dropTable("TABLE_TEST", "BAR");
        this.dropSchema("TABLE_TEST");
        this.executeUpdate("CREATE SCHEMA TABLE_TEST");
        this.executeUpdate("SET search_path TO TABLE_TEST");
        this.executeUpdate(this.buildBarDDL());
        this.executeUpdate(this.buildFooDDL());
        this.executeUpdate(this.buildBazDDL());
        this.executeUpdate(this.buildFooBazDDL());
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDefaultCatalog().getSchemaForIdentifier("TABLE_TEST");
        Table fooTable = schema.getTableForIdentifier("FOO");
        PostgreSQLTests.assertEquals((int)3, (int)fooTable.getColumnsSize());
        PostgreSQLTests.assertEquals((int)1, (int)fooTable.getPrimaryKeyColumnsSize());
        PostgreSQLTests.assertEquals((int)1, (int)fooTable.getForeignKeysSize());
        Column pkColumn = fooTable.getPrimaryKeyColumn();
        PostgreSQLTests.assertEquals((String)"id", (String)pkColumn.getName());
        Column idColumn = fooTable.getColumnForIdentifier("ID");
        PostgreSQLTests.assertSame((Object)pkColumn, (Object)idColumn);
        PostgreSQLTests.assertEquals((String)"INT4", (String)idColumn.getDataTypeName());
        PostgreSQLTests.assertSame((Object)fooTable, (Object)idColumn.getTable());
        PostgreSQLTests.assertTrue((boolean)idColumn.isPartOfPrimaryKey());
        PostgreSQLTests.assertFalse((boolean)idColumn.isPartOfForeignKey());
        PostgreSQLTests.assertEquals((String)"java.lang.Integer", (String)idColumn.getJavaTypeDeclaration());
        Column nameColumn = fooTable.getColumnForIdentifier("NAME");
        PostgreSQLTests.assertEquals((String)"VARCHAR", (String)nameColumn.getDataTypeName());
        PostgreSQLTests.assertEquals((String)"java.lang.String", (String)nameColumn.getJavaTypeDeclaration());
        PostgreSQLTests.assertFalse((boolean)nameColumn.isPartOfPrimaryKey());
        Column barColumn = fooTable.getColumnForIdentifier("BAR_ID");
        PostgreSQLTests.assertEquals((String)"INT4", (String)barColumn.getDataTypeName());
        PostgreSQLTests.assertTrue((boolean)barColumn.isPartOfForeignKey());
        PostgreSQLTests.assertFalse((boolean)barColumn.isPartOfPrimaryKey());
        ForeignKey barFK = (ForeignKey)fooTable.getForeignKeys().iterator().next();
        PostgreSQLTests.assertEquals((int)1, (int)barFK.getColumnPairsSize());
        PostgreSQLTests.assertEquals((String)"bar", (String)barFK.getAttributeName());
        PostgreSQLTests.assertNull((Object)barFK.getJoinColumnAnnotationIdentifier("bar"));
        PostgreSQLTests.assertEquals((String)"bar_id", (String)barFK.getJoinColumnAnnotationIdentifier("primaryBar"));
        PostgreSQLTests.assertSame((Object)fooTable, (Object)barFK.getBaseTable());
        PostgreSQLTests.assertFalse((boolean)fooTable.isPossibleJoinTable());
        PostgreSQLTests.assertSame((Object)schema, (Object)fooTable.getSchema());
        Table barTable = schema.getTableForIdentifier("BAR");
        PostgreSQLTests.assertEquals((int)2, (int)barTable.getColumnsSize());
        PostgreSQLTests.assertEquals((int)1, (int)barTable.getPrimaryKeyColumnsSize());
        PostgreSQLTests.assertEquals((int)0, (int)barTable.getForeignKeysSize());
        PostgreSQLTests.assertEquals((String)"id", (String)barTable.getPrimaryKeyColumn().getName());
        PostgreSQLTests.assertFalse((boolean)barTable.isPossibleJoinTable());
        PostgreSQLTests.assertEquals((String)"BYTEA", (String)barTable.getColumnForIdentifier("CHUNK").getDataTypeName());
        PostgreSQLTests.assertEquals((String)"byte[]", (String)barTable.getColumnForIdentifier("CHUNK").getJavaTypeDeclaration());
        PostgreSQLTests.assertSame((Object)barTable, (Object)barFK.getReferencedTable());
        Table foo_bazTable = schema.getTableForIdentifier("FOO_BAZ");
        PostgreSQLTests.assertEquals((int)2, (int)foo_bazTable.getColumnsSize());
        PostgreSQLTests.assertEquals((int)0, (int)foo_bazTable.getPrimaryKeyColumnsSize());
        PostgreSQLTests.assertEquals((int)2, (int)foo_bazTable.getForeignKeysSize());
        PostgreSQLTests.assertTrue((boolean)foo_bazTable.isPossibleJoinTable());
        PostgreSQLTests.assertTrue((boolean)foo_bazTable.joinTableNameIsDefault());
        PostgreSQLTests.assertTrue((boolean)foo_bazTable.getColumnForIdentifier("FOO_ID").isPartOfForeignKey());
        this.dropTable("TABLE_TEST", "FOO_BAZ");
        this.dropTable("TABLE_TEST", "BAZ");
        this.dropTable("TABLE_TEST", "FOO");
        this.dropTable("TABLE_TEST", "BAR");
        this.dropSchema("TABLE_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private String buildBarDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE BAR (").append(CR);
        sb.append("    ID integer PRIMARY KEY,").append(CR);
        sb.append("    CHUNK bytea").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE FOO (").append(CR);
        sb.append("    ID integer PRIMARY KEY,").append(CR);
        sb.append("    NAME varchar(20),").append(CR);
        sb.append("    BAR_ID integer REFERENCES BAR(ID)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE BAZ (").append(CR);
        sb.append("    ID integer PRIMARY KEY,").append(CR);
        sb.append("    NAME varchar(20)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE FOO_BAZ (").append(CR);
        sb.append("    FOO_ID int REFERENCES FOO(ID),").append(CR);
        sb.append("    BAZ_ID int REFERENCES BAZ(ID)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    public void testColumnLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("TABLE_TEST", "test");
        this.dropSchema("TABLE_TEST");
        this.executeUpdate("CREATE SCHEMA TABLE_TEST");
        this.executeUpdate("SET search_path TO TABLE_TEST");
        this.executeUpdate("CREATE TABLE test (id int, name varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Table table = this.getDefaultCatalog().getSchemaForIdentifier("TABLE_TEST").getTableForIdentifier("test");
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        this.dropTable("TABLE_TEST", "test");
        this.executeUpdate("CREATE TABLE test (ID int, NAME varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDefaultCatalog().getSchemaForIdentifier("TABLE_TEST").getTableForIdentifier("test");
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("ID"));
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("NAME"));
        this.dropTable("TABLE_TEST", "test");
        this.executeUpdate("CREATE TABLE test (Id int, Name varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDefaultCatalog().getSchemaForIdentifier("TABLE_TEST").getTableForIdentifier("test");
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("Id"));
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("Name"));
        this.dropTable("TABLE_TEST", "test");
        this.executeUpdate("CREATE TABLE test (\"Id\" int, \"Name\" varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDefaultCatalog().getSchemaForIdentifier("TABLE_TEST").getTableForIdentifier("test");
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("\"Id\""));
        PostgreSQLTests.assertNotNull((Object)table.getColumnForIdentifier("\"Name\""));
        this.dropTable("TABLE_TEST", "test");
        this.dropSchema("TABLE_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testCrossSchemaReference() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("XREF_TEST2", "EMP");
        this.dropSchema("XREF_TEST2");
        this.dropTable("XREF_TEST1", "ORG");
        this.dropSchema("XREF_TEST1");
        this.executeUpdate("CREATE SCHEMA XREF_TEST1");
        this.executeUpdate("SET search_path TO XREF_TEST1");
        this.executeUpdate("CREATE TABLE ORG (ID integer PRIMARY KEY, NAME varchar(20))");
        this.executeUpdate("CREATE SCHEMA XREF_TEST2");
        this.executeUpdate("SET search_path TO XREF_TEST2");
        this.executeUpdate("CREATE TABLE EMP (ID integer PRIMARY KEY, NAME varchar(20), ORG_ID integer REFERENCES XREF_TEST1.ORG(ID))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema1 = this.getDefaultCatalog().getSchemaNamed("xref_test1");
        PostgreSQLTests.assertNotNull((Object)schema1);
        Table orgTable = schema1.getTableNamed("org");
        PostgreSQLTests.assertNotNull((Object)orgTable);
        Schema schema2 = this.getDefaultCatalog().getSchemaNamed("xref_test2");
        PostgreSQLTests.assertNotNull((Object)schema2);
        Table empTable = schema2.getTableNamed("emp");
        PostgreSQLTests.assertNotNull((Object)empTable);
        PostgreSQLTests.assertEquals((int)1, (int)empTable.getForeignKeysSize());
        ForeignKey fk = (ForeignKey)empTable.getForeignKeys().iterator().next();
        Table refTable = fk.getReferencedTable();
        PostgreSQLTests.assertNotNull((Object)refTable);
        PostgreSQLTests.assertEquals((String)"org", (String)refTable.getName());
        PostgreSQLTests.assertEquals((int)1, (int)fk.getColumnPairsSize());
        ForeignKey.ColumnPair cp = (ForeignKey.ColumnPair)fk.getColumnPairs().iterator().next();
        Column baseColumn = cp.getBaseColumn();
        PostgreSQLTests.assertEquals((String)"org_id", (String)baseColumn.getName());
        Column refColumn = cp.getReferencedColumn();
        PostgreSQLTests.assertEquals((String)"id", (String)refColumn.getName());
        this.dropTable("XREF_TEST2", "EMP");
        this.dropSchema("XREF_TEST2");
        this.dropTable("XREF_TEST1", "ORG");
        this.dropSchema("XREF_TEST1");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private void dropTable(String schemaName, String tableName) throws Exception {
        Schema schema = this.getDefaultCatalog().getSchemaForIdentifier(schemaName);
        if (schema != null && schema.getTableForIdentifier(tableName) != null) {
            this.executeUpdate("DROP TABLE " + schemaName + '.' + tableName);
        }
    }

    private void dropSchema(String name) throws Exception {
        if (this.getDefaultCatalog().getSchemaForIdentifier(name) != null) {
            this.executeUpdate("DROP SCHEMA " + name + " CASCADE");
        }
    }

    public void testSequence() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropSequence("SEQUENCE_TEST", "FOO");
        this.dropSchema("SEQUENCE_TEST");
        this.executeUpdate("CREATE SCHEMA SEQUENCE_TEST");
        this.executeUpdate("SET search_path TO SEQUENCE_TEST");
        this.executeUpdate(this.buildBarDDL());
        this.executeUpdate("CREATE SEQUENCE FOO START 1");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDefaultCatalog().getSchemaForIdentifier("SEQUENCE_TEST");
        Sequence sequence = schema.getSequenceForIdentifier("FOO");
        PostgreSQLTests.assertNotNull((Object)sequence);
        PostgreSQLTests.assertEquals((String)"foo", (String)sequence.getName());
        this.dropSequence("SEQUENCE_TEST", "FOO");
        this.dropSchema("SEQUENCE_TEST");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private void dropSequence(String schemaName, String sequenceName) throws Exception {
        Schema schema = this.getDefaultCatalog().getSchemaNamed(schemaName);
        if (schema != null && schema.getSequenceNamed(sequenceName) != null) {
            this.executeUpdate("DROP SEQUENCE " + schemaName + '.' + sequenceName);
        }
    }
}

