/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.WebParam;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class WebParamModeHolderTypeRuleTest
extends AbstractAnnotationValidationTest {
    @Override
    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair modeValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)WebParam.class.getCanonicalName(), (String)"mode", (Object)WebParam.Mode.OUT);
        memberValuePairs.add(modeValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebParam.class.getSimpleName(), memberValuePairs);
    }

    @Override
    public String getPackageName() {
        return "com.example";
    }

    @Override
    public String getClassName() {
        return "MyClass.java";
    }

    @Override
    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"MyClass\")\n");
        classContents.append("public class MyClass {\n\n\tpublic String myMethod(String param) {");
        classContents.append("\n\t\treturn \"txt\";\n\t}\n}");
        return classContents.toString();
    }

    public void testWebParamModeHolderTypeRule() {
        try {
            WebParamModeHolderTypeRuleTest.assertNotNull((Object)this.annotation);
            WebParamModeHolderTypeRuleTest.assertEquals((String)WebParam.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("myMethod", new String[]{"QString;"});
            WebParamModeHolderTypeRuleTest.assertNotNull((Object)method);
            ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)method, (String)"param");
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)localVariable, (String)WebParam.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)localVariable, (Annotation)this.annotation));
            WebParamModeHolderTypeRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            WebParamModeHolderTypeRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)localVariable, (Annotation)this.annotation));
            WebParamModeHolderTypeRuleTest.assertTrue((boolean)this.source.getImport(WebParam.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            WebParamModeHolderTypeRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            WebParamModeHolderTypeRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            WebParamModeHolderTypeRuleTest.assertEquals((Object)JAXWSCoreMessages.WEBPARAM_MODE_OUT_INOUT_HOLDER_TYPE, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            WebParamModeHolderTypeRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            WebParamModeHolderTypeRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            WebParamModeHolderTypeRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

