/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseFigureDecorator;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IBaseFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class IconFigure
extends Label
implements IBaseFigure {
    private static int defaultTextPlacement = 4;
    static Font defaultFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
    static Color defaultForegroundColor = ColorConstants.black;
    private ArrayList decorators;
    private IconLabel iconLabel = null;

    public IconFigure(String name, Image icon) {
        super(name, icon);
        this.setTextPlacement(defaultTextPlacement);
        this.setOpaque(false);
        this.setIcon(icon);
        this.setIconTextGap(0);
        this.setForegroundColor(defaultForegroundColor);
        this.setBackgroundColor(ColorConstants.titleGradient);
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.iconLabel = new IconLabel(this, name);
        this.iconLabel.setFont(this.getFont());
    }

    public Label getLabel() {
        return this.iconLabel;
    }

    public List getDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList();
        }
        return this.decorators;
    }

    public Font getFont() {
        if (defaultFont == null) {
            defaultFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        }
        if (this.getLocalFont() == null) {
            this.setFont(defaultFont);
        }
        return this.getLocalFont();
    }

    public void setFont(Font f) {
        Font localFont = this.getLocalFont();
        if (localFont != f) {
            this.iconLabel.setFont(f);
        }
        super.setFont(f);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.iconLabel.setVisible(visible);
    }

    public void setText(String text) {
        super.setText(text);
        if (this.iconLabel != null && this.iconLabel.isVisible()) {
            this.iconLabel.setText(text);
            this.iconLabel.setFont(this.getFont());
        }
    }

    public void setToolTipText(String text) {
        Label toolTipLabel = null;
        if (text != null && text.length() > 0) {
            toolTipLabel = new Label(text);
            toolTipLabel.setBorder((Border)new MarginBorder(3));
        }
        super.setToolTip(toolTipLabel);
    }

    public String getToolTipText() {
        if (this.getToolTip() != null) {
            return ((Label)this.getToolTip()).getText();
        }
        return null;
    }

    public void setHighlight(boolean flag) {
        if (flag) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    protected Dimension getSubStringTextSize() {
        return this.getTextSize();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            super.getPreferredSize(-1, -1);
            this.prefSize.width = this.getIconBounds().getSize().width;
            Dimension minSize_ = this.getMinimumSize(wHint, hHint);
            if (this.prefSize.width < minSize_.width) {
                this.prefSize.width = minSize_.width;
            }
            if (this.prefSize.height < minSize_.height) {
                this.prefSize.height = minSize_.height;
            }
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize(int w, int h) {
        return new Dimension(8, 8);
    }

    public void addDecorator(BaseFigureDecorator decorator) {
        this.removeDecorator(decorator.getPosition());
        this.getDecorators().add(decorator);
        this.add((IFigure)decorator);
        this.invalidate();
    }

    public void removeDecorator() {
        this.removeDecorator(BaseFigureDecorator.DEFAULT_DECORATOR_POSITION);
    }

    public void removeDecorator(int position) {
        Iterator it = this.getDecorators().iterator();
        while (it.hasNext()) {
            BaseFigureDecorator d = (BaseFigureDecorator)((Object)it.next());
            if (d.getPosition() != position) continue;
            it.remove();
            this.remove((IFigure)d);
            this.invalidate();
            break;
        }
    }

    public void setTextPlacement(int where) {
        super.setTextPlacement(where);
        this.layout();
        this.invalidate();
    }

    public void invalidate() {
        super.invalidate();
    }

    private void placeDecorators() {
        Point o = this.getLocation();
        Point p = this.getIconBounds().getLocation();
        Dimension size = this.getIconBounds().getSize();
        Iterator it = this.getDecorators().iterator();
        while (it.hasNext()) {
            int x = p.x - o.x;
            int y = p.y - o.y;
            BaseFigureDecorator decorator = (BaseFigureDecorator)((Object)it.next());
            Dimension decoratorSize = decorator.getPreferredSize();
            switch (decorator.getPosition()) {
                case 18: {
                    int fudge = 4;
                    y += size.height / 2 - decoratorSize.height / 2 + fudge;
                    x += size.width / 2 - decoratorSize.width / 2;
                    break;
                }
                case 1: {
                    x += size.width / 2 - decoratorSize.width / 2;
                    break;
                }
                case 17: {
                    x += size.width - decoratorSize.width;
                    break;
                }
                case 16: {
                    x += size.width - decoratorSize.width;
                    y += size.height / 2 - decoratorSize.height / 2;
                    break;
                }
                case 20: {
                    x += size.width - decoratorSize.width;
                    y += size.height - decoratorSize.height;
                    break;
                }
                case 4: {
                    x += size.width / 2 - decoratorSize.width / 2;
                    y += size.height - decoratorSize.height;
                    break;
                }
                case 12: {
                    y += size.height - decoratorSize.height;
                    break;
                }
                case 8: {
                    y += size.height / 2 - decoratorSize.height / 2;
                    break;
                }
            }
            this.getLayoutManager().setConstraint((IFigure)decorator, (Object)new Rectangle(x, y, -1, -1));
        }
        this.layout();
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        this.placeDecorators();
        Rectangle bounds_ = this.getBounds();
        graphics.translate(bounds_.x, bounds_.y);
        if (this.getIcon() != null) {
            graphics.drawImage(this.getIcon(), this.getIconLocation());
        }
        if (this.iconLabel == null || !this.iconLabel.isVisible()) {
            if (!this.isEnabled()) {
                graphics.translate(1, 1);
                graphics.setForegroundColor(ColorConstants.buttonLightest);
                graphics.drawText(this.getSubStringText(), this.getTextLocation());
                graphics.translate(-1, -1);
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
        }
        graphics.translate(-bounds_.x, -bounds_.y);
    }

    private class IconLabel
    extends Label {
        private LabelLocator locator;
        private IconFigure host;

        public IconLabel(IconFigure host, String text) {
            super(text);
            this.host = host;
            this.locator = new LabelLocator(this);
        }

        public IconFigure getHost() {
            return this.host;
        }

        public Dimension getPreferredSize(int wHint, int hHing) {
            return this.host.getTextBounds().getSize();
        }

        public void setText(String text) {
            super.setText(text);
            if (this.locator != null) {
                this.locator.setConstraints();
            }
        }

        public void invalidate() {
            if (this.locator != null) {
                this.locator.setConstraints();
            }
            super.invalidate();
        }
    }

    private class LabelLocator
    implements AncestorListener {
        IconLabel label;

        public LabelLocator(IconLabel label) {
            this.label = label;
            label.getHost().addAncestorListener(this);
        }

        private Layer getParentLayer() {
            IconFigure fig = this.label.getHost();
            while (fig != null) {
                if (fig instanceof Layer) {
                    return (Layer)fig;
                }
                fig = fig.getParent();
            }
            return null;
        }

        public void ancestorAdded(IFigure ancestor) {
            Layer layer = this.getParentLayer();
            if (layer != null && !layer.getChildren().contains((Object)this.label)) {
                layer.add((IFigure)this.label);
                this.setConstraints();
            }
        }

        public void ancestorMoved(IFigure ancestor) {
            this.setConstraints();
        }

        public void ancestorRemoved(IFigure ancestor) {
            if (this.label.getParent() != null && this.label.getParent().getChildren().contains((Object)this.label)) {
                this.label.getParent().remove((IFigure)this.label);
            }
        }

        public void setConstraints() {
            Layer layer = this.getParentLayer();
            if (layer != null && layer.getLayoutManager() != null && layer.getChildren().contains((Object)this.label)) {
                Rectangle r = IconFigure.this.getParent().getBounds().getCopy();
                r.translate(IconFigure.this.getBounds().getLocation());
                r.translate(IconFigure.this.getTextLocation());
                r.width = -1;
                r.height = -1;
                Rectangle oldr = (Rectangle)layer.getLayoutManager().getConstraint((IFigure)this.label);
                if (oldr == null || oldr.x != r.x || oldr.y != r.y) {
                    layer.setConstraint((IFigure)this.label, (Object)r);
                }
            }
        }
    }
}

