/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.CreateItemCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editpolicies.DropEditPolicy;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationRequest;
import org.eclipse.jst.pagedesigner.tools.ExposeHelper;
import org.eclipse.jst.pagedesigner.validation.caret.DnDPositionValidator;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.IDropLocationStrategy;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;

public class ItemCreationEditPolicy
extends DropEditPolicy {
    public Command getCommand(Request request) {
        if (request instanceof ItemCreationRequest) {
            ItemCreationRequest r = (ItemCreationRequest)request;
            DesignPosition position = this.findPosition((ItemCreationRequest)request);
            if (position == null) {
                return null;
            }
            IDOMPosition domposition = DOMPositionHelper.toDOMPosition(position);
            if (domposition == null) {
                return null;
            }
            return new CreateItemCommand(PDPlugin.getResourceString("ItemCreationEditPolicy.CommandLabel.CreateItem"), this.getViewer((EditPart)this.getHost()).getModel(), domposition, r.getTagCreationProvider());
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof ItemCreationRequest) {
            DesignPosition position = this.findPosition((ItemCreationRequest)request);
            if (position == null) {
                return null;
            }
            EditPart container = position.getContainerPart();
            return container;
        }
        return null;
    }

    protected IHTMLGraphicalViewer getViewer(EditPart host) {
        return (IHTMLGraphicalViewer)((GraphicalEditPart)host).getViewer();
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (request instanceof DropRequest && request.getType() == "Item Creation") {
            super.showTargetFeedback(request);
            if (this.getHost() instanceof GraphicalEditPart) {
                ExposeHelper exposeHelper = new ExposeHelper(this.getViewer((EditPart)this.getHost()));
                exposeHelper.adjustVertical(((DropRequest)request).getLocation());
            }
        }
    }

    @Override
    protected DesignPosition findPosition(DropRequest request) {
        IPositionMediator mediator = this.getDropChildValidator(request);
        if (mediator == null) {
            return null;
        }
        IDropLocationStrategy dropStrategy = this.createDropLocationStrategy(request);
        DesignPosition position = dropStrategy.calculateDesignPosition((EditPart)this.getHost(), request.getLocation(), mediator);
        if (position != null && !mediator.isValidPosition(position)) {
            return null;
        }
        return position;
    }

    @Override
    protected final IPositionMediator createDefaultDropChildValidator(DropActionData.DropData data) {
        return new DnDPositionValidator(new DropActionData(1, data));
    }
}

