/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.plugin;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EjbPlugin
extends WTPPlugin
implements ResourceLocator {
    private static EjbPlugin inst;
    protected final IPath iconsFolder = new Path(Platform.getBundle((String)"org.eclipse.jst.j2ee.ejb").getEntry("icons").getPath());
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee.ejb";
    private static IPath location;

    public EjbPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static EjbPlugin getDefault() {
        return inst;
    }

    public URL getBaseURL() {
        return this.getBundle().getEntry("/");
    }

    public Object getImage(String key) {
        return J2EEPlugin.getImageURL((String)key, (Bundle)this.getBundle());
    }

    public static IPath getInstallLocation() {
        if (location == null) {
            URL url = EjbPlugin.getInstallURL();
            try {
                String installLocation = ((PlatformURLConnection)url.openConnection()).getURLAsLocal().getFile();
                location = new Path(installLocation);
            }
            catch (IOException e) {
                EjbPlugin.logError(e);
            }
        }
        return location;
    }

    public static URL getInstallURL() {
        return EjbPlugin.getDefault().getBundle().getEntry("/");
    }

    public static EjbPlugin getPlugin() {
        return inst;
    }

    public static IPath getPluginLocation(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            try {
                IPath installPath = new Path(bundle.getEntry("/").toExternalForm()).removeTrailingSeparator();
                String installStr = Platform.asLocalURL((URL)new URL(installPath.toString())).getFile();
                return new Path(installStr);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static IStatus createErrorStatus(String aMessage, Throwable exception) {
        return EjbPlugin.createErrorStatus(0, aMessage, exception);
    }

    public static IStatus newOperationFailedStatus(String aMessage, Throwable exception) {
        return EjbPlugin.createStatus(4, 76, aMessage, exception);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return EjbPlugin.createStatus(severity, message, null);
    }

    public String getString(String key) {
        return Platform.getResourceString((Bundle)this.getBundle(), (String)key);
    }

    public String getString(String key, Object[] substitutions) {
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return EjbPlugin.createStatus(4, aCode, aMessage != null ? aMessage : exception.toString(), exception);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public String getString(String key, boolean translate) {
        return this.getString(key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return this.getString(key, substitutions);
    }

    public static void logError(int aCode, String aMessage, Throwable anException) {
        EjbPlugin.getDefault().getLog().log(EjbPlugin.createErrorStatus(aCode, aMessage, anException));
    }

    public static void log(int severity, int aCode, String aMessage, Throwable exception) {
        EjbPlugin.log(EjbPlugin.createStatus(severity, aCode, aMessage, exception));
    }

    public static void log(IStatus aStatus) {
        EjbPlugin.getDefault().getLog().log(aStatus);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(EjbPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

