/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import com.sun.el.ExpressionFactoryImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import javax.el.ELContext;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspContext;
import org.apache.commons.logging.Log;
import org.apache.jasper.JspCompilationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.jst.server.preview.adapter.internal.Trace;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewServerBehaviour;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;

public class PreviewLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String[] REQUIRED_BUNDLE_IDS_8 = new String[]{PreviewLaunchConfigurationDelegate.getBundleForClass(ServletResponse.class), PreviewLaunchConfigurationDelegate.getBundleForClass(JspContext.class), PreviewLaunchConfigurationDelegate.getBundleForClass(JspCompilationContext.class), PreviewLaunchConfigurationDelegate.getBundleForClass(ELContext.class), PreviewLaunchConfigurationDelegate.getBundleForClass(ExpressionFactoryImpl.class), PreviewLaunchConfigurationDelegate.getBundleForClass(LoggerFactory.class), PreviewLaunchConfigurationDelegate.getBundleForClass(Resource.class), PreviewLaunchConfigurationDelegate.getBundleForClass(Log.class), "org.eclipse.jetty.ee", "org.eclipse.jetty.http", "org.eclipse.jetty.io", "org.eclipse.jetty.jndi", "org.eclipse.jetty.plus", "org.eclipse.jetty.security", "org.eclipse.jetty.server", "org.eclipse.jetty.servlet-api", "org.eclipse.jetty.session", "org.eclipse.jetty.util", "org.eclipse.jetty.xml", "org.objectweb.asm", "org.objectweb.asm.commons", "org.objectweb.asm.util", "org.apache.aries.spifly.dynamic.bundle", "org.eclipse.jetty.ee8.annotations", "org.eclipse.jetty.ee8.jndi", "org.eclipse.jetty.ee8.plus", "org.eclipse.jetty.ee8.security", "org.eclipse.jetty.ee8.server", "org.eclipse.jetty.ee8.servlet", "org.eclipse.jetty.ee8.servlets", "org.eclipse.jetty.ee8.webapp", "jakarta.enterprise.cdi-api", "org.eclipse.wst.server.preview"};
    private static final int CLASSPATH_BIN_INDEX_PREVIEW_SERVER = REQUIRED_BUNDLE_IDS_8.length - 1;
    private static final String MAIN_CLASS = "org.eclipse.wst.server.preview.internal.PreviewStarter";

    private static String getBundleForClass(Class<?> cls) {
        Bundle bundle = FrameworkUtil.getBundle(cls);
        return bundle.getSymbolicName() + ":" + String.valueOf(bundle.getVersion());
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall vm;
        IVMRunner runner;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace((byte)3, "Launch configuration could not find server");
            return;
        }
        if (server.shouldPublish() && ServerCore.isAutoPublishing()) {
            server.publish(1, monitor);
        }
        PreviewServerBehaviour previewServer = (PreviewServerBehaviour)((Object)server.loadAdapter(PreviewServerBehaviour.class, null));
        int size = REQUIRED_BUNDLE_IDS_8.length;
        String[] jars = new String[size];
        int i = 0;
        while (i < size) {
            Bundle[] bundles;
            String[] bundleInfo = REQUIRED_BUNDLE_IDS_8[i].split(":");
            String version = null;
            if (bundleInfo.length > 1) {
                version = bundleInfo[1];
            }
            if ((bundles = Platform.getBundles((String)bundleInfo[0], (String)version)) == null || bundles.length < 1) {
                Trace.trace((byte)2, "Missing required bundle " + REQUIRED_BUNDLE_IDS_8[i]);
            }
            Arrays.sort(bundles, (bundle1, bundle2) -> bundle1.getVersion().compareTo(bundle2.getVersion()));
            Bundle b = bundles[0];
            IPath path = null;
            if (b != null) {
                path = PreviewRuntime.getJarredPluginPath(b);
            }
            if (path == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.preview.adapter", "Could not find required bundle " + REQUIRED_BUNDLE_IDS_8[i]));
            }
            jars[i] = path.toOSString();
            ++i;
        }
        Trace.trace((byte)3, jars[CLASSPATH_BIN_INDEX_PREVIEW_SERVER] + File.separator + "bin");
        if (new File(jars[CLASSPATH_BIN_INDEX_PREVIEW_SERVER] + File.separator + "bin").exists()) {
            jars[PreviewLaunchConfigurationDelegate.CLASSPATH_BIN_INDEX_PREVIEW_SERVER] = jars[CLASSPATH_BIN_INDEX_PREVIEW_SERVER] + File.separator + "bin";
        }
        if ((runner = (vm = this.verifyVMInstall(configuration)).getVMRunner(mode)) == null) {
            runner = vm.getVMRunner("run");
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = "\"" + previewServer.getTempDirectory().append("preview.xml").toOSString() + "\"";
        String vmArgs = this.getVMArguments(configuration);
        String[] envp = this.getEnvironment(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath2 = this.getClasspath(configuration);
        String[] classpath = new String[classpath2.length + REQUIRED_BUNDLE_IDS_8.length];
        System.arraycopy(jars, 0, classpath, 0, REQUIRED_BUNDLE_IDS_8.length);
        System.arraycopy(classpath2, 0, classpath, REQUIRED_BUNDLE_IDS_8.length, classpath2.length);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(MAIN_CLASS, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        previewServer.setupLaunch(launch, mode, monitor);
        if ("profile".equals(mode)) {
            ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
        }
        try {
            runner.run(runConfig, launch, monitor);
            previewServer.addProcessListener(launch.getProcesses()[0]);
        }
        catch (Exception exception) {}
    }
}

