/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModule2;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class Module
implements IModule2 {
    protected String id;
    protected String name;
    protected ModuleFactory factory;
    protected ModuleType moduleType;
    protected IProject project;
    protected ModuleDelegate delegate;
    protected String id2;
    protected Map<String, String> properties;

    public Module(ModuleFactory factory, String id, String name, String type, String version, IProject project) {
        this(factory, id, name, type, version, project, null);
    }

    public Module(ModuleFactory factory, String id, String name, String type, String version, IProject project, Map<String, String> properties) {
        this.factory = factory;
        this.project = project;
        this.moduleType = ModuleType.getModuleType(type, version);
        this.id = id;
        this.name = name;
        this.id2 = factory != null ? String.valueOf(factory.getId()) + ":" : ":";
        this.id2 = String.valueOf(this.id2) + id;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.id2;
    }

    public String getInternalId() {
        return this.id;
    }

    @Override
    public IModuleType getModuleType() {
        return this.moduleType;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModuleFactory getModuleFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate != null) {
            return this.delegate;
        }
        Module module = this;
        synchronized (module) {
            block8: {
                if (this.delegate == null) {
                    try {
                        long time = System.currentTimeMillis();
                        this.delegate = this.factory.getDelegate(monitor).getModuleDelegate(this);
                        this.delegate.initialize(this);
                        if (Trace.PERFORMANCE) {
                            Trace.trace("/performance", "Module.getDelegate(): <" + (System.currentTimeMillis() - time) + " " + this.factory.getId());
                        }
                    }
                    catch (Throwable t) {
                        if (!Trace.WARNING) break block8;
                        Trace.trace("/warning", "Could not create delegate " + this.toString(), t);
                    }
                }
            }
        }
        return this.delegate;
    }

    public IModule[] getChildModules(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).getChildModules();
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate getChildModules() " + this.toString(), e);
            }
            return null;
        }
    }

    public IStatus validate(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).validate();
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate validate() " + this.toString(), e);
            }
            return null;
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IModule)) {
            return false;
        }
        IModule m = (IModule)obj;
        if (!this.id2.equals(m.getId())) {
            return false;
        }
        return this.project == null || m.getProject() == null || this.project.equals((Object)m.getProject());
    }

    public int hashCode() {
        int result = this.id2.hashCode() + 17;
        if (this.project != null) {
            result += this.project.hashCode() * 37;
        }
        return result;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    public String toString() {
        return "Module[" + this.name + "," + this.id2 + "]";
    }

    @Override
    public String getProperty(String key) {
        return this.properties == null || key == null ? null : this.properties.get(key);
    }
}

