/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.command.NullStatusMonitor;
import org.eclipse.jst.ws.internal.command.StatusMonitor;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.codegen.Visitor;
import org.eclipse.jst.ws.internal.consumption.codegen.VisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofAttributeVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofFieldVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofMethodVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofAttributeVisitor;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofFieldVisitor;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofMethodVisitor;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanModelElementsFactory;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class JavaMofBeanVisitorAction
implements VisitorAction {
    protected IEnvironment env_;
    protected Visitor fVisitor;
    protected String clientProject;
    protected StatusMonitor monitor_;
    protected Model fModel;
    protected Element fParentElement;
    protected Vector fBeansCreated;
    private BooleanSelection[] fMethodsSelected;
    protected boolean fReturnParam = false;

    public JavaMofBeanVisitorAction(String clientProject, BooleanSelection[] methods, IEnvironment env) {
        this.clientProject = clientProject;
        this.fMethodsSelected = methods;
        this.env_ = env;
    }

    public JavaMofBeanVisitorAction(Model model, String clientProject, IEnvironment env) {
        this.clientProject = clientProject;
        this.fModel = model;
        this.env_ = env;
    }

    public JavaMofBeanVisitorAction(Element parentElement, String clientProject, IEnvironment env) {
        this.fParentElement = parentElement;
        this.clientProject = clientProject;
        this.env_ = env;
    }

    @Override
    public IStatus visit(Object javaclass) {
        Choice OKChoice = new Choice('O', ConsumptionMessages.LABEL_OK, ConsumptionMessages.DESCRIPTION_OK);
        Choice CancelChoice = new Choice('C', ConsumptionMessages.LABEL_CANCEL, ConsumptionMessages.DESCRIPTION_CANCEL);
        IStatus status = Status.OK_STATUS;
        JavaClass javaClass = (JavaClass)javaclass;
        BeanElement beanElement = (BeanElement)BeanModelElementsFactory.getBeanModelElement(javaClass, this.fParentElement, this.fModel);
        if (beanElement.isOwnerParameter()) {
            this.resetBeansCreated();
        }
        this.fModel = beanElement.getModel();
        if (beanElement != this.fModel.getRootElement()) {
            Choice result;
            Choice result2;
            Enumeration e = this.getBeansCreated().elements();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.equals(javaClass.getName())) continue;
                status = StatusUtils.warningStatus((String)ConsumptionMessages.MSG_ERROR_JTS_CYCLIC_BEAN);
                return status;
            }
            JavaMofAttributeVisitorAction attributeVisitorAction = new JavaMofAttributeVisitorAction((Element)beanElement, this.clientProject, this.env_);
            Vector childVector = (Vector)this.getBeansCreated().clone();
            childVector.addElement(javaClass.getName());
            attributeVisitorAction.setBeansCreated(childVector);
            attributeVisitorAction.setReturnParam(this.getReturnParam());
            JavaMofAttributeVisitor attributeVisitor = new JavaMofAttributeVisitor();
            attributeVisitor.setReturnParameter(this.getReturnParam());
            attributeVisitor.setProject(this.getProject());
            attributeVisitor.setEnvironment(this.env_);
            status = attributeVisitor.run(javaClass, attributeVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result2 = this.env_.getStatusHandler().report(status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SAMPLE_CREATION_CANCELED);
            }
            JavaMofFieldVisitorAction fieldVisitorAction = new JavaMofFieldVisitorAction((Element)beanElement, this.clientProject, this.env_);
            Vector childVector2 = (Vector)this.getBeansCreated().clone();
            childVector2.addElement(javaClass.getName());
            fieldVisitorAction.setBeansCreated(childVector2);
            fieldVisitorAction.setReturnParam(this.getReturnParam());
            JavaMofFieldVisitor fieldVisitor = new JavaMofFieldVisitor();
            fieldVisitor.setProject(this.getProject());
            status = fieldVisitor.run(javaClass, fieldVisitorAction);
            severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = this.env_.getStatusHandler().report(status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SAMPLE_CREATION_CANCELED);
            }
        }
        if (beanElement == this.fModel.getRootElement()) {
            Choice result;
            if (!this.proxyCheck(javaClass, status)) {
                return status;
            }
            JavaMofMethodVisitorAction methodVisitorAction = new JavaMofMethodVisitorAction((Element)beanElement, this.clientProject, this.env_);
            JavaMofMethodVisitor methodVisitor = new JavaMofMethodVisitor();
            methodVisitor.setMethodSelection(this.fMethodsSelected);
            status = methodVisitor.run(javaClass, methodVisitorAction);
            int severity = status.getSeverity();
            if (severity == 4) {
                return status;
            }
            if (severity == 2 && (result = this.env_.getStatusHandler().report(status, new Choice[]{OKChoice, CancelChoice})).getLabel().equals(CancelChoice.getLabel())) {
                return StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SAMPLE_CREATION_CANCELED);
            }
            if (!methodVisitorAction.wereMethodsProcessed()) {
                status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_JTS_NO_PROXY_METHODS_PROCESSED);
                return status;
            }
            if (methodVisitorAction.wereMethodsOmitted()) {
                status = StatusUtils.warningStatus((String)ConsumptionMessages.MSG_WARN_JTS_PROXY_METHODS_OMITTED);
                return status;
            }
        }
        return status;
    }

    @Override
    public void initialize(String resident) {
    }

    public Model getModel() {
        return this.fModel;
    }

    /*
     * Unable to fully structure code
     */
    public boolean proxyCheck(JavaClass javaClass, IStatus status) {
        m = javaClass.getPublicMethods().iterator();
        if (m.hasNext()) ** GOTO lbl8
        status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_JTS_PROXY_HAS_NO_METHODS);
        return false;
lbl-1000:
        // 1 sources

        {
            method = (Method)m.next();
            if (!javaClass.getName().equals(method.getName()) || (javaParameter = method.listParametersWithoutReturn()).length != 0) continue;
            return true;
lbl8:
            // 2 sources

            ** while (m.hasNext())
        }
lbl9:
        // 1 sources

        return false;
    }

    public void setStatusMonitor(StatusMonitor monitor) {
        this.monitor_ = monitor;
    }

    public StatusMonitor getStatusMonitor() {
        if (this.monitor_ == null) {
            this.monitor_ = new NullStatusMonitor();
        }
        return this.monitor_;
    }

    public void resetBeansCreated() {
        this.fBeansCreated = new Vector();
    }

    public void setEnvironment(IEnvironment env) {
        this.env_ = env;
    }

    public Vector getBeansCreated() {
        if (this.fBeansCreated == null) {
            this.fBeansCreated = new Vector();
        }
        return this.fBeansCreated;
    }

    public void setBeansCreated(Vector beansCreated) {
        this.fBeansCreated = beansCreated;
    }

    public boolean getReturnParam() {
        return this.fReturnParam;
    }

    public void setReturnParam(boolean returnparam) {
        this.fReturnParam = returnparam;
    }

    public String getProject() {
        return this.clientProject;
    }

    public void setProject(String clientProject) {
        this.clientProject = clientProject;
    }

    @Override
    public void setVisitor(Visitor visitor) {
        this.fVisitor = visitor;
    }

    public void setParentElement(Element element) {
        this.fParentElement = element;
    }
}

