/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class BridgeMethodResolver {
    private BridgeMethodResolver() {
    }

    public static Method findBridgedMethod(Method bridgeMethod) {
        assert (bridgeMethod != null) : "Method must not be null";
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        Method[] methods = BridgeMethodResolver.getAllDeclaredMethods(bridgeMethod.getDeclaringClass());
        ArrayList<Method> candidateMethods = new ArrayList<Method>(methods.length);
        for (Method candidateMethod : methods) {
            if (!BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod)) continue;
            candidateMethods.add(candidateMethod);
        }
        Method result = candidateMethods.size() == 1 ? (Method)candidateMethods.get(0) : BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod);
        if (result == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + bridgeMethod + "'");
        }
        return result;
    }

    private static Method searchCandidates(List<Method> candidateMethods, Method bridgeMethod) {
        Map<TypeVariable<?>, Type> typeParameterMap = BridgeMethodResolver.createTypeVariableMap(bridgeMethod.getDeclaringClass());
        for (Method candidateMethod : candidateMethods) {
            if (!BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, typeParameterMap)) continue;
            return candidateMethod;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && !candidateMethod.equals(bridgeMethod) && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterTypes().length == bridgeMethod.getParameterTypes().length;
    }

    private static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Map<TypeVariable<?>, Type> typeVariableMap) {
        if (BridgeMethodResolver.isResolvedTypeMatch(candidateMethod, bridgeMethod, typeVariableMap)) {
            return true;
        }
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null && BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, typeVariableMap);
    }

    private static Method findGenericDeclaration(Method bridgeMethod) {
        Class<?>[] interfaces;
        Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass();
        while (!Object.class.equals(superclass)) {
            Method method = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (method != null && !method.isBridge()) {
                return method;
            }
            superclass = superclass.getSuperclass();
        }
        for (Class<?> anInterface : interfaces = BridgeMethodResolver.getAllInterfacesForClass(bridgeMethod.getDeclaringClass())) {
            Method method = BridgeMethodResolver.searchForMatch(anInterface, bridgeMethod);
            if (method == null || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Map<TypeVariable<?>, Type> typeVariableMap) {
        Class<?>[] candidateParameters;
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        if (genericParameters.length != (candidateParameters = candidateMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < genericParameters.length; ++i) {
            Type rawType;
            Type genericParameter = genericParameters[i];
            Class<?> candidateParameter = candidateParameters[i];
            if (candidateParameter.isArray() && (rawType = BridgeMethodResolver.getRawType(genericParameter, typeVariableMap)) instanceof GenericArrayType) {
                if (candidateParameter.getComponentType().equals(BridgeMethodResolver.getRawType(((GenericArrayType)rawType).getGenericComponentType(), typeVariableMap))) break;
                return false;
            }
            if (candidateParameter.equals(BridgeMethodResolver.getRawType(genericParameter, typeVariableMap))) continue;
            return false;
        }
        return true;
    }

    private static Type getRawType(Type genericType, Map<TypeVariable<?>, Type> typeVariableMap) {
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            Type result = typeVariableMap.get(tv);
            return result != null ? result : Object.class;
        }
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getRawType();
        }
        return genericType;
    }

    private static Method searchForMatch(Class<?> type, Method bridgeMethod) {
        return BridgeMethodResolver.findMethod(type, bridgeMethod.getName(), bridgeMethod.getParameterTypes());
    }

    private static Map<TypeVariable<?>, Type> createTypeVariableMap(Class<?> cls) {
        ParameterizedType pt;
        HashMap typeVariableMap = new HashMap();
        BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(cls.getGenericInterfaces(), typeVariableMap);
        Type genericType = cls.getGenericSuperclass();
        Class<?> type = cls.getSuperclass();
        while (!Object.class.equals(type)) {
            if (genericType instanceof ParameterizedType) {
                pt = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
            }
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(type.getGenericInterfaces(), typeVariableMap);
            genericType = type.getGenericSuperclass();
            type = type.getSuperclass();
        }
        type = cls;
        while (type.isMemberClass()) {
            genericType = type.getGenericSuperclass();
            if (genericType instanceof ParameterizedType) {
                pt = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
            }
            type = type.getEnclosingClass();
        }
        return typeVariableMap;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] genericInterfaces, Map<TypeVariable<?>, Type> typeVariableMap) {
        for (Type genericInterface : genericInterfaces) {
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericInterface;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                if (!(pt.getRawType() instanceof Class)) continue;
                BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)pt.getRawType()).getGenericInterfaces(), typeVariableMap);
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)genericInterface).getGenericInterfaces(), typeVariableMap);
        }
    }

    private static void populateTypeMapFromParameterizedType(ParameterizedType type, Map<TypeVariable<?>, Type> typeVariableMap) {
        if (type.getRawType() instanceof Class) {
            Type[] actualTypeArguments = type.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type actualTypeArgument = actualTypeArguments[i];
                TypeVariable variable = typeVariables[i];
                if (actualTypeArgument instanceof Class) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (actualTypeArgument instanceof GenericArrayType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (actualTypeArgument instanceof ParameterizedType) {
                    typeVariableMap.put(variable, ((ParameterizedType)actualTypeArgument).getRawType());
                    continue;
                }
                if (!(actualTypeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)actualTypeArgument;
                Class<?> resolvedType = typeVariableMap.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = BridgeMethodResolver.extractClassForTypeVariable(typeVariableArgument);
                }
                if (resolvedType == null) continue;
                typeVariableMap.put(variable, resolvedType);
            }
        }
    }

    private static Class<?> extractClassForTypeVariable(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        Class<?> result = null;
        if (bounds.length > 0) {
            Type bound = bounds[0];
            if (bound instanceof ParameterizedType) {
                result = ((ParameterizedType)bound).getRawType();
            } else if (bound instanceof Class) {
                result = bound;
            } else if (bound instanceof TypeVariable) {
                result = BridgeMethodResolver.extractClassForTypeVariable((TypeVariable)bound);
            }
        }
        return result instanceof Class ? (Class)result : null;
    }

    private static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        assert (clazz != null) : "Class must not be null";
        if (clazz.isInterface()) {
            return new Class[]{clazz};
        }
        ArrayList interfaces = new ArrayList();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> ifc = clazz.getInterfaces()[i];
                if (interfaces.contains(ifc)) continue;
                interfaces.add(ifc);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces.toArray(new Class[0]);
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        assert (clazz != null) : "Class must not be null";
        assert (name != null) : "Method name must not be null";
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        LinkedList list = new LinkedList();
        do {
            Method[] methods = leafClass.getDeclaredMethods();
            Collections.addAll(list, methods);
        } while ((leafClass = leafClass.getSuperclass()) != null);
        return list.toArray(new Method[0]);
    }
}

