/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j;

import org.uddi4j.UDDIElement;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.response.Result;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UDDIException
extends Exception {
    static final String UDDI_TAG = "Fault";
    String faultCode = null;
    String faultString = null;
    String faultActor = null;
    String detail = null;
    Element detailElement = null;
    DispositionReport dispositionReport = null;

    public UDDIException() {
    }

    public UDDIException(Element el, boolean createDispositionReport) {
        if (UDDIException.isValidElement(el)) {
            Element tmp;
            NodeList nl = el.getElementsByTagName("faultcode");
            if (nl.getLength() == 0) {
                nl = el.getElementsByTagNameNS(UDDIElement.SOAPNS, "faultcode");
            }
            if (nl != null && nl.getLength() > 0) {
                tmp = (Element)nl.item(0);
                this.faultCode = this.getText(tmp);
            }
            if ((nl = el.getElementsByTagName("faultstring")).getLength() == 0) {
                nl = el.getElementsByTagNameNS(UDDIElement.SOAPNS, "faultstring");
            }
            if (nl != null && nl.getLength() > 0) {
                tmp = (Element)nl.item(0);
                this.faultString = this.getText(tmp);
            }
            if ((nl = el.getElementsByTagName("faultactor")).getLength() == 0) {
                nl = el.getElementsByTagNameNS(UDDIElement.SOAPNS, "faultactor");
            }
            if (nl != null && nl.getLength() > 0) {
                tmp = (Element)nl.item(0);
                this.faultActor = this.getText(tmp);
            }
            if ((nl = el.getElementsByTagName("detail")).getLength() == 0) {
                nl = el.getElementsByTagNameNS(UDDIElement.SOAPNS, "detail");
            }
            if (nl != null && nl.getLength() > 0) {
                this.detailElement = tmp = (Element)nl.item(0);
                if (createDispositionReport) {
                    try {
                        nl = el.getElementsByTagName(DispositionReport.UDDI_TAG);
                        if (nl != null && nl.getLength() > 0) {
                            tmp = (Element)nl.item(0);
                            this.dispositionReport = new DispositionReport(tmp);
                        }
                    }
                    catch (UDDIException uDDIException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static boolean isValidElement(Element el) {
        return el.getNamespaceURI().equals(UDDIElement.SOAPNS) && el.getLocalName().equals(UDDI_TAG);
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getDetail() {
        return this.detail;
    }

    public Element getDetailElement() {
        return this.detailElement;
    }

    public DispositionReport getDispositionReport() {
        return this.dispositionReport;
    }

    protected String getText(Node el) {
        NodeList nl = el.getChildNodes();
        String result = "";
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 3) {
                result = String.valueOf(result) + nl.item(i).getNodeValue();
            }
            ++i;
        }
        return result.trim();
    }

    @Override
    public String toString() {
        Result result;
        if (this.dispositionReport != null && this.dispositionReport.getResultVector() != null && this.dispositionReport.getResultVector().size() > 0 && (result = (Result)this.dispositionReport.getResultVector().elementAt(0)) != null) {
            return result.getErrInfo().getText();
        }
        return this.getFaultString();
    }
}

