/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.java;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JSDScopeUtil;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.text.java.JavaTextMessages;

public class CompletionProposalLabelProvider {
    private static final char[] C_ANY = new char[]{'A'};
    private CompletionContext fContext;

    public String createParameterList(CompletionProposal proposal) {
        int kind = proposal.getKind();
        switch (kind) {
            case 6: {
                return this.appendUnboundedParameterList(new StringBuffer(), proposal).toString();
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private StringBuffer appendUnboundedParameterList(StringBuffer buffer, CompletionProposal methodProposal) {
        char[] signature = methodProposal.getSignature();
        char[][] parameterNames = methodProposal.getParamaterNames();
        char[][] parameterTypes = methodProposal.getParameterTypeNames();
        if ((parameterTypes == null || parameterTypes.length == 0) && signature != null && signature.length > 0) {
            parameterTypes = Signature.getParameterTypes((char[])signature);
            int i = 0;
            while (i < parameterTypes.length) {
                parameterTypes[i] = this.createTypeDisplayName(parameterTypes[i]);
                ++i;
            }
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = this.convertToVararg(parameterTypes[index]);
        }
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    private char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    private char[] createTypeDisplayName(char[] typeSignature) throws IllegalArgumentException {
        char[] displayName = Signature.getSimpleName((char[])Signature.toCharArray((char[])typeSignature));
        boolean useShortGenerics = false;
        if (useShortGenerics) {
            int pos;
            StringBuffer buf = new StringBuffer();
            buf.append(displayName);
            do {
                if ((pos = buf.indexOf("? extends ")) >= 0) {
                    buf.replace(pos, pos + 10, "+");
                    continue;
                }
                pos = buf.indexOf("? super ");
                if (pos < 0) continue;
                buf.replace(pos, pos + 8, "-");
            } while (pos >= 0);
            return buf.toString().toCharArray();
        }
        return displayName;
    }

    private final StringBuffer appendParameterSignature(StringBuffer buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                if (parameterTypes != null && parameterTypes.length > i && parameterTypes[i] != null && parameterTypes[i].length > 0 && !Arrays.equals(Signature.ANY, parameterTypes[i]) && !Arrays.equals(C_ANY, parameterTypes[i])) {
                    Util.insertTypeLabel((char[])parameterTypes[i], (StringBuffer)buffer);
                    buffer.append(' ');
                }
                if (parameterNames[i] != null) {
                    buffer.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buffer;
    }

    String createMethodProposalLabel(CompletionProposal methodProposal) {
        String declaringType;
        char[] returnType;
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        if (!(methodProposal.isConstructor() || (returnType = methodProposal.getReturnType()) == null || returnType.length <= 0 || Arrays.equals(Signature.ANY, returnType) || Arrays.equals(Signature.VOID, returnType))) {
            nameBuffer.append(" : ");
            Util.insertTypeLabel((char[])returnType, (StringBuffer)nameBuffer);
        }
        if ((declaringType = this.extractDeclaringTypeFQN(methodProposal)) != null) {
            nameBuffer.append(" - ");
            if (CharOperation.equals((char[])declaringType.toCharArray(), (char[])IIndexConstants.GLOBAL_SYMBOL)) {
                declaringType = JavaTextMessages.Global;
            }
            Util.insertTypeLabel((String)declaringType, (StringBuffer)nameBuffer);
        }
        return nameBuffer.toString();
    }

    String createJavadocMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getCompletion());
        nameBuffer.append(" - ");
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(declaringType);
        return nameBuffer.toString();
    }

    String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(")  ");
        char[] returnType = this.createTypeDisplayName(Signature.getReturnType((char[])methodProposal.getSignature()));
        nameBuffer.append(returnType);
        nameBuffer.append(" - ");
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(Messages.format(JavaTextMessages.ResultCollector_overridingmethod, new String(declaringType)));
        return nameBuffer.toString();
    }

    private String extractDeclaringTypeFQN(CompletionProposal methodProposal) {
        String description;
        IJavaScriptProject project;
        JsGlobalScopeContainerInitializer init;
        String qualifedName = null;
        char[] compUnit = methodProposal.getDeclarationTypeName();
        if (compUnit != null && (init = JSDScopeUtil.findLibraryInitializer((IPath)new Path(new String(compUnit)), (IJavaScriptProject)(project = methodProposal.getJavaProject()))) != null && (description = init.getDescription((IPath)new Path(new String(compUnit)), project)) != null) {
            return "[" + description + "]";
        }
        if (methodProposal.getDeclarationTypeName() != null) {
            qualifedName = new String(methodProposal.getDeclarationTypeName());
        }
        return qualifedName;
    }

    String createTypeProposalLabel(CompletionProposal typeProposal) {
        StringBuffer buf = new StringBuffer();
        buf.append(typeProposal.getCompletion());
        char[] declarationSignature = typeProposal.getDeclarationSignature();
        if (declarationSignature != null && declarationSignature.length > 0) {
            buf.append(JavaScriptElementLabels.CONCAT_STRING);
            buf.append(declarationSignature);
        }
        return buf.toString();
    }

    String createJavadocTypeProposalLabel(CompletionProposal typeProposal) {
        char[] fullName = Signature.toCharArray((char[])typeProposal.getSignature());
        return this.createJavadocTypeProposalLabel(fullName);
    }

    String createJavadocTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuffer buf = new StringBuffer("{@link ");
        buf.append(fullName, qIndex, fullName.length - qIndex);
        buf.append('}');
        if (qIndex > 0) {
            buf.append(JavaScriptElementLabels.CONCAT_STRING);
            buf.append(fullName, 0, qIndex - 1);
        }
        return buf.toString();
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    String createSimpleLabelWithType(CompletionProposal proposal) {
        StringBuffer buf = new StringBuffer();
        buf.append(proposal.getCompletion());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append(" : ");
            Util.insertTypeLabel((char[])typeName, (StringBuffer)buf);
        }
        return buf.toString();
    }

    private boolean isThisPrefix(char[] string) {
        if (string == null || string.length < 5) {
            return false;
        }
        return string[0] == 't' && string[1] == 'h' && string[2] == 'i' && string[3] == 's' && string[4] == '.';
    }

    String createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        char[] name = proposal.getCompletion();
        if (!this.isThisPrefix(name)) {
            name = proposal.getName();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        char[] returnType = proposal.getReturnType();
        if (returnType != null && returnType.length > 0 && !Arrays.equals(Signature.ANY, returnType)) {
            buf.append(" : ");
            Util.insertTypeLabel((char[])returnType, (StringBuffer)buf);
        }
        char[] declarationType = null;
        if (proposal.getDeclarationTypeName() != null) {
            declarationType = proposal.getDeclarationTypeName();
        } else if (proposal.getDeclarationSignature() != null) {
            declarationType = Signature.getSignatureSimpleName((char[])proposal.getDeclarationSignature());
        }
        if (CharOperation.equals((char[])declarationType, (char[])IIndexConstants.GLOBAL_SYMBOL)) {
            declarationType = JavaTextMessages.Global.toCharArray();
        }
        if (declarationType != null && declarationType.length > 0) {
            buf.append(" - ");
            Util.insertTypeLabel((char[])declarationType, (StringBuffer)buf);
        }
        return buf.toString();
    }

    String createPackageProposalLabel(CompletionProposal proposal) {
        Assert.isTrue((proposal.getKind() == 8 ? 1 : 0) != 0);
        return String.valueOf(proposal.getDeclarationSignature());
    }

    String createSimpleLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getCompletion());
    }

    String createAnonymousTypeLabel(CompletionProposal proposal) {
        char[] declaringTypeSignature = proposal.getDeclarationSignature();
        StringBuffer buffer = new StringBuffer();
        buffer.append(Signature.getSignatureSimpleName((char[])declaringTypeSignature));
        buffer.append('(');
        this.appendUnboundedParameterList(buffer, proposal);
        buffer.append(')');
        buffer.append("  ");
        buffer.append(JavaTextMessages.ResultCollector_anonymous_type);
        return buffer.toString();
    }

    public String createLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: 
            case 26: {
                if (this.fContext != null && this.fContext.isInJsdoc()) {
                    return this.createJavadocMethodProposalLabel(proposal);
                }
                return this.createMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createOverrideMethodProposalLabel(proposal);
            }
            case 1: {
                return this.createAnonymousTypeLabel(proposal);
            }
            case 9: {
                return this.createTypeProposalLabel(proposal);
            }
            case 16: {
                return this.createJavadocTypeProposalLabel(proposal);
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                return this.createSimpleLabel(proposal);
            }
            case 15: {
                return this.createJavadocMethodProposalLabel(proposal);
            }
            case 8: {
                return this.createPackageProposalLabel(proposal);
            }
            case 2: {
                return this.createLabelWithTypeAndDeclaration(proposal);
            }
            case 5: 
            case 10: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 3: 
            case 4: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        int flags = proposal.getFlags();
        block0 : switch (proposal.getKind()) {
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 26: {
                descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, flags);
                break;
            }
            case 1: 
            case 9: {
                switch (Signature.getTypeSignatureKind((char[])proposal.getSignature())) {
                    case 1: {
                        descriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, flags, false);
                        break block0;
                    }
                }
                descriptor = null;
                break;
            }
            case 2: {
                descriptor = JavaElementImageProvider.getFieldImageDescriptor(false, flags);
                break;
            }
            case 5: 
            case 10: {
                descriptor = JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                break;
            }
            case 8: {
                descriptor = JavaPluginImages.DESC_OBJS_PACKAGE;
                break;
            }
            case 3: 
            case 4: {
                descriptor = null;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                descriptor = JavaPluginImages.DESC_OBJS_JAVADOCTAG;
                break;
            }
            default: {
                descriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (descriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(descriptor, proposal);
    }

    ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getMethodImageDescriptor(false, flags), proposal);
    }

    ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getTypeImageDescriptor(true, false, flags, false), proposal);
    }

    ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getFieldImageDescriptor(false, flags), proposal);
    }

    ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, proposal);
    }

    ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_PACKAGE, proposal);
    }

    private ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        int adornments = 0;
        int flags = proposal.getFlags();
        int kind = proposal.getKind();
        if (Flags.isDeprecated((int)flags)) {
            adornments |= 0x400;
        }
        if ((kind == 2 || kind == 7 || kind == 7 || kind == 12 || kind == 6) && Flags.isStatic((int)flags)) {
            adornments |= 8;
        }
        if (kind == 9 && Flags.isAbstract((int)flags)) {
            adornments |= 1;
        }
        return new JavaScriptElementImageDescriptor(descriptor, adornments, JavaElementImageProvider.SMALL_SIZE);
    }

    void setContext(CompletionContext context) {
        this.fContext = context;
    }
}

