/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;

public abstract class AddMessageReferenceCommand
extends WSDLElementCommand {
    protected String name;
    protected MessageReference messageReference;
    protected Operation operation;
    protected boolean createMessage = false;
    private final String DEFAULT_MESSAGE_NAME = "NewMessage";

    public AddMessageReferenceCommand(Operation operation, String name) {
        this.operation = operation;
        this.name = name;
    }

    public AddMessageReferenceCommand(Operation operation, String name, boolean createMessage) {
        this.operation = operation;
        this.name = name;
        this.createMessage = createMessage;
    }

    protected void createMessage() {
        Definition definition = this.operation.getEnclosingDefinition();
        AddMessageCommand command = new AddMessageCommand(definition, "NewMessage", this.createMessage);
        command.run();
        this.messageReference.setEMessage((Message)command.getWSDLElement());
    }

    protected void createMessage(MessageReference originalMRef, String newMessageRefName) {
        Definition definition = this.operation.getEnclosingDefinition();
        Message tMessage = originalMRef.getEMessage();
        AddMessageCommand command = new AddMessageCommand(definition, tMessage, newMessageRefName, true);
        command.run();
        this.messageReference.setEMessage((Message)command.getWSDLElement());
    }

    @Override
    public WSDLElement getWSDLElement() {
        return this.messageReference;
    }

    public void setName(String name) {
        this.name = name;
    }
}

