/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.transport.AbstractSocketWrapper;
import org.eclipse.wst.jsdt.chromium.internal.websocket.Hybi00WsConnection;
import org.eclipse.wst.jsdt.chromium.internal.websocket.WsConnection;
import org.eclipse.wst.jsdt.chromium.util.SignalRelay;

public abstract class AbstractWsConnection<INPUT, OUTPUT>
implements WsConnection {
    protected static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final Logger LOGGER = Logger.getLogger(Hybi00WsConnection.class.getName());
    private final AbstractSocketWrapper<INPUT, OUTPUT> socketWrapper;
    private final ConnectionLogger connectionLogger;
    private volatile boolean isClosingGracefully = false;
    private final BlockingQueue<MessageDispatcher> dispatchQueue = new LinkedBlockingQueue<MessageDispatcher>();
    private boolean isDispatchQueueClosed = false;
    private boolean isOutputClosed = false;
    private final SignalRelay<CloseReason> linkedCloser = SignalRelay.create((SignalRelay.Callback)new SignalRelay.Callback<CloseReason>(){

        public void onSignal(CloseReason param, Exception cause) {
            AbstractWsConnection.this.isClosingGracefully = true;
        }
    });
    protected static final Charset LOGGER_CHARSET = new Charset("Chromium_Logger_Charset", new String[0]){

        @Override
        public boolean contains(Charset cs) {
            return this == cs;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return new CharsetDecoder(this, 2.0f, 4.0f){

                @Override
                protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                    while (in.hasRemaining()) {
                        byte b = in.get();
                        if (b < 20 && b != 10) {
                            if (out.remaining() < 4) {
                                return CoderResult.OVERFLOW;
                            }
                            out.put('%');
                            byte code = b;
                            int d1 = code / 100 % 10;
                            int d2 = code / 10 % 10;
                            int d3 = code % 10;
                            out.put((char)(48 + d1));
                            out.put((char)(48 + d2));
                            out.put((char)(48 + d3));
                            continue;
                        }
                        char ch = (char)b;
                        if (ch == '%') {
                            if (out.remaining() < 2) {
                                return CoderResult.OVERFLOW;
                            }
                            out.put('%');
                            out.put('%');
                            continue;
                        }
                        if (!out.hasRemaining()) {
                            return CoderResult.OVERFLOW;
                        }
                        out.put(ch);
                    }
                    return CoderResult.UNDERFLOW;
                }
            };
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    };
    private static final MessageDispatcher EOS_MESSAGE_DISPATCHER = new MessageDispatcher(){

        @Override
        boolean dispatch(WsConnection.Listener userListener) {
            userListener.eofMessage();
            return true;
        }
    };
    private static final SignalRelay.SignalConverter<AbstractSocketWrapper.ShutdownSignal, CloseReason> SOCKET_TO_CONNECTION = new SignalRelay.SignalConverter<AbstractSocketWrapper.ShutdownSignal, CloseReason>(){

        public CloseReason convert(AbstractSocketWrapper.ShutdownSignal source) {
            return CloseReason.CONNECTION_CLOSED;
        }
    };
    private static final RelayOk DISPATCH_THREAD_PROMISES_TO_RELAY_OK = new RelayOk(){};

    protected AbstractWsConnection(AbstractSocketWrapper<INPUT, OUTPUT> socketWrapper, ConnectionLogger connectionLogger) {
        this.socketWrapper = socketWrapper;
        this.connectionLogger = connectionLogger;
        try {
            this.linkedCloser.bind(socketWrapper.getShutdownRelay(), null, SOCKET_TO_CONNECTION);
        }
        catch (SignalRelay.AlreadySignalledException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelayOk runInDispatchThread(final Runnable runnable, final SyncCallback syncCallback) {
        MessageDispatcher messageDispatcher = new MessageDispatcher(){

            @Override
            boolean dispatch(WsConnection.Listener userListener) {
                RuntimeException ex = null;
                try {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        ex = e;
                        throw e;
                    }
                }
                finally {
                    syncCallback.callbackDone(ex);
                }
                return false;
            }
        };
        BlockingQueue<MessageDispatcher> blockingQueue = this.dispatchQueue;
        synchronized (blockingQueue) {
            if (this.isDispatchQueueClosed) {
                throw new IllegalStateException("Connection is closed");
            }
            this.dispatchQueue.add(messageDispatcher);
        }
        return DISPATCH_THREAD_PROMISES_TO_RELAY_OK;
    }

    @Override
    public void startListening(final WsConnection.Listener listener) {
        final Object loggableReader = this.socketWrapper.getLoggableInput();
        Runnable listenRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block27: {
                    Exception closeCause = null;
                    CloseReason closeReason = null;
                    try {
                        closeReason = AbstractWsConnection.this.runListenLoop(loggableReader);
                        if (closeReason == CloseReason.REMOTE_SILENTLY_CLOSED) {
                            LOGGER.log(Level.INFO, "Remote side silently closed connection without 'close' message");
                        }
                    }
                    catch (IOException e) {
                        closeCause = e;
                        LOGGER.log(Level.SEVERE, "Connection read failure", e);
                        BlockingQueue blockingQueue = AbstractWsConnection.this.dispatchQueue;
                        synchronized (blockingQueue) {
                            AbstractWsConnection.this.dispatchQueue.add(EOS_MESSAGE_DISPATCHER);
                            AbstractWsConnection.this.isDispatchQueueClosed = true;
                        }
                        if (AbstractWsConnection.this.connectionLogger != null) {
                            AbstractWsConnection.this.connectionLogger.handleEos();
                        }
                        if (closeReason == null) {
                            closeReason = CloseReason.INPUT_STREAM_PROBLEM;
                        }
                        AbstractWsConnection.this.linkedCloser.sendSignal((Object)closeReason, closeCause);
                        break block27;
                    }
                    catch (InterruptedException e) {
                        try {
                            closeCause = e;
                            closeReason = CloseReason.USER_REQUEST;
                            LOGGER.log(Level.SEVERE, "Thread interruption", e);
                        }
                        catch (Throwable throwable) {
                            BlockingQueue blockingQueue = AbstractWsConnection.this.dispatchQueue;
                            synchronized (blockingQueue) {
                                AbstractWsConnection.this.dispatchQueue.add(EOS_MESSAGE_DISPATCHER);
                                AbstractWsConnection.this.isDispatchQueueClosed = true;
                            }
                            if (AbstractWsConnection.this.connectionLogger != null) {
                                AbstractWsConnection.this.connectionLogger.handleEos();
                            }
                            if (closeReason == null) {
                                closeReason = CloseReason.INPUT_STREAM_PROBLEM;
                            }
                            AbstractWsConnection.this.linkedCloser.sendSignal((Object)closeReason, closeCause);
                            throw throwable;
                        }
                        BlockingQueue blockingQueue = AbstractWsConnection.this.dispatchQueue;
                        synchronized (blockingQueue) {
                            AbstractWsConnection.this.dispatchQueue.add(EOS_MESSAGE_DISPATCHER);
                            AbstractWsConnection.this.isDispatchQueueClosed = true;
                        }
                        if (AbstractWsConnection.this.connectionLogger != null) {
                            AbstractWsConnection.this.connectionLogger.handleEos();
                        }
                        if (closeReason == null) {
                            closeReason = CloseReason.INPUT_STREAM_PROBLEM;
                        }
                        AbstractWsConnection.this.linkedCloser.sendSignal((Object)closeReason, closeCause);
                        break block27;
                    }
                    BlockingQueue blockingQueue = AbstractWsConnection.this.dispatchQueue;
                    synchronized (blockingQueue) {
                        AbstractWsConnection.this.dispatchQueue.add(EOS_MESSAGE_DISPATCHER);
                        AbstractWsConnection.this.isDispatchQueueClosed = true;
                    }
                    if (AbstractWsConnection.this.connectionLogger != null) {
                        AbstractWsConnection.this.connectionLogger.handleEos();
                    }
                    if (closeReason == null) {
                        closeReason = CloseReason.INPUT_STREAM_PROBLEM;
                    }
                    AbstractWsConnection.this.linkedCloser.sendSignal((Object)closeReason, closeCause);
                }
            }
        };
        Thread readThread = new Thread(listenRunnable, "WebSocket listen thread");
        readThread.setDaemon(true);
        readThread.start();
        if (this.connectionLogger != null) {
            this.connectionLogger.start();
        }
        Runnable dispatchRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    this.runImpl();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Thread interruption", e);
                }
            }

            private void runImpl() throws InterruptedException {
                while (true) {
                    MessageDispatcher next = (MessageDispatcher)AbstractWsConnection.this.dispatchQueue.take();
                    try {
                        boolean isLast = next.dispatch(listener);
                        if (!isLast) continue;
                        return;
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, "Exception in dispatch thread", e);
                        continue;
                    }
                    break;
                }
            }
        };
        Thread dispatchThread = new Thread(dispatchRunnable, "WebSocket dispatch thread");
        dispatchThread.setDaemon(true);
        dispatchThread.start();
    }

    @Override
    public abstract void sendTextualMessage(String var1) throws IOException;

    protected abstract CloseReason runListenLoop(INPUT var1) throws IOException, InterruptedException;

    @Override
    public SignalRelay<?> getCloser() {
        return this.linkedCloser;
    }

    protected AbstractSocketWrapper<INPUT, OUTPUT> getSocketWrapper() {
        return this.socketWrapper;
    }

    protected boolean isClosingGracefully() {
        return this.isClosingGracefully;
    }

    protected boolean isOutputClosed() {
        return this.isOutputClosed;
    }

    protected void setOutputClosed(boolean isOutputClosed) {
        this.isOutputClosed = isOutputClosed;
    }

    protected BlockingQueue<MessageDispatcher> getDispatchQueue() {
        return this.dispatchQueue;
    }

    protected static void dumpByte(byte b, StringBuilder output) {
        output.append('%');
        int code = (b + 256) % 256;
        int d1 = code / 100 % 10;
        int d2 = code / 10 % 10;
        int d3 = code % 10;
        output.append((char)(48 + d1));
        output.append((char)(48 + d2));
        output.append((char)(48 + d3));
    }

    public static enum CloseReason {
        CONNECTION_CLOSED,
        INPUT_STREAM_PROBLEM,
        USER_REQUEST,
        REMOTE_CLOSE_REQUEST,
        REMOTE_SILENTLY_CLOSED;

    }

    static abstract class MessageDispatcher {
        MessageDispatcher() {
        }

        abstract boolean dispatch(WsConnection.Listener var1);
    }
}

