/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindServiceUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class AddServiceToUDDIPerspectiveAction
extends AddToUDDIPerspectiveAction {
    public AddServiceToUDDIPerspectiveAction(Controller controller) {
        super(controller);
    }

    @Override
    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "uddiServices", "viewId", 2);
        return transformers;
    }

    @Override
    public boolean executeSingleLinkAction() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        Node selectedNode = wsilPerspective.getNodeManager().getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        String inquiryURL = null;
        String serviceKey = null;
        String serviceName = null;
        if (selectedElement instanceof WsilElement) {
            ListElement le = ((WsilElement)selectedElement).getAllUDDIServices().getElementWithViewId(viewID);
            WsilUddiServiceElement wsilUddiServiceElement = (WsilUddiServiceElement)((Object)le.getObject());
            inquiryURL = wsilUddiServiceElement.getUDDIServiceInquiryAPI();
            serviceKey = wsilUddiServiceElement.getUDDIServiceKey();
            serviceName = wsilUddiServiceElement.getName();
            if (serviceName == null) {
                serviceName = serviceKey;
            }
        } else {
            return false;
        }
        if (!this.createRegistryInUDDIPerspective(inquiryURL, null, inquiryURL)) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_TO_UDDI_PERSPECTIVE", serviceName));
            return false;
        }
        RegFindServiceUUIDAction action = new RegFindServiceUUIDAction(this.controller_);
        Hashtable propertyTable = action.getPropertyTable();
        propertyTable.put("uuidServiceKey", serviceKey);
        propertyTable.put("queryName", serviceName);
        if (!action.run()) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_SERVICE_NOT_FOUND", serviceName));
            return false;
        }
        wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_TO_UDDI_PERSPECTIVE_SUCCESSFUL", serviceName));
        return true;
    }
}

