/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.AttributeToPropertyMapping;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagMapping;

public class ViewMetadataLoader {
    private final IProject _project;
    private final IMetaDataQuery _query;

    public ViewMetadataLoader(IProject project) {
        this._project = project;
        IMetaDataDomainContext modelContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this._project);
        this._query = MetaDataQueryFactory.getInstance().createQuery(modelContext);
    }

    public TagMapping getTagToViewMapping(TagIdentifier tagId) {
        Trait trait;
        Entity entity = this._query.getQueryHelper().getEntity(tagId.getUri(), tagId.getTagName());
        if (entity != null && (trait = this._query.getQueryHelper().getTrait(entity, "viewElementMapping")) != null) {
            return (TagMapping)trait.getValue();
        }
        return null;
    }

    public AttributeToPropertyMapping getAttributeMapping(TagIdentifier tagId, String name) {
        Trait trait;
        Entity entity = this._query.getQueryHelper().getEntity(tagId.getUri(), tagId.getTagName() + "/" + name);
        if (entity != null && (trait = this._query.getQueryHelper().getTrait(entity, "attributeMapping")) != null) {
            return (AttributeToPropertyMapping)trait.getValue();
        }
        return null;
    }
}

