/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.io.File;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSP2ServletNameUtil;
import org.eclipse.jst.jsp.core.internal.java.search.JSPIndexManager;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchDocument;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchParticipant;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;

public class JSPSearchSupport {
    static final boolean DEBUG;
    private static JSPSearchSupport singleton;
    private JSPSearchParticipant fParticipant = null;
    private IPath fJspPluginLocation = null;
    private final CRC32 fChecksumCalculator = new CRC32();
    private final IProgressMonitor fMonitor = new NullProgressMonitor();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
        singleton = null;
    }

    private JSPSearchSupport() {
    }

    public static synchronized JSPSearchSupport getInstance() {
        if (singleton == null) {
            singleton = new JSPSearchSupport();
        }
        return singleton;
    }

    public static boolean isJsp(IFile file) {
        IContentType contentTypeJSP;
        boolean isJsp = false;
        if (file != null && file.exists() && (contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP)).isAssociatedWith(file.getName())) {
            isJsp = true;
        }
        return isJsp;
    }

    public SearchDocument addJspFile(IFile file) {
        SearchDocument delegate;
        block6: {
            if (JSPSearchSupport.getInstance().isCanceled() || !file.isAccessible()) {
                return null;
            }
            if (DEBUG) {
                System.out.println("adding JSP file:" + String.valueOf(file.getFullPath()));
            }
            if ((delegate = this.createSearchDocument(file)) != null) {
                try {
                    this.getSearchParticipant().scheduleDocumentIndexing(delegate, this.computeIndexLocation(file.getParent().getFullPath()));
                }
                catch (Exception e) {
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
        if (DEBUG) {
            System.out.println("scheduled" + String.valueOf(delegate) + "for indexing");
        }
        return delegate;
    }

    public void search(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
        this.search(searchText, scope, searchFor, limitTo, matchMode, isCaseSensitive, requestor, (IProgressMonitor)new NullProgressMonitor());
    }

    public void search(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
        this.search(element, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
    }

    public void searchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
        this.searchRunnable(element, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
    }

    public void search(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor, IProgressMonitor monitor) {
        JSPIndexManager.getDefault().waitForConsistent(monitor);
        SearchJob job = new SearchJob(searchText, scope, searchFor, limitTo, matchMode, isCaseSensitive, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void search(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) {
        JSPIndexManager.getDefault().waitForConsistent(monitor);
        SearchJob job = new SearchJob(element, scope, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void searchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) {
        JSPIndexManager.getDefault().waitForConsistent(monitor);
        SearchRunnable searchRunnable = new SearchRunnable(element, scope, requestor);
        try {
            this.setCanceled(false);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)searchRunnable, JSPSearchSupport.getInstance().getProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private SearchDocument createSearchDocument(IFile jspFile) {
        JavaSearchDocumentDelegate delegate = null;
        if (jspFile != null && jspFile.exists() && JSPSearchSupport.isJsp(jspFile)) {
            delegate = new JavaSearchDocumentDelegate(new JSPSearchDocument(jspFile.getFullPath().toString(), this.getSearchParticipant()));
        }
        return delegate;
    }

    public SearchDocument getSearchDocument(String searchDocPath) {
        SearchDocument delegate = null;
        IFile f = this.fileForCUPath(searchDocPath);
        if (f != null) {
            delegate = this.createSearchDocument(f);
        }
        return delegate;
    }

    private IFile fileForCUPath(String searchDocPath) {
        Path path;
        String[] split = searchDocPath.split("/");
        String classname = split[split.length - 1];
        if (!searchDocPath.endsWith(".java")) {
            return null;
        }
        String filePath = JSP2ServletNameUtil.unmangle(classname);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        if (f == null && (path = new Path(filePath)).segmentCount() >= 2) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return f;
    }

    JSPSearchParticipant getSearchParticipant() {
        if (this.fParticipant == null) {
            this.fParticipant = new JSPSearchParticipant();
        }
        return this.fParticipant;
    }

    public final IPath computeIndexLocation(IPath containerPath) {
        IPath indexLocation = null;
        String pathString = containerPath.toOSString();
        this.fChecksumCalculator.reset();
        this.fChecksumCalculator.update(pathString.getBytes());
        String fileName = Long.toString(this.fChecksumCalculator.getValue()) + ".index";
        indexLocation = this.getModelJspPluginWorkingLocation().append(fileName);
        return indexLocation;
    }

    public IPath getModelJspPluginWorkingLocation() {
        File folder;
        if (this.fJspPluginLocation != null) {
            return this.fJspPluginLocation;
        }
        IPath stateLocation = JSPCorePlugin.getDefault().getStateLocation().append("jspsearch");
        String device = stateLocation.getDevice();
        if (device != null && device.charAt(0) == '/') {
            stateLocation = stateLocation.setDevice(device.substring(1));
        }
        if (!(folder = new File(stateLocation.toOSString())).isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        this.fJspPluginLocation = stateLocation;
        return this.fJspPluginLocation;
    }

    public final synchronized void setCanceled(boolean cancel) {
        this.fMonitor.setCanceled(cancel);
    }

    public final synchronized boolean isCanceled() {
        return this.fMonitor.isCanceled();
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    private class SearchJob
    extends Job
    implements IJavaSearchConstants {
        String fSearchText;
        IJavaSearchScope fScope;
        int fSearchFor;
        int fLimitTo;
        int fMatchMode;
        SearchRequestor fRequestor;
        IJavaElement fElement;

        public SearchJob(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            super(JSPCoreMessages.JSP_Search + element.getElementName());
            this.fSearchText = "";
            this.fScope = null;
            this.fSearchFor = 4;
            this.fLimitTo = 3;
            this.fMatchMode = 2;
            this.fRequestor = null;
            this.fElement = null;
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SearchJob(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            super(JSPCoreMessages.JSP_Search + searchText);
            this.fSearchText = "";
            this.fScope = null;
            this.fSearchFor = 4;
            this.fLimitTo = 3;
            this.fMatchMode = 2;
            this.fRequestor = null;
            this.fElement = null;
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fRequestor = requestor;
        }

        public boolean belongsTo(Object family) {
            return family == JSPSearchSupport.class;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IStatus run(IProgressMonitor jobMonitor) {
            if (jobMonitor != null && jobMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (JSPSearchSupport.getInstance().isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SearchPattern javaSearchPattern = null;
            javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            if (javaSearchPattern == null) return Status.OK_STATUS;
            SearchParticipant[] participants = new JSPSearchParticipant[]{JSPSearchSupport.this.getSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            try {
                try {
                    if (jobMonitor != null) {
                        jobMonitor.beginTask("", -1);
                    }
                    engine.search(javaSearchPattern, participants, this.fScope, this.fRequestor, jobMonitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    if (DEBUG) {
                        Logger.logException(e);
                    }
                    if (jobMonitor == null) return Status.OK_STATUS;
                    jobMonitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    if (DEBUG) {
                        Logger.logException(e);
                    }
                    if (jobMonitor == null) return Status.OK_STATUS;
                    jobMonitor.done();
                    return Status.OK_STATUS;
                }
            }
            finally {
                if (jobMonitor != null) {
                    jobMonitor.done();
                }
            }
        }
    }

    private class SearchRunnable
    implements IWorkspaceRunnable,
    IJavaSearchConstants {
        String fSearchText = "";
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        int fLimitTo = 3;
        int fMatchMode = 2;
        SearchRequestor fRequestor = null;
        IJavaElement fElement = null;

        public SearchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (JSPSearchSupport.getInstance().isCanceled()) {
                return;
            }
            SearchPattern javaSearchPattern = null;
            javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            if (javaSearchPattern == null) return;
            SearchParticipant[] participants = new JSPSearchParticipant[]{JSPSearchSupport.this.getSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            try {
                try {
                    if (monitor != null) {
                        monitor.beginTask("", 0);
                    }
                    engine.search(javaSearchPattern, participants, this.fScope, this.fRequestor, monitor);
                    return;
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    if (monitor == null) return;
                    monitor.done();
                    return;
                }
                catch (Exception e) {
                    Logger.logException(e);
                    if (monitor == null) return;
                    monitor.done();
                    return;
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

