/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tests;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class QuickTestManifests
implements IApplication {
    private static final boolean DEBUG = false;
    private static final String PATH = "/Users/equinox/eclipse_ibuild/plugins";
    private String rootpath;
    private int checkedOk;
    private int failedCount;
    private int errorCount;
    private int foundExepected;

    public Object start(IApplicationContext context) throws Exception {
        File root = this.getRoot(context);
        this.checkBundles(root);
        this.printReport();
        return IApplication.EXIT_OK;
    }

    private void checkBundles(File root) throws BundleException, IOException {
        File[] children;
        File[] fileArray = children = root.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                this.processFolder(child);
            } else if (child.getName().endsWith(".jar") || child.getName().endsWith(".zip")) {
                this.processJar(child);
            } else if (!child.getName().endsWith(".jar.pack.gz") && !child.getName().endsWith(".xml")) {
                this.error("Skipping unexpected file type: " + child);
            }
            ++n2;
        }
    }

    private void printReport() {
        System.out.println();
        System.out.println("Checked bundles under root path: " + this.rootpath);
        System.out.println("Failed to read manifest (may be normal): " + this.failedCount);
        System.out.println("Bundles with incorrect 'version' attribute errors: " + this.errorCount);
        System.out.println("Occurances of 'bundle-version': " + this.foundExepected);
        System.out.println("CheckedOk: " + this.checkedOk);
        System.out.println();
    }

    private File getRoot(IApplicationContext context) {
        String appargskey;
        Map args = context.getArguments();
        String[] appargs = (String[])args.get(appargskey = "application.args");
        if (appargs.length > 0) {
            this.rootpath = appargs[0];
            System.out.println("Found path from application arguments: " + this.rootpath);
        } else {
            this.rootpath = PATH;
            System.out.println("No path was found from application arguments, so using default: " + this.rootpath);
        }
        File root = new File(this.rootpath);
        return root;
    }

    private void debug(String message) {
    }

    private void error(String message) {
        System.err.println(message);
    }

    private void processFolder(File folder) throws BundleException {
        block15: {
            this.debug("Processing: " + folder);
            File manifestFile = new File(folder, "META-INF/MANIFEST.MF");
            if (!manifestFile.exists()) {
                this.error("WARNING: Unable to read manifest at: " + manifestFile.getAbsolutePath());
                ++this.failedCount;
                return;
            }
            InputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(manifestFile));
                    this.processStream(input, manifestFile.getAbsolutePath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processJar(File file) throws IOException, BundleException {
        block5: {
            this.debug("Processing: " + file);
            JarFile jar = new JarFile(file);
            ZipEntry entry = jar.getEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                this.error("WARNING: No manifest found in: " + file.getAbsolutePath());
                ++this.failedCount;
                return;
            }
            BufferedInputStream input = null;
            try {
                input = new BufferedInputStream(jar.getInputStream(entry));
                this.processStream(input, file.getAbsolutePath());
            }
            catch (IOException iOException) {
                if (input == null) break block5;
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException2) {
                    System.out.println("Unexpectedly could not close stream?");
                }
            }
        }
    }

    private void processStream(InputStream input, String filename) throws IOException, BundleException {
        String[] KEYS = new String[]{"Require-Bundle", "Fragment-Host"};
        Map<String, String> manifest = this.getManifest(input);
        String[] stringArray = KEYS;
        int n = KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement[] elements;
            String key = stringArray[n2];
            String value = manifest.get(key);
            if (value != null && (elements = ManifestElement.parseHeader((String)key, (String)value)) != null) {
                ManifestElement[] manifestElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    ManifestElement element = manifestElementArray[n4];
                    if (element != null) {
                        Enumeration e = element.getKeys();
                        while (e != null && e.hasMoreElements()) {
                            String attr = (String)e.nextElement();
                            if ("version".equals(attr)) {
                                this.error(filename);
                                ++this.errorCount;
                                return;
                            }
                            if (!"bundle-version".equals(attr)) continue;
                            ++this.foundExepected;
                        }
                    }
                    ++n4;
                }
                ++this.checkedOk;
            }
            ++n2;
        }
    }

    private Map<String, String> getManifest(InputStream input) throws IOException, BundleException {
        return ManifestElement.parseBundleManifest((InputStream)input, null);
    }

    public void stop() {
    }
}

