/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;

public class XMLValidationConfigurationTest
extends TestCase {
    XMLValidationConfiguration configuration;

    public static Test suite() {
        return new TestSuite(XMLValidationConfigurationTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configuration = new XMLValidationConfiguration();
    }

    protected void tearDown() throws Exception {
        this.configuration = null;
        super.tearDown();
    }

    public void testSetWarnNoGrammarFeatureDefault() {
        try {
            XMLValidationConfigurationTest.assertFalse((String)"The WARN_NO_GRAMMAR feature is not set by default to false.", (boolean)this.configuration.getFeature("WARN_NO_GRAMMAR"));
        }
        catch (Exception e) {
            XMLValidationConfigurationTest.fail((String)("Unable to set read the WARN_NO_GRAMMAR feature: " + e));
        }
    }

    public void testSetWarnNoGrammarFeatureTrue() {
        try {
            this.configuration.setFeature("WARN_NO_GRAMMAR", true);
            XMLValidationConfigurationTest.assertTrue((String)"The WARN_NO_GRAMMAR feature is not set to true.", (boolean)this.configuration.getFeature("WARN_NO_GRAMMAR"));
        }
        catch (Exception e) {
            XMLValidationConfigurationTest.fail((String)("Unable to set WARN_NO_GRAMMAR to true: " + e));
        }
    }

    public void testSetWarnNoGrammarFeatureFalse() {
        try {
            this.configuration.setFeature("WARN_NO_GRAMMAR", false);
            XMLValidationConfigurationTest.assertFalse((String)"The WARN_NO_GRAMMAR feature is not set to false.", (boolean)this.configuration.getFeature("WARN_NO_GRAMMAR"));
        }
        catch (Exception e) {
            XMLValidationConfigurationTest.fail((String)("Unable to set WARN_NO_GRAMMAR to false: " + e));
        }
    }

    public void testSetNotExistantFeature() {
        try {
            this.configuration.setFeature("NON_EXISTANT_FEATURE", false);
            XMLValidationConfigurationTest.fail((String)"Setting a non existant feature did not produce an exception.");
        }
        catch (Exception exception) {}
    }

    public void testGetNotExistantFeature() {
        try {
            this.configuration.getFeature("NON_EXISTANT_FEATURE");
            XMLValidationConfigurationTest.fail((String)"Getting a non existant feature did not produce an exception.");
        }
        catch (Exception exception) {}
    }

    public void testIndicateNoGrammarFeatureDefault() {
        try {
            XMLValidationConfigurationTest.assertEquals((String)"The INDICATE_NO_GRAMMAR feature is not set by default to Ignore.", (int)-1, (int)this.configuration.getIntFeature("INDICATE_NO_GRAMMAR"));
        }
        catch (Exception e) {
            XMLValidationConfigurationTest.fail((String)("Unable to set read the WARN_NO_GRAMMAR feature: " + e));
        }
    }
}

