/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.stack;

import java.util.EmptyStackException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.stack.EmptyStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class EmptyStackTests
extends TestCase {
    public EmptyStackTests(String name) {
        super(name);
    }

    public void testPush() {
        Stack stack = StackTools.emptyStack();
        boolean exCaught = false;
        try {
            stack.push((Object)"junk");
            EmptyStackTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyStackTests.assertTrue((boolean)exCaught);
    }

    public void testPop() {
        Stack stack = EmptyStack.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)stack.pop();
            EmptyStackTests.fail((String)bogus);
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        EmptyStackTests.assertTrue((boolean)exCaught);
    }

    public void testPeek() {
        Stack stack = EmptyStack.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)stack.peek();
            EmptyStackTests.fail((String)bogus);
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        EmptyStackTests.assertTrue((boolean)exCaught);
    }

    public void testIsEmpty() {
        Stack stack = EmptyStack.instance();
        EmptyStackTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testToString() {
        Stack stack = EmptyStack.instance();
        EmptyStackTests.assertEquals((String)"[]", (String)stack.toString());
    }

    public void testSerialization() throws Exception {
        Stack stack = EmptyStack.instance();
        EmptyStackTests.assertSame((Object)stack, (Object)TestTools.serialize(stack));
    }
}

