/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.listener;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.exception.RuntimeExceptionHandler;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ReflectiveChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

public class ReflectivePropertyChangeListenerTests
extends TestCase {
    public ReflectivePropertyChangeListenerTests(String name) {
        super(name);
    }

    public void testZeroArgumentNamedProperty() {
        TestModel testModel = new TestModel(7);
        Target target = new Target(testModel, "value", 7, 99);
        testModel.addPropertyChangeListener("value", ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (String)"propertyChangedZeroArgument"));
        testModel.setValue(99);
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)target.zeroArgumentFlag);
        ReflectivePropertyChangeListenerTests.assertFalse((boolean)target.singleArgumentFlag);
    }

    public void testSingleArgument2() throws Exception {
        TestModel testModel = new TestModel(7);
        Target target = new Target(testModel, "value", 7, 99);
        Method method = ObjectTools.method((Object)target, (String)"propertyChangedSingleArgument2", (Class[])new Class[]{Object.class});
        testModel.addPropertyChangeListener("value", ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (Method)method));
        testModel.setValue(99);
        ReflectivePropertyChangeListenerTests.assertFalse((boolean)target.zeroArgumentFlag);
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)target.singleArgumentFlag);
    }

    public void testSingleArgumentNamedProperty() {
        TestModel testModel = new TestModel(7);
        Target target = new Target(testModel, "value", 7, 99);
        testModel.addPropertyChangeListener("value", ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (String)"propertyChangedSingleArgument"));
        testModel.setValue(99);
        ReflectivePropertyChangeListenerTests.assertFalse((boolean)target.zeroArgumentFlag);
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)target.singleArgumentFlag);
    }

    public void testSingleArgumentNamedProperty2() throws Exception {
        TestModel testModel = new TestModel(7);
        Target target = new Target(testModel, "value", 7, 99);
        Method method = ObjectTools.method((Object)target, (String)"propertyChangedSingleArgument2", (Class[])new Class[]{Object.class});
        testModel.addPropertyChangeListener("value", ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (Method)method));
        testModel.setValue(99);
        ReflectivePropertyChangeListenerTests.assertFalse((boolean)target.zeroArgumentFlag);
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)target.singleArgumentFlag);
    }

    public void testListenerMismatch() {
        TestModel testModel = new TestModel(7);
        Target target = new Target(testModel, "value", 7, 99);
        PropertyChangeListener listener = ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (String)"propertyChangedSingleArgument");
        testModel.addStateChangeListener((StateChangeListener)listener);
        boolean exCaught = false;
        try {
            testModel.setValue(99);
            ReflectivePropertyChangeListenerTests.fail((String)("listener mismatch: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testBogusDoubleArgument1() {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel(7);
            Target target = new Target(testModel, "value", 7, 99);
            exCaught = false;
            try {
                PropertyChangeListener listener = ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (String)"stateChangedDoubleArgument");
                ReflectivePropertyChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (ex.getCause().getClass() != NoSuchMethodException.class) break block2;
                exCaught = true;
            }
        }
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testBogusDoubleArgument2() throws Exception {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel(7);
            Target target = new Target(testModel, "value", 7, 99);
            Method method = ObjectTools.method((Object)target, (String)"propertyChangedDoubleArgument", (Class[])new Class[]{PropertyChangeEvent.class, Object.class});
            exCaught = false;
            try {
                PropertyChangeListener listener = ReflectiveChangeListener.buildPropertyChangeListener((Object)target, (Method)method);
                ReflectivePropertyChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (!ex.getMessage().equals(method.toString())) break block2;
                exCaught = true;
            }
        }
        ReflectivePropertyChangeListenerTests.assertTrue((boolean)exCaught);
    }

    class Target {
        TestModel testModel;
        String propertyName;
        Object oldValue;
        Object newValue;
        boolean zeroArgumentFlag = false;
        boolean singleArgumentFlag = false;

        Target(TestModel testModel, String propertyName, int oldValue, int newValue) {
            this.testModel = testModel;
            this.propertyName = propertyName;
            this.oldValue = new Integer(oldValue);
            this.newValue = new Integer(newValue);
        }

        void propertyChangedZeroArgument() {
            this.zeroArgumentFlag = true;
        }

        void propertyChangedSingleArgument(PropertyChangeEvent e) {
            this.singleArgumentFlag = true;
            ReflectivePropertyChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectivePropertyChangeListenerTests.assertEquals((String)this.propertyName, (String)e.getPropertyName());
            ReflectivePropertyChangeListenerTests.assertEquals((Object)this.oldValue, (Object)e.getOldValue());
            ReflectivePropertyChangeListenerTests.assertEquals((Object)this.newValue, (Object)e.getNewValue());
        }

        void propertyChangedSingleArgument2(Object o) {
            PropertyChangeEvent e = (PropertyChangeEvent)o;
            this.singleArgumentFlag = true;
            ReflectivePropertyChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectivePropertyChangeListenerTests.assertEquals((String)this.propertyName, (String)e.getPropertyName());
            ReflectivePropertyChangeListenerTests.assertEquals((Object)this.oldValue, (Object)e.getOldValue());
            ReflectivePropertyChangeListenerTests.assertEquals((Object)this.newValue, (Object)e.getNewValue());
        }

        void propertyChangedDoubleArgument(PropertyChangeEvent e, Object o) {
            ReflectivePropertyChangeListenerTests.fail((String)("bogus event: " + e + " - object: " + o));
        }
    }

    class TestModel
    extends AbstractModel {
        private int value = 0;
        public static final String VALUE_PROPERTY = "value";

        TestModel(int value) {
            this.value = value;
        }

        protected ChangeSupport buildChangeSupport() {
            return new ChangeSupport((Model)this, RuntimeExceptionHandler.instance());
        }

        void setValue(int value) {
            int old = this.value;
            this.value = value;
            this.firePropertyChanged(VALUE_PROPERTY, old, value);
            if (old != value) {
                this.fireStateChanged();
            }
        }
    }
}

