/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.deque.ArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.FixedCapacityArrayDeque;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeTests;

public class FixedCapacityArrayDequeTests
extends DequeTests {
    public FixedCapacityArrayDequeTests(String name) {
        super(name);
    }

    FixedCapacityArrayDeque<String> buildDeque() {
        return this.buildDeque(10);
    }

    FixedCapacityArrayDeque<String> buildDeque(int capacity) {
        return DequeTools.fixedCapacityArrayDeque((int)capacity);
    }

    public void testInitialCapacityConstructor() {
        boolean exCaught = false;
        try {
            ArrayDeque queue = DequeTools.arrayDeque((int)-1);
            FixedCapacityArrayDequeTests.fail((String)("bogus deque: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        FixedCapacityArrayDequeTests.assertTrue((boolean)exCaught);
    }

    public void testIsFull() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque(3);
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isFull());
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isFull());
    }

    public void testWrappedElementsTail() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque();
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"third");
        queue.enqueueTail((Object)"fourth");
        queue.enqueueTail((Object)"fifth");
        queue.enqueueTail((Object)"sixth");
        FixedCapacityArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        queue.enqueueTail((Object)"seventh");
        queue.enqueueTail((Object)"eighth");
        queue.enqueueTail((Object)"ninth");
        queue.enqueueTail((Object)"tenth");
        queue.enqueueTail((Object)"eleventh");
        queue.enqueueTail((Object)"twelfth");
        FixedCapacityArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testWrappedElementsHead() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque();
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"first");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"second");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"third");
        queue.enqueueHead((Object)"fourth");
        queue.enqueueHead((Object)"fifth");
        queue.enqueueHead((Object)"sixth");
        FixedCapacityArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueTail()));
        queue.enqueueHead((Object)"seventh");
        queue.enqueueHead((Object)"eighth");
        queue.enqueueHead((Object)"ninth");
        queue.enqueueHead((Object)"tenth");
        queue.enqueueHead((Object)"eleventh");
        queue.enqueueHead((Object)"twelfth");
        FixedCapacityArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededTail() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque();
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"third");
        queue.enqueueTail((Object)"fourth");
        queue.enqueueTail((Object)"fifth");
        queue.enqueueTail((Object)"sixth");
        queue.enqueueTail((Object)"seventh");
        queue.enqueueTail((Object)"eighth");
        queue.enqueueTail((Object)"ninth");
        queue.enqueueTail((Object)"tenth");
        boolean exCaught = false;
        try {
            queue.enqueueTail((Object)"eleventh");
            FixedCapacityArrayDequeTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayDequeTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededHead() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque();
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"first");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"second");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"third");
        queue.enqueueHead((Object)"fourth");
        queue.enqueueHead((Object)"fifth");
        queue.enqueueHead((Object)"sixth");
        queue.enqueueHead((Object)"seventh");
        queue.enqueueHead((Object)"eighth");
        queue.enqueueHead((Object)"ninth");
        queue.enqueueHead((Object)"tenth");
        boolean exCaught = false;
        try {
            queue.enqueueHead((Object)"eleventh");
            FixedCapacityArrayDequeTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayDequeTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElementsTail() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque();
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"third");
        queue.enqueueTail((Object)"fourth");
        queue.enqueueTail((Object)"fifth");
        queue.enqueueTail((Object)"sixth");
        FixedCapacityArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        queue.enqueueTail((Object)"seventh");
        queue.enqueueTail((Object)"eighth");
        queue.enqueueTail((Object)"ninth");
        queue.enqueueTail((Object)"tenth");
        queue.enqueueTail((Object)"eleventh");
        queue.enqueueTail((Object)"twelfth");
        queue.enqueueTail((Object)"thirteenth");
        boolean exCaught = false;
        try {
            queue.enqueueTail((Object)"fourteenth");
            FixedCapacityArrayDequeTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayDequeTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeueHead()));
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElementsHead() {
        FixedCapacityArrayDeque<String> queue = this.buildDeque();
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"first");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"second");
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"third");
        queue.enqueueHead((Object)"fourth");
        queue.enqueueHead((Object)"fifth");
        queue.enqueueHead((Object)"sixth");
        FixedCapacityArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueTail()));
        queue.enqueueHead((Object)"seventh");
        queue.enqueueHead((Object)"eighth");
        queue.enqueueHead((Object)"ninth");
        queue.enqueueHead((Object)"tenth");
        queue.enqueueHead((Object)"eleventh");
        queue.enqueueHead((Object)"twelfth");
        queue.enqueueHead((Object)"thirteenth");
        boolean exCaught = false;
        try {
            queue.enqueueHead((Object)"fourteenth");
            FixedCapacityArrayDequeTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityArrayDequeTests.assertTrue((boolean)exCaught);
        FixedCapacityArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeueTail()));
        FixedCapacityArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testSerialization_empty() throws Exception {
        FixedCapacityArrayDeque original = new FixedCapacityArrayDeque(3);
        Deque clone = (Deque)TestTools.serialize(original);
        FixedCapacityArrayDequeTests.assertNotSame((Object)original, (Object)clone);
        FixedCapacityArrayDequeTests.assertTrue((boolean)original.isEmpty());
        FixedCapacityArrayDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueueTail((Object)"fourth");
        FixedCapacityArrayDequeTests.assertFalse((boolean)original.isEmpty());
        FixedCapacityArrayDequeTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testSerialization_fullArray() throws Exception {
        FixedCapacityArrayDeque queue = new FixedCapacityArrayDeque(3);
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        this.verifyClone((Deque<String>)queue, (Deque<String>)((Deque)TestTools.serialize(queue)));
    }

    public void testSerialization_wrappedArray() throws Exception {
        FixedCapacityArrayDeque queue = new FixedCapacityArrayDeque(3);
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        queue.dequeueHead();
        queue.enqueueTail((Object)"fourth");
        this.verifyClone((Deque<String>)queue, (Deque<String>)((Deque)TestTools.serialize(queue)));
    }
}

