/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.Serializable;
import java.util.EventListener;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public class ListenerListTests
extends TestCase {
    public ListenerListTests(String name) {
        super(name);
    }

    public void testGetListeners() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertEquals((int)0, (int)IterableTools.size((Iterable)listenerList));
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertEquals((int)2, (int)IterableTools.size((Iterable)listenerList));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener2));
    }

    public void testSize() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertEquals((int)0, (int)listenerList.size());
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertEquals((int)2, (int)listenerList.size());
    }

    public void testIsEmpty() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertTrue((boolean)listenerList.isEmpty());
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertFalse((boolean)listenerList.isEmpty());
    }

    public void testAdd_null() throws Exception {
        ListenerList listenerList = new ListenerList();
        boolean exCaught = false;
        try {
            listenerList.add(null);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testAdd_duplicate() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener = new LocalListener();
        listenerList.add((Object)listener);
        boolean exCaught = false;
        try {
            listenerList.add((Object)listener);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testRemove() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener2));
        listenerList.remove((Object)listener1);
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener2));
        listenerList.remove((Object)listener2);
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener2));
    }

    public void testRemove_null() throws Exception {
        ListenerList listenerList = new ListenerList();
        boolean exCaught = false;
        try {
            listenerList.remove(null);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testRemove_unregistered() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener = new LocalListener();
        listenerList.add((Object)listener);
        listenerList.remove((Object)listener);
        boolean exCaught = false;
        try {
            listenerList.remove((Object)listener);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testClear() throws Exception {
        ListenerList listenerList = new ListenerList();
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener2));
        listenerList.clear();
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener1));
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList, (Object)listener2));
    }

    static interface Listener
    extends EventListener {
        public void somethingHappened();
    }

    static class LocalListener
    implements Listener,
    Serializable {
        private static final long serialVersionUID = 1L;

        LocalListener() {
        }

        @Override
        public void somethingHappened() {
        }
    }

    static class NonSerializableListener
    implements Listener {
        NonSerializableListener() {
        }

        @Override
        public void somethingHappened() {
        }
    }
}

