/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.standalonev8;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.StandaloneVm;
import org.eclipse.wst.jsdt.chromium.UnsupportedVersionException;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.transport.Connection;
import org.eclipse.wst.jsdt.chromium.internal.transport.Handshaker;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSessionManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.JavascriptVmImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandOutput;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8ContextFilter;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ContextHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class StandaloneVmImpl
extends JavascriptVmImpl
implements StandaloneVm {
    private static final Logger LOGGER = Logger.getLogger(StandaloneVmImpl.class.getName());
    private static final int WAIT_FOR_HANDSHAKE_TIMEOUT_MS = 3000;
    private static final V8ContextFilter CONTEXT_FILTER = new V8ContextFilter(){

        @Override
        public boolean isContextOurs(ContextHandle contextHandle) {
            return true;
        }
    };
    private final Connection connection;
    private final Handshaker.StandaloneV8 handshaker;
    private final DebugSession debugSession;
    private DebugEventListener debugEventListener = null;
    private volatile ConnectionState connectionState = ConnectionState.INIT;
    private volatile Exception disconnectReason = null;
    private volatile Handshaker.StandaloneV8.RemoteInfo savedRemoteInfo = NULL_REMOTE_INFO;
    private final Object disconnectMonitor = new Object();
    private final DebugSessionManager sessionManager = new DebugSessionManager(){

        @Override
        public DebugEventListener getDebugEventListener() {
            return StandaloneVmImpl.this.debugEventListener;
        }

        @Override
        public void onDebuggerDetached() {
        }
    };
    private static final Handshaker.StandaloneV8.RemoteInfo NULL_REMOTE_INFO = new Handshaker.StandaloneV8.RemoteInfo(){

        @Override
        public String getEmbeddingHostName() {
            return null;
        }

        @Override
        public String getProtocolVersion() {
            return null;
        }

        @Override
        public String getV8VmVersion() {
            return null;
        }
    };

    public StandaloneVmImpl(Connection connection, Handshaker.StandaloneV8 handshaker) {
        this.connection = connection;
        this.handshaker = handshaker;
        V8CommandOutputImpl v8CommandOutput = new V8CommandOutputImpl(connection);
        this.debugSession = new DebugSession(this.sessionManager, CONTEXT_FILTER, v8CommandOutput, this);
    }

    @Override
    public void attach(DebugEventListener listener) throws IOException, UnsupportedVersionException, MethodIsBlockingException {
        Exception errorCause = null;
        try {
            try {
                this.attachImpl(listener);
            }
            catch (IOException e) {
                errorCause = e;
                throw e;
            }
            catch (UnsupportedVersionException e) {
                errorCause = e;
                throw e;
            }
        }
        finally {
            if (errorCause != null) {
                this.disconnectReason = errorCause;
                this.connectionState = ConnectionState.DETACHED;
                this.connection.close();
            }
        }
    }

    private void attachImpl(DebugEventListener listener) throws IOException, UnsupportedVersionException, MethodIsBlockingException {
        Handshaker.StandaloneV8.RemoteInfo remoteInfo;
        this.connectionState = ConnectionState.CONNECTING;
        Connection.NetListener netListener = new Connection.NetListener(){

            @Override
            public void connectionClosed() {
            }

            @Override
            public void eosReceived() {
                StandaloneVmImpl.this.debugSession.getV8CommandProcessor().processEos();
                StandaloneVmImpl.this.onDebuggerDetachedImpl(null);
            }

            @Override
            public void messageReceived(Message message) {
                JSONObject json;
                try {
                    json = JsonUtil.jsonObjectFromJson(message.getContent());
                }
                catch (ParseException parseException) {
                    LOGGER.log(Level.SEVERE, "Invalid JSON received: {0}", message.getContent());
                    return;
                }
                StandaloneVmImpl.this.debugSession.getV8CommandProcessor().processIncomingJson(json);
            }
        };
        this.connection.setNetListener(netListener);
        this.connection.start();
        this.connectionState = ConnectionState.EXPECTING_HANDSHAKE;
        try {
            remoteInfo = this.handshaker.getRemoteInfo().get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw StandaloneVmImpl.newIOException("Failed to get version", e);
        }
        catch (TimeoutException e) {
            throw StandaloneVmImpl.newIOException("Timed out waiting for handshake", e);
        }
        String versionString = remoteInfo.getProtocolVersion();
        if (versionString == null) {
            throw new UnsupportedVersionException(null, null);
        }
        this.savedRemoteInfo = remoteInfo;
        this.debugEventListener = listener;
        this.debugSession.startCommunication();
        this.connectionState = ConnectionState.CONNECTED;
    }

    @Override
    public boolean detach() {
        boolean res = this.onDebuggerDetachedImpl(null);
        if (!res) {
            return false;
        }
        this.connection.close();
        return true;
    }

    @Override
    public boolean isAttached() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onDebuggerDetachedImpl(Exception cause) {
        Object object = this.disconnectMonitor;
        synchronized (object) {
            block5: {
                if (this.isAttached()) break block5;
                return false;
            }
            this.connectionState = ConnectionState.DETACHED;
            this.disconnectReason = cause;
        }
        if (this.debugEventListener != null) {
            this.debugEventListener.disconnected();
        }
        return true;
    }

    @Override
    public DebugSession getDebugSession() {
        return this.debugSession;
    }

    @Override
    public String getEmbedderName() {
        return this.savedRemoteInfo.getEmbeddingHostName();
    }

    @Override
    public String getVmVersion() {
        return this.savedRemoteInfo.getV8VmVersion();
    }

    @Override
    public String getDisconnectReason() {
        Exception cause = this.disconnectReason;
        if (cause == null) {
            return null;
        }
        return cause.getMessage();
    }

    private static enum ConnectionState {
        INIT,
        CONNECTING,
        EXPECTING_HANDSHAKE,
        CONNECTED,
        DETACHED;

    }

    private static class V8CommandOutputImpl
    implements V8CommandOutput {
        private final Connection outputConnection;

        V8CommandOutputImpl(Connection outputConnection) {
            this.outputConnection = outputConnection;
        }

        @Override
        public void send(DebuggerMessage debuggerMessage, boolean immediate) {
            String jsonString = JsonUtil.streamAwareToJson(debuggerMessage);
            Message message = new Message(Collections.emptyMap(), jsonString);
            this.outputConnection.send(message);
        }

        @Override
        public void runInDispatchThread(Runnable callback) {
            this.outputConnection.runInDispatchThread(callback);
        }
    }
}

