/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumSourceDirector;
import org.eclipse.wst.jsdt.chromium.debug.core.SourceNameMapperContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.LaunchTabGroup;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.PluginVariablesUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.TabBase;

public abstract class ChromiumRemoteTab<ELEMENTS>
extends TabBase<ELEMENTS, LaunchTabGroup.Params> {
    private static final String HOST_FIELD_NAME = "host_field";
    private static final String PORT_FIELD_NAME = "port_field";
    private static final String ADD_NETWORK_CONSOLE_FIELD_NAME = "add_network_console_field";
    private static final int minimumPortValue = 0;
    private static final int maximumPortValue = 65535;
    private final SourceContainerChecker sourceContainerChecker = new SourceContainerChecker();
    static final TabBase.TabFieldList<TabElements, LaunchTabGroup.Params> BASIC_TAB_FIELDS;

    static {
        ArrayList<TabBase.TabField<Object, Object, TabElements, LaunchTabGroup.Params>> list = new ArrayList<TabBase.TabField<Object, Object, TabElements, LaunchTabGroup.Params>>(4);
        list.add(new TabBase.TabField<String, String, TabElements, LaunchTabGroup.Params>("debug_host", TabBase.TypedMethods.STRING, new TabBase.FieldEditorAccess<String, TabElements>(TabBase.TypedMethods.STRING){

            @Override
            FieldEditor getFieldEditor(TabElements tabElements) {
                return tabElements.getHost();
            }

            @Override
            String getEditorErrorValue() {
                return "";
            }
        }, new TabBase.DefaultsProvider<String, LaunchTabGroup.Params>(){

            @Override
            String getFallbackValue() {
                return PluginVariablesUtil.getValue("org.eclipse.wst.jsdt.chromium.debug.ui.chromium_debug_host");
            }

            @Override
            String getInitialConfigValue(LaunchTabGroup.Params context) {
                return this.getFallbackValue();
            }
        }, LaunchParams.ValueConverter.getTrivial()));
        list.add(new TabBase.TabField<Integer, Integer, TabElements, LaunchTabGroup.Params>("debug_port", TabBase.TypedMethods.INT, new TabBase.FieldEditorAccess<Integer, TabElements>(TabBase.TypedMethods.INT){

            @Override
            FieldEditor getFieldEditor(TabElements tabElements) {
                return tabElements.getPort();
            }

            @Override
            String getEditorErrorValue() {
                return "-1";
            }
        }, new TabBase.DefaultsProvider<Integer, LaunchTabGroup.Params>(){

            @Override
            Integer getFallbackValue() {
                return PluginVariablesUtil.getValueAsInt("org.eclipse.wst.jsdt.chromium.debug.ui.chromium_debug_port");
            }

            @Override
            Integer getInitialConfigValue(LaunchTabGroup.Params context) {
                return this.getFallbackValue();
            }
        }, LaunchParams.ValueConverter.getTrivial()));
        list.add(new TabBase.TabField<Boolean, Boolean, TabElements, LaunchTabGroup.Params>("add_network_console", TabBase.TypedMethods.BOOL, new TabBase.FieldEditorAccess<Boolean, TabElements>(TabBase.TypedMethods.BOOL){

            @Override
            FieldEditor getFieldEditor(TabElements tabElements) {
                return tabElements.getAddNetworkConsole();
            }

            @Override
            String getEditorErrorValue() {
                return "";
            }
        }, new TabBase.DefaultsProvider<Boolean, LaunchTabGroup.Params>(){

            @Override
            Boolean getFallbackValue() {
                return false;
            }

            @Override
            Boolean getInitialConfigValue(LaunchTabGroup.Params context) {
                return null;
            }
        }, LaunchParams.ValueConverter.getTrivial()));
        BASIC_TAB_FIELDS = ChromiumRemoteTab.createFieldListImpl(list);
    }

    ChromiumRemoteTab(LaunchTabGroup.Params params) {
        super(params);
    }

    @Override
    protected ELEMENTS createElements(Composite parent, Runnable modifyListener) {
        Composite composite = ChromiumRemoteTab.createDefaultComposite(parent);
        this.setControl((Control)composite);
        PreferenceStore store = new PreferenceStore();
        composite.setFont(parent.getFont());
        return this.createDialogElements(composite, modifyListener, store);
    }

    protected abstract ELEMENTS createDialogElements(Composite var1, Runnable var2, PreferenceStore var3);

    protected static TabElements createBasicTabElements(Composite composite, final Runnable modifyListener, PreferenceStore store, LaunchTabGroup.Params params) {
        Group connectionGroup = new Group(composite, 0);
        connectionGroup.setLayoutData((Object)new GridData(768));
        connectionGroup.setText(Messages.ChromiumRemoteTab_CONNECTION_GROUP);
        connectionGroup.setLayout((Layout)new GridLayout(1, false));
        IPropertyChangeListener propertyModifyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                modifyListener.run();
            }
        };
        Composite propertiesComp = ChromiumRemoteTab.createInnerComposite((Composite)connectionGroup, 2);
        final StringFieldEditor debugHost = new StringFieldEditor(HOST_FIELD_NAME, Messages.ChromiumRemoteTab_HostLabel, propertiesComp);
        debugHost.setPropertyChangeListener(propertyModifyListener);
        debugHost.setPreferenceStore((IPreferenceStore)store);
        final IntegerFieldEditor debugPort = new IntegerFieldEditor(PORT_FIELD_NAME, Messages.ChromiumRemoteTab_PortLabel, propertiesComp);
        debugPort.setPropertyChangeListener(propertyModifyListener);
        debugPort.setPreferenceStore((IPreferenceStore)store);
        final BooleanFieldEditor addNetworkConsole = new BooleanFieldEditor(ADD_NETWORK_CONSOLE_FIELD_NAME, Messages.ChromiumRemoteTab_ShowDebuggerNetworkCommunication, propertiesComp);
        addNetworkConsole.setPreferenceStore((IPreferenceStore)store);
        addNetworkConsole.setPropertyChangeListener(propertyModifyListener);
        return new TabElements(){

            @Override
            public StringFieldEditor getHost() {
                return debugHost;
            }

            @Override
            public IntegerFieldEditor getPort() {
                return debugPort;
            }

            @Override
            public BooleanFieldEditor getAddNetworkConsole() {
                return addNetworkConsole;
            }
        };
    }

    public String getName() {
        return Messages.ChromiumRemoteTab_RemoteTabName;
    }

    @Override
    protected TabBase.MessageData isValidImpl(ILaunchConfiguration config) throws CoreException {
        int port = config.getAttribute("debug_port", -1);
        if (port < 0 || port > 65535) {
            return new TabBase.MessageData(false, Messages.ChromiumRemoteTab_InvalidPortNumberError);
        }
        String message = this.getWarning(config);
        return new TabBase.MessageData(true, message);
    }

    protected String getWarning(ILaunchConfiguration config) throws CoreException {
        String hostWarning;
        HostChecker hostChecker = ((LaunchTabGroup.Params)this.getParams()).getHostChecker();
        if (hostChecker != null && (hostWarning = hostChecker.getWarning(config)) != null) {
            return hostWarning;
        }
        return this.sourceContainerChecker.check(config);
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    static interface DevToolsElements {
        public TabBase.RadioButtonsLogic<Integer> getBreakpointRadioButtons();

        public TabElements getBase();
    }

    static abstract class DevToolsProtocolBase
    extends ChromiumRemoteTab<DevToolsElements> {
        private static final TabBase.TabFieldList<? super DevToolsElements, ? super LaunchTabGroup.Params> TAB_FIELD_LIST;

        static {
            TabBase.TabField<String, String, DevToolsElements, LaunchTabGroup.Params> breakpointSyncField = new TabBase.TabField<String, String, DevToolsElements, LaunchTabGroup.Params>("breakpoint_startup_sync_direction", TabBase.TypedMethods.STRING, new TabBase.FieldAccess<String, DevToolsElements>(){

                @Override
                void setValue(String value, DevToolsElements tabElements) {
                    int breakpointOptionIndex = LaunchParams.findBreakpointOption((String)value);
                    tabElements.getBreakpointRadioButtons().select(breakpointOptionIndex);
                }

                @Override
                String getValue(DevToolsElements tabElements) {
                    int breakpointOption = tabElements.getBreakpointRadioButtons().getSelected();
                    return ((LaunchParams.BreakpointOption)LaunchParams.BREAKPOINT_OPTIONS.get(breakpointOption)).getDirectionStringValue();
                }
            }, new TabBase.DefaultsProvider<String, LaunchTabGroup.Params>(){

                @Override
                String getFallbackValue() {
                    return BreakpointSynchronizer.Direction.MERGE.toString();
                }

                @Override
                String getInitialConfigValue(LaunchTabGroup.Params context) {
                    return null;
                }
            }, LaunchParams.ValueConverter.getTrivial());
            ArrayList<TabBase.TabFieldList<DevToolsElements, Object>> subLists = new ArrayList<TabBase.TabFieldList<DevToolsElements, Object>>(2);
            subLists.add(DevToolsProtocolBase.createFieldListAdapting(BASIC_TAB_FIELDS, new TabBase.Adapter<DevToolsElements, TabElements>(){

                @Override
                public TabElements get(DevToolsElements from) {
                    return from.getBase();
                }
            }));
            subLists.add(DevToolsProtocolBase.createFieldListImpl(Collections.singletonList(breakpointSyncField)));
            TAB_FIELD_LIST = DevToolsProtocolBase.createCompositeFieldList(subLists);
        }

        DevToolsProtocolBase(LaunchTabGroup.Params params) {
            super(params);
        }

        @Override
        protected DevToolsElements createDialogElements(Composite composite, final Runnable modifyListener, PreferenceStore store) {
            final TabElements basicElements = DevToolsProtocolBase.createBasicTabElements(composite, modifyListener, store, (LaunchTabGroup.Params)this.getParams());
            TabBase.RadioButtonsLogic.Listener radioButtonsListener = new TabBase.RadioButtonsLogic.Listener(){

                @Override
                public void selectionChanged() {
                    modifyListener.run();
                }
            };
            Group breakpointGroup = new Group(composite, 0);
            breakpointGroup.setLayoutData((Object)new GridData(768));
            breakpointGroup.setText(Messages.ChromiumRemoteTab_BREAKPOINT_GROUP);
            breakpointGroup.setLayout((Layout)new GridLayout(1, false));
            LinkedHashMap<Integer, Button> buttonMap = new LinkedHashMap<Integer, Button>(3);
            for (LaunchParams.BreakpointOption option : LaunchParams.BREAKPOINT_OPTIONS) {
                Button button = new Button((Composite)breakpointGroup, 16);
                button.setFont(composite.getFont());
                button.setText(option.getLabel());
                GridData gd = new GridData();
                button.setLayoutData((Object)gd);
                SWTFactory.setButtonDimensionHint((Button)button);
                int index = buttonMap.size();
                buttonMap.put(index, button);
            }
            final TabBase.RadioButtonsLogic breakpointRadioButtons = new TabBase.RadioButtonsLogic(buttonMap, radioButtonsListener);
            return new DevToolsElements(){

                @Override
                public TabBase.RadioButtonsLogic<Integer> getBreakpointRadioButtons() {
                    return breakpointRadioButtons;
                }

                @Override
                public TabElements getBase() {
                    return basicElements;
                }
            };
        }

        @Override
        protected TabBase.TabFieldList<? super DevToolsElements, ? super LaunchTabGroup.Params> getTabFields() {
            return TAB_FIELD_LIST;
        }
    }

    public static abstract class HostChecker {
        public static HostChecker LOCAL_ONLY = new HostChecker(){

            @Override
            public String getWarning(ILaunchConfiguration config) throws CoreException {
                String host = config.getAttribute("debug_host", "");
                if (!LOCAL_HOST_NAMES.contains(host.toLowerCase())) {
                    return Messages.ChromiumRemoteTab_CONNECTION_FROM_LOCALHOST_WARNING;
                }
                return null;
            }
        };
        private static final Collection<String> LOCAL_HOST_NAMES = Arrays.asList("localhost", "127.0.0.1");

        public abstract String getWarning(ILaunchConfiguration var1) throws CoreException;
    }

    private static class SourceContainerChecker {
        private SourceContainerChecker() {
        }

        public String check(ILaunchConfiguration config) {
            ISourceLookupDirector director;
            LaunchParams.LookupMode lookupMode;
            try {
                lookupMode = ChromiumSourceDirector.readLookupMode((ILaunchConfiguration)config);
            }
            catch (CoreException e) {
                ChromiumDebugPlugin.log((Throwable)e);
                return null;
            }
            if (lookupMode != LaunchParams.LookupMode.AUTO_DETECT) {
                return null;
            }
            try {
                director = this.read(config);
            }
            catch (CoreException coreException) {
                return null;
            }
            if (director == null) {
                return null;
            }
            ISourceContainer[] iSourceContainerArray = director.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer sourceContainer = iSourceContainerArray[n2];
                if (sourceContainer instanceof SourceNameMapperContainer) {
                    return Messages.ChromiumRemoteTab_AUTO_DETECT_CONTAINER_WARNING;
                }
                ++n2;
            }
            return null;
        }

        private ISourceLookupDirector read(ILaunchConfiguration config) throws CoreException {
            ILaunchManager launchManager;
            IPersistableSourceLocator locator;
            String memento = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            if (memento == null) {
                return null;
            }
            String type = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (type == null) {
                type = config.getType().getSourceLocatorId();
            }
            if (!((locator = (launchManager = DebugPlugin.getDefault().getLaunchManager()).newSourceLocator(type)) instanceof IPersistableSourceLocator2)) {
                return null;
            }
            ISourceLookupDirector director = (ISourceLookupDirector)locator;
            director.initializeFromMemento(memento, config);
            return director;
        }
    }

    static class Standalone
    extends DevToolsProtocolBase {
        private static final LaunchTabGroup.Params PARAMS = new LaunchTabGroup.Params(null, Messages.ChromiumRemoteTab_FILE_PATH, true);

        public Standalone() {
            super(PARAMS);
        }
    }

    static interface TabElements {
        public StringFieldEditor getHost();

        public IntegerFieldEditor getPort();

        public BooleanFieldEditor getAddNetworkConsole();
    }
}

